/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocdpm.business.promotionitem;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.pojo.PromotionItemVo;
import kd.occ.ocbase.common.pojo.PromtionItemParamVO;
import org.apache.commons.collections.CollectionUtils;

public class PromotionItemResultHelper {
    private static final long wholeOrderId = 1082578038828457984L;
    private static Log logger = LogFactory.getLog(PromotionItemResultHelper.class);

    public static List<PromotionItemVo> getPromotionItemServiceResult(PromtionItemParamVO promtionItemParamVO, List<PromotionItemVo> promotionItemList) {
        List<Object> buildResultList = new ArrayList<Object>(promotionItemList.size());
        HashSet customerParamSet = new HashSet(promtionItemParamVO.getCustomIdList());
        HashSet channelParamSet = new HashSet(promtionItemParamVO.getOrderChannelIdList());
        ArrayList<PromotionItemVo> tempList = new ArrayList<PromotionItemVo>(4);
        for (PromotionItemVo vo : promotionItemList) {
            PromotionItemVo cloneVo;
            if (vo.getOrderChannelId() > 0L || vo.getCustomerId() > 0L) {
                buildResultList.add(vo);
                continue;
            }
            Sets.SetView intersectionSet = Sets.intersection(new HashSet(vo.getLinkedCustomerList()), customerParamSet);
            if (CollectionUtils.isNotEmpty((Collection)intersectionSet)) {
                for (Long customerId : intersectionSet) {
                    cloneVo = vo.deepCopy(vo);
                    cloneVo.setLinkedCustomerList(null);
                    cloneVo.setCustomerId(customerId.longValue());
                    tempList.add(cloneVo);
                }
            }
            if (!CollectionUtils.isNotEmpty((Collection)(intersectionSet = Sets.intersection(new HashSet(vo.getLinkedChannelList()), channelParamSet)))) continue;
            for (Long channelId : intersectionSet) {
                cloneVo = vo.deepCopy(vo);
                cloneVo.setLinkedChannelList(null);
                cloneVo.setOrderChannelId(channelId.longValue());
                tempList.add(cloneVo);
            }
        }
        if (CollectionUtils.isNotEmpty(tempList)) {
            buildResultList.addAll(tempList);
        }
        if (CollectionUtils.isNotEmpty((Collection)promtionItemParamVO.getMaterialIdList())) {
            buildResultList = buildResultList.stream().filter(a -> promtionItemParamVO.getMaterialIdList().contains(a.getMaterialId()) || a.getPromoteType() == 1082578038828457984L).collect(Collectors.toList());
        } else if (CollectionUtils.isNotEmpty((Collection)promtionItemParamVO.getItemIdList())) {
            buildResultList = buildResultList.stream().filter(a -> promtionItemParamVO.getItemIdList().contains(a.getItemId()) || a.getPromoteType() == 1082578038828457984L).collect(Collectors.toList());
        }
        boolean isItem = CollectionUtils.isNotEmpty((Collection)promtionItemParamVO.getOrderChannelIdList());
        Map<String, List<PromotionItemVo>> itemVoMap = buildResultList.stream().collect(Collectors.groupingBy(a -> PromotionItemResultHelper.getGroupKey(a, isItem)));
        ArrayList<PromotionItemVo> finalResultList = new ArrayList<PromotionItemVo>(8);
        for (Map.Entry<String, List<PromotionItemVo>> itemVo : itemVoMap.entrySet()) {
            List<PromotionItemVo> valuesList = itemVo.getValue();
            valuesList.sort((vo1, vo2) -> {
                if (vo1.getEffectiveDate().before(vo2.getEffectiveDate())) {
                    return 1;
                }
                if (vo1.getEffectiveDate().equals(vo2.getEffectiveDate()) && vo1.getMaterialId() > vo2.getMaterialId()) {
                    return 1;
                }
                return 0;
            });
            if (!CollectionUtils.isNotEmpty(valuesList)) continue;
            finalResultList.add(valuesList.get(0));
        }
        finalResultList.sort(Comparator.comparing(PromotionItemVo::getPolicyNumber));
        return finalResultList;
    }

    private static String getGroupKey(PromotionItemVo promotionItemVo, boolean isItem) {
        if (isItem) {
            return String.format("%d_%d_%d_%d_%d_%d_%d_%d", promotionItemVo.getPolicyId(), 0L, promotionItemVo.getItemId(), promotionItemVo.getSaleorgId(), promotionItemVo.getSalechannelId(), promotionItemVo.getOrderChannelId(), promotionItemVo.getCustomerId(), promotionItemVo.getGroupNoId());
        }
        return String.format("%d_%d_%d_%d_%d_%d_%d_%d", promotionItemVo.getPolicyId(), promotionItemVo.getMaterialId(), 0L, promotionItemVo.getSaleorgId(), promotionItemVo.getSalechannelId(), promotionItemVo.getOrderChannelId(), promotionItemVo.getCustomerId(), promotionItemVo.getGroupNoId());
    }
}

