/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.entity;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.occ.ocepfp.common.entity.SimpleMap;

public class CaseInsensitiveKeysMap<V>
extends SimpleMap<String, V> {
    private static final long serialVersionUID = 8860362696999825682L;
    private ConcurrentMap<String, String> caseInsensitiveKeys = new ConcurrentHashMap<String, String>();

    public CaseInsensitiveKeysMap() {
    }

    public CaseInsensitiveKeysMap(int columnCount) {
        super(columnCount);
    }

    @Override
    public V put(String key, V value) {
        String oldKey = this.caseInsensitiveKeys.put(this.convertKey(key), key);
        if (oldKey != null && !oldKey.equals(key)) {
            super.remove(oldKey);
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map m) {
        if (m != null) {
            for (Map.Entry entry : m.entrySet()) {
                Object key = entry.getKey();
                this.put(key.toString(), m.get(key));
            }
        }
    }

    @Override
    public V get(Object key) {
        if (key instanceof String) {
            return super.get(this.caseInsensitiveKeys.get(this.convertKey((String)key)));
        }
        return null;
    }

    protected String convertKey(String key) {
        return key.toLowerCase();
    }
}

