/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.entity;

import kd.bos.mvc.cache.PageCache;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.PageUtil;

public class OpenParam
extends SimpleMap<String, Object> {
    public static final String FORCE_LOGIN = "force_login";
    public static final String ENABLE_HISTORY = "en_his";
    private static final long serialVersionUID = 7048841007454450725L;

    public OpenParam() {
        this.setTarget(OpenTarget.MainTab);
        this.setPageId(PageUtil.getPageId());
        this.setShowTitle(true);
    }

    public OpenParam setTitle(String title) {
        this.put("title", title);
        return this;
    }

    public String getTitle() {
        return this.getString("title");
    }

    public final void setShowTitle(Boolean isShowTitle) {
        this.put("showtitle", isShowTitle);
    }

    public boolean isShowTitle() {
        return this.getBoolean("showtitle", true);
    }

    public void setHideMainTabbar(boolean isHidden) {
        this.put("hidemaintabbar", isHidden);
    }

    public void setHideReturnBack(boolean isHideReturnBack) {
        this.put("hidereturnback", isHideReturnBack);
    }

    public void setOnGoHistory(boolean isOnGoHistory) {
        this.put("gohistory", isOnGoHistory);
    }

    public void setEnabelHistory(boolean enableHistry) {
        this.put(ENABLE_HISTORY, enableHistry);
    }

    public OpenParam setViewId(String viewId) {
        this.put("viewId", viewId.toLowerCase());
        return this;
    }

    public void setQueryFilter(Object queryFilter) {
        PageCache pageCache = new PageCache(this.getPageId());
        pageCache.put("_parentFilter", JsonUtil.toString(queryFilter));
    }

    public String getViewId() {
        return this.getString("viewId");
    }

    public boolean isCloudBill() {
        String type = this.getString("ty");
        return "c".equals(type);
    }

    public void setParenPageId(String pageId) {
        this.put("parentPageId", pageId);
    }

    public final OpenParam setTarget(OpenTarget target) {
        this.put("target", target.getValue());
        return this;
    }

    public String getTarget() {
        return this.getString("target");
    }

    public OpenParam setPkValue(Object pkValue) {
        this.put("pkValue", pkValue);
        return this;
    }

    public String getPkValue() {
        return this.getString("pkValue");
    }

    public OpenParam setPostion(OpenPosition postion) {
        this.put("pos", postion.getValue());
        return this;
    }

    public String getPostion() {
        return this.getString("pos");
    }

    public OpenParam setOnlyOneTab(Boolean onlyOneTab) {
        this.put("onlyonetab", onlyOneTab.toString());
        return this;
    }

    public OpenParam addCustomParam(String key, String value) {
        this.getCustomParam().put(key, value);
        return this;
    }

    public OpenParam addCustomParam(String key, Object value) {
        this.getCustomParam().put(key, value);
        return this;
    }

    public SimpleMap<String, Object> getCustomParam() {
        SimpleMap customParam = (SimpleMap)this.get("customParam");
        if (customParam == null) {
            customParam = new SimpleMap(4);
            this.put("customParam", customParam);
        }
        return customParam;
    }

    public String getCustomParam(String key) {
        return Convert.toString(this.getCustomParam().get(key));
    }

    public final OpenParam setPageId(String pageId) {
        this.put("pageId", pageId);
        return this;
    }

    public String getPageId() {
        return this.getString("pageId");
    }

    public OpenParam setUrl(String url) {
        this.put("url", url);
        return this;
    }

    public String getUrl() {
        return this.getString("url");
    }

    public OpenParam setWidth(String width) {
        this.put("width", width);
        return this;
    }

    public String getWidth() {
        return this.getString("width");
    }

    public void setAsync(boolean isAsync) {
        this.put("async", isAsync);
    }

    public boolean isAsync() {
        return this.getBoolean("async", false);
    }

    public OpenParam setHeight(String height) {
        this.put("height", height);
        return this;
    }

    public String getHeight() {
        return this.getString("height");
    }

    public SimpleMap<String, Object> getParentInfo() {
        SimpleMap parentInfo = (SimpleMap)this.get("parent");
        if (parentInfo == null) {
            parentInfo = new SimpleMap(4);
            this.put("parent", parentInfo);
        }
        return parentInfo;
    }

    public void setParentInfo(String viewId, String pageId, String controlId) {
        SimpleMap<String, Object> parentInfo = this.getParentInfo();
        parentInfo.put("viewId", viewId);
        parentInfo.put("pageId", pageId);
        parentInfo.put("id", controlId);
    }

    public void setParentInfo(String viewId, String pageId, String controlId, int row) {
        SimpleMap<String, Object> parentInfo = this.getParentInfo();
        parentInfo.put("viewId", viewId);
        parentInfo.put("pageId", pageId);
        parentInfo.put("id", controlId);
        parentInfo.put("row", row);
    }

    public static enum OpenPosition {
        Left("left"),
        Right("right"),
        Top("top"),
        Bottom("bottom"),
        Center("center"),
        Custom("custom");

        private final String value;

        private OpenPosition(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum OpenTarget {
        MainTab("maintab"),
        NewWindow("newwindow"),
        InContainer("incontainer"),
        Pop("pop"),
        Located("poplocated"),
        Redirect("redirect");

        private final String value;

        private OpenTarget(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

