/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.util.JSONUtils;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class SimpleMap<K, V>
extends HashMap<K, V> {
    private static final long serialVersionUID = -517365032750183032L;

    public SimpleMap() {
    }

    public SimpleMap(int columnCount) {
        super(columnCount);
    }

    @JsonIgnore
    public String getString(String key) {
        return this.getString(key, null);
    }

    @JsonIgnore
    public String getString(String key, String defaultValue) {
        if (this.containsKey(key)) {
            return Convert.toString(this.get(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    @JsonIgnore
    public Integer getInt(String key, Integer defaultValue) {
        if (this.containsKey(key)) {
            return Convert.toInt(this.getString(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    @JsonIgnore
    public Long getLong(String key, Long defaultValue) {
        if (this.containsKey(key)) {
            return StringUtil.isNull(this.getString(key)) ? 0L : Convert.toLong(this.getString(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return 0L;
    }

    @JsonIgnore
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    @JsonIgnore
    public Boolean getBoolean(String key, Boolean defaultValue) {
        if (this.containsKey(key)) {
            return Convert.toBoolean(this.getString(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return false;
    }

    @JsonIgnore
    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    @JsonIgnore
    public Double getDouble(String key, Double defaultValue) {
        if (this.containsKey(key)) {
            return Convert.toDouble(this.getString(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public BigDecimal getBigDecimal(String key) {
        return this.getBigDecimal(key, null);
    }

    @JsonIgnore
    public BigDecimal getBigDecimal(String key, BigDecimal defaultValue) {
        if (this.containsKey(key)) {
            return Convert.toBigDecimal(this.getString(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public Float getFloat(String key) {
        return this.getFloat(key, Float.valueOf(0.0f));
    }

    @JsonIgnore
    public Float getFloat(String key, Float defaultValue) {
        if (this.containsKey(key)) {
            return Float.valueOf(Convert.toFloat(this.getString(key)));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    @JsonIgnore
    public Date getDate(String key, Date defaultValue) {
        if (this.containsKey(key)) {
            return DateUtil.toDate4yyyyMMdd((String)this.get(key));
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        return null;
    }

    @JsonIgnore
    public List<ExtDynamicObject> getList(String key) {
        Object so = this.get(key);
        if (so instanceof String) {
            try {
                so = JSONUtils.cast((String)so.toString(), List.class);
            }
            catch (IOException e) {
                LogUtil.error(SimpleMap.class, key + " List is Error");
                so = null;
            }
        }
        return so != null ? (List)so : null;
    }

    @JsonIgnore
    public <T> T getJson(String key, Class<T> valueType) {
        String s = this.getString(key);
        if (!StringUtil.isNull(s)) {
            try {
                return (T)JSONUtils.cast((String)s, valueType);
            }
            catch (IOException e) {
                LogUtil.error(SimpleMap.class, e);
            }
        }
        return null;
    }
}

