/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kd.occ.ocepfp.common.util.LogUtil;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class Base64Util {
    private static final String AES = "AES";
    private static final String PADDING = "AES/CBC/PKCS7Padding";

    public static final void main(String[] args) {
        System.out.println(Base64Util.decryptData(URLDecoder.decode("OkQySaxxYhum7REYI4frScaygjuetYww3r8pyRPmWPQ6f7JtBjyjBIM%2FPhECHEkOC8TMLVLVn3mFYPvD250Z6Zwzu3QdCrgbowkAzVZVg8koF1UqQQUj8MhA02N%2F7AS5vQbnzSMMS6WocRU92NETJc%2B6tQzRdCQ8vDLS35M2v7ineHHEpi4%2FwFwZ2qej3eewcIAoCXx1w4K2LbWk7e8%2BRA%3D%3D"), "Y4v5ivp06bDFFssPUIj2sw==", "YmCvg2tBzBSUWJThZ+uqzA=="));
    }

    public static String decryptData(String encryptedData, String sessionKey, String iv) {
        byte[] bytes;
        encryptedData = encryptedData.replaceAll("&#43;", "+");
        iv = iv.trim().replaceAll("&#43;", "+");
        try {
            byte[] sessionKeyByte = Base64Util.getDataByte(sessionKey);
            byte[] encryptedDataByte = Base64Util.getDataByte(encryptedData);
            byte[] ivByte = Base64Util.getDataByte(iv);
            SecretKeySpec key = new SecretKeySpec(sessionKeyByte, AES);
            AlgorithmParameters algorithmParameters = null;
            Cipher cipher = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            algorithmParameters = AlgorithmParameters.getInstance(AES);
            algorithmParameters.init(new IvParameterSpec(ivByte));
            cipher = Cipher.getInstance(PADDING);
            cipher.init(2, (Key)key, algorithmParameters);
            bytes = cipher.doFinal(encryptedDataByte);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LogUtil.error(Base64Util.class, e);
            bytes = new byte[]{};
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] getDataByte(String data) {
        int base;
        byte[] dataByte = Base64.decodeBase64((String)data.trim());
        if (dataByte.length % (base = 16) != 0) {
            int groups = dataByte.length / base + (dataByte.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(dataByte, 0, temp, 0, dataByte.length);
            dataByte = temp;
        }
        return dataByte;
    }
}

