/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;

public class BigDecimalUtil {
    private static Map<String, RoundingMode> _PrecisionAccountMap = new HashMap<String, RoundingMode>(4);
    public static final BigDecimal SYSMAXBIGDECIMAL = new BigDecimal(999999999999L);

    public static BigDecimal setScale(BigDecimal num, int newScale) {
        if (num == null) {
            return BigDecimal.ZERO.setScale(newScale, RoundingMode.DOWN);
        }
        return num.setScale(newScale, RoundingMode.DOWN);
    }

    public static BigDecimal setScale(BigDecimal num, int newScale, RoundingMode roundingMode) {
        if (num == null) {
            return BigDecimal.ZERO.setScale(newScale, roundingMode);
        }
        return num.setScale(newScale, roundingMode);
    }

    public static BigDecimal setScale(BigDecimal num, int newScale, String precisionAccount) {
        return BigDecimalUtil.setScale(num, newScale, _PrecisionAccountMap.get(precisionAccount));
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object != null) {
            return new BigDecimal(object.toString());
        }
        return BigDecimal.ZERO;
    }

    public static String getPlainString(Object object) {
        if (object instanceof Integer) {
            return object.toString();
        }
        BigDecimal number = BigDecimalUtil.toBigDecimal(object);
        return number.setScale(2, RoundingMode.DOWN).toPlainString();
    }

    static {
        _PrecisionAccountMap.put("1", RoundingMode.HALF_DOWN);
        _PrecisionAccountMap.put("2", RoundingMode.DOWN);
        _PrecisionAccountMap.put("3", RoundingMode.HALF_UP);
    }
}

