/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.util.Locale;
import kd.bos.context.RequestContext;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.enums.ClientType;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class ClientTypeUtil {
    private static Log logger = LogFactory.getLog(ClientTypeUtil.class);

    public static String getOS(String agent) {
        if (agent == null) {
            return "windows";
        }
        if ((agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("mac os x") >= 0) {
            return "ios";
        }
        if (agent.indexOf("android") >= 0) {
            return "android";
        }
        return "windows";
    }

    public static String getExplorerType(String agent) {
        if (agent == null) {
            return "normal";
        }
        if ((agent = agent.toLowerCase(Locale.ENGLISH)).indexOf("qq") >= 0) {
            return "qq";
        }
        return "normal";
    }

    public static boolean isFromMobile() {
        return ClientTypeUtil.isFromMobile(RequestContext.get().getUserAgent());
    }

    public static boolean isFromMobile(String agent) {
        boolean isMoblie = false;
        String[] mobileAgents = new String[]{"iphone", "android", "phone", "mobile", "wap", "netfront", "opera mobi", "opera mini", "ucweb", "windows ce", "symbian", "series", "webos", "sony", "blackberry", "dopod", "nokia", "samsung", "palmsource", "xda", "pieplus", "meizu", "midp", "cldc", "motorola", "foma", "docomo", "up.browser", "up.link", "blazer", "helio", "hosin", "huawei", "novarra", "coolpad", "webos", "techfaith", "palmsource", "alcatel", "amoi", "ktouch", "nexian", "ericsson", "philips", "sagem", "wellcom", "bunjalloo", "maui", "smartphone", "iemobile", "spice", "bird", "zte-", "longcos", "pantech", "gionee", "portalmmm", "jig browser", "hiptop", "benq", "haier", "^lct", "320x320", "240x320", "176x220", "w3c ", "acs-", "alav", "alca", "amoi", "audi", "avan", "benq", "bird", "blac", "blaz", "brew", "cell", "cldc", "cmd-", "dang", "doco", "eric", "hipt", "inno", "ipaq", "jigs", "kddi", "keji", "leno", "lg-c", "lg-d", "lg-g", "lge-", "maui", "maxo", "midp", "mits", "mmef", "mobi", "mot-", "moto", "mwbp", "nec-", "newt", "noki", "oper", "palm", "pana", "pant", "phil", "play", "port", "prox", "qwap", "sage", "sams", "sany", "sch-", "sec-", "send", "seri", "sgh-", "shar", "sie-", "siem", "smal", "smar", "sony", "sph-", "symb", "t-mo", "teli", "tim-", "tosh_bak", "tsm-", "upg1", "upsi", "vk-v", "voda", "wap-", "wapa", "wapi", "wapp", "wapr", "webc", "winw", "winw", "xda", "xda-", "Googlebot-Mobile"};
        logger.info("isFromMobile:" + agent);
        if (agent != null) {
            String userAgent = agent.toLowerCase(Locale.ENGLISH);
            for (String mobileAgent : mobileAgents) {
                if (userAgent.indexOf(mobileAgent) < 0) continue;
                isMoblie = true;
                break;
            }
        }
        return isMoblie;
    }

    public static boolean isFromMiniProgram() {
        LogUtil.error(ClientTypeUtil.class, String.format("Agent:%s", RequestContext.get().getUserAgent()));
        return ClientTypeUtil.isFromMiniProgram(RequestContext.get().getUserAgent());
    }

    public static boolean isFromMiniProgram(String agent) {
        ClientType clientType = ClientTypeUtil.getClientType(agent);
        if (agent != null && ClientType.MiniProgram == clientType) {
            LogUtil.error(ClientTypeUtil.class, "isFromMini:true");
            return true;
        }
        return false;
    }

    public static boolean isFromWeixin(String agent) {
        return agent != null && agent.toLowerCase(Locale.ENGLISH).indexOf("micromessenger") >= 0;
    }

    public static ClientType getClientType() {
        return ClientTypeUtil.getClientType(RequestContext.get().getUserAgent());
    }

    public static ClientType getClientType(String agent) {
        logger.info("ClientTypeUtil_getClientType agent:" + agent);
        String string = agent = StringUtil.isNull(agent) ? "" : agent.toLowerCase(Locale.ENGLISH);
        if (agent.equals("") || !ClientTypeUtil.isFromMobile(agent)) {
            return ClientType.PC;
        }
        if (agent.indexOf("micromessenger") >= 0) {
            if (agent.indexOf("miniprogram") >= 0) {
                return ClientType.MiniProgram;
            }
        } else {
            if (agent.indexOf("qing") >= 0) {
                return ClientType.YunZhiJia;
            }
            if (agent.indexOf("android.kingdee.bos") >= 0) {
                return ClientType.MobileApp;
            }
        }
        return ClientType.H5;
    }

    public static class PlatformTypeConstant {
        public static final char PC = '1';
        public static final char Mobile = '5';
    }
}

