/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.util.JSONUtils;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class Convert {
    public static final BigDecimal ZERO_BIGDECIMAL = new BigDecimal("0");
    public static final Long ZERO_LONG = 0L;
    public static final Integer ZERO_INTEGER = 0;
    public static final Double ZERO_DOUBLE = 0.0;
    public static final Float ZERO_FLOAT = Float.valueOf(0.0f);
    public static final Short ZERO_SHORT = 0;
    public static final Byte ZERO_BYTE = 0;
    static SimpleDateFormat sdf = new SimpleDateFormat(" yyyy-MM-dd HH:mm:ss ");

    public static String toString(String o) {
        if (o == null) {
            return "";
        }
        return o;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String toString(String[] strs) {
        if (strs == null || strs.length <= 0) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strs.length; ++i) {
            s.append(strs[i]);
            if (i >= strs.length - 1) continue;
            s.append(",");
        }
        return s.toString();
    }

    public static String toString(List strs) {
        return Convert.toString(strs, "");
    }

    public static String toString(List strs, String defaultValue) {
        if (strs == null || strs.size() <= 0) {
            return defaultValue;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < strs.size(); ++i) {
            s.append(strs.get(i));
            if (i >= strs.size() - 1) continue;
            s.append(",");
        }
        return s.toString();
    }

    public static BigDecimal toBigDecimal(Object o) {
        if (o == null || o != null && "".equals(o.toString().trim())) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(o.toString());
    }

    public static long toLong(String o) {
        if (StringUtil.isNull(o)) {
            return 0L;
        }
        if (o.contains(",")) {
            o = o.replace(",", "");
        }
        return Long.parseLong(o.trim());
    }

    public static long toLong(Object o) {
        return Convert.toLong(Convert.toString(o));
    }

    public static int toInt(String o) {
        if (o == null || o.equals("")) {
            return 0;
        }
        int num = 0;
        try {
            num = Integer.parseInt(o);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
        return num;
    }

    public static int toInt(Object o) {
        return Convert.toInt(Convert.toString(o));
    }

    public static boolean toBoolean(String o) {
        return Boolean.parseBoolean(o) || o != null && o.equalsIgnoreCase("1");
    }

    public static boolean toBoolean(Object o) {
        return Convert.toBoolean(o, true);
    }

    public static boolean toBoolean(Object o, boolean defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        return Convert.toBoolean(Convert.toString(o));
    }

    public static double toDouble(String o) {
        if (o.contains(",") || o.contains("$") || o.contains("\uffe5")) {
            o = o.replace(",", "").replace("$", "").replace("\uffe5", "");
        }
        if (StringUtil.isNull(o)) {
            o = "0";
        }
        return Double.parseDouble(o);
    }

    public static float toFloat(String o) {
        if (StringUtil.isNull(o)) {
            o = "0";
        }
        return Float.parseFloat(o);
    }

    public static Date toDate(String o) {
        if (StringUtil.isNull(o)) {
            return null;
        }
        try {
            return sdf.parse(o);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static List<Long> toLongList(String o) {
        ArrayList<Long> shopCartIds = new ArrayList<Long>(16);
        for (String shopCartIdString : o.split(",")) {
            shopCartIds.add(Convert.toLong(shopCartIdString));
        }
        return shopCartIds;
    }

    public static Long[] toLongArray(String[] o) {
        Long[] longValues = null;
        if (o != null && o.length > 0) {
            longValues = new Long[o.length];
            for (int i = 0; i < o.length; ++i) {
                longValues[i] = Long.parseLong(o[i]);
            }
        }
        return longValues;
    }

    public static ExtDynamicObject toExtDynamicObject(Object o) {
        if (o != null) {
            try {
                return (ExtDynamicObject)JSONUtils.cast((String)o.toString(), ExtDynamicObject.class);
            }
            catch (IOException e) {
                LogUtil.error(Convert.class, e);
            }
        }
        return null;
    }

    public static final void main(String[] args) {
        String a = "{\"pageInfo\":{\"goodsList\":{\"page\":1,\"pageSize\":200}},\"filter\":{},\"selectall\":{\"goodsList\":false},\"selections\":{\"goodsList\":[{\"row\":0,\"goodsList_uqrow\":\"0\",\"selected\":false},{\"row\":1,\"goodsList_uqrow\":\"1\",\"selected\":false},{\"row\":2,\"goodsList_uqrow\":\"2\"},{\"row\":3,\"goodsList_uqrow\":\"3\"},{\"row\":4,\"goodsList_uqrow\":\"4\"},{\"row\":5,\"goodsList_uqrow\":\"5\"},{\"row\":6,\"goodsList_uqrow\":\"6\"},{\"row\":7,\"goodsList_uqrow\":\"7\"},{\"row\":8,\"goodsList_uqrow\":\"8\"},{\"row\":9,\"goodsList_uqrow\":\"9\"},{\"row\":10,\"goodsList_uqrow\":\"10\"},{\"row\":11,\"goodsList_uqrow\":\"11\"},{\"row\":12,\"goodsList_uqrow\":\"12\"},{\"row\":13,\"goodsList_uqrow\":\"13\"},{\"row\":14,\"goodsList_uqrow\":\"14\"},{\"row\":15,\"goodsList_uqrow\":\"15\"},{\"row\":16,\"goodsList_uqrow\":\"16\"},{\"row\":17,\"goodsList_uqrow\":\"17\"},{\"row\":18,\"goodsList_uqrow\":\"18\"},{\"row\":19,\"goodsList_uqrow\":\"19\"},{\"row\":20,\"goodsList_uqrow\":\"20\"},{\"row\":21,\"goodsList_uqrow\":\"21\"},{\"row\":22,\"goodsList_uqrow\":\"22\"},{\"row\":23,\"goodsList_uqrow\":\"23\"},{\"row\":24,\"goodsList_uqrow\":\"24\"},{\"row\":25,\"goodsList_uqrow\":\"25\"},{\"row\":26,\"goodsList_uqrow\":\"26\"},{\"row\":27,\"goodsList_uqrow\":\"27\"},{\"row\":28,\"goodsList_uqrow\":\"28\"},{\"row\":29,\"goodsList_uqrow\":\"29\"},{\"row\":30,\"goodsList_uqrow\":\"30\"},{\"row\":31,\"goodsList_uqrow\":\"31\"},{\"row\":32,\"goodsList_uqrow\":\"32\"},{\"row\":33,\"goodsList_uqrow\":\"33\"},{\"row\":34,\"goodsList_uqrow\":\"34\"},{\"row\":35,\"goodsList_uqrow\":\"35\"},{\"row\":36,\"goodsList_uqrow\":\"36\"},{\"row\":37,\"goodsList_uqrow\":\"37\"},{\"row\":38,\"goodsList_uqrow\":\"38\"},{\"row\":39,\"goodsList_uqrow\":\"39\"},{\"row\":40,\"goodsList_uqrow\":\"40\"},{\"row\":41,\"goodsList_uqrow\":\"41\"},{\"row\":42,\"goodsList_uqrow\":\"42\"},{\"row\":43,\"goodsList_uqrow\":\"43\"},{\"row\":44,\"goodsList_uqrow\":\"44\"},{\"row\":45,\"goodsList_uqrow\":\"45\"},{\"row\":46,\"goodsList_uqrow\":\"46\"},{\"row\":47,\"goodsList_uqrow\":\"47\"},{\"row\":48,\"goodsList_uqrow\":\"48\"},{\"row\":49,\"goodsList_uqrow\":\"49\"},{\"row\":50,\"goodsList_uqrow\":\"50\"},{\"row\":51,\"goodsList_uqrow\":\"51\"},{\"row\":52,\"goodsList_uqrow\":\"52\"},{\"row\":53,\"goodsList_uqrow\":\"53\"},{\"row\":54,\"goodsList_uqrow\":\"54\"},{\"row\":55,\"goodsList_uqrow\":\"55\"},{\"row\":56,\"goodsList_uqrow\":\"56\"},{\"row\":57,\"goodsList_uqrow\":\"57\"},{\"row\":58,\"goodsList_uqrow\":\"58\"},{\"row\":59,\"goodsList_uqrow\":\"59\"},{\"row\":60,\"goodsList_uqrow\":\"60\"},{\"row\":61,\"goodsList_uqrow\":\"61\"},{\"row\":62,\"goodsList_uqrow\":\"62\"},{\"row\":62,\"goodsList_uqrow\":\"62\"},{\"row\":63,\"goodsList_uqrow\":\"63\"},{\"row\":64,\"goodsList_uqrow\":\"64\"},{\"row\":65,\"goodsList_uqrow\":\"65\"},{\"row\":66,\"goodsList_uqrow\":\"66\"},{\"row\":67,\"goodsList_uqrow\":\"67\"},{\"row\":68,\"goodsList_uqrow\":\"68\"},{\"row\":69,\"goodsList_uqrow\":\"69\"},{\"row\":70,\"goodsList_uqrow\":\"70\"},{\"row\":71,\"goodsList_uqrow\":\"71\"},{\"row\":72,\"goodsList_uqrow\":\"72\"},{\"row\":73,\"goodsList_uqrow\":\"73\"},{\"row\":74,\"goodsList_uqrow\":\"74\"},{\"row\":75,\"goodsList_uqrow\":\"75\"},{\"row\":76,\"goodsList_uqrow\":\"76\"},{\"row\":77,\"goodsList_uqrow\":\"77\"},{\"row\":78,\"goodsList_uqrow\":\"78\"},{\"row\":79,\"goodsList_uqrow\":\"79\"},{\"row\":80,\"goodsList_uqrow\":\"80\"},{\"row\":81,\"goodsList_uqrow\":\"81\"},{\"row\":82,\"goodsList_uqrow\":\"82\"},{\"row\":83,\"goodsList_uqrow\":\"83\"},{\"row\":83,\"goodsList_uqrow\":\"83\"},{\"row\":84,\"goodsList_uqrow\":\"84\"},{\"row\":85,\"goodsList_uqrow\":\"85\"},{\"row\":86,\"goodsList_uqrow\":\"86\"},{\"row\":87,\"goodsList_uqrow\":\"87\"},{\"row\":87,\"goodsList_uqrow\":\"87\"},{\"row\":88,\"goodsList_uqrow\":\"88\"},{\"row\":89,\"goodsList_uqrow\":\"89\"},{\"row\":90,\"goodsList_uqrow\":\"90\"},{\"row\":91,\"goodsList_uqrow\":\"91\"},{\"row\":92,\"goodsList_uqrow\":\"92\"},{\"row\":93,\"goodsList_uqrow\":\"93\"},{\"row\":94,\"goodsList_uqrow\":\"94\"},{\"row\":95,\"goodsList_uqrow\":\"95\"},{\"row\":96,\"goodsList_uqrow\":\"96\"},{\"row\":97,\"goodsList_uqrow\":\"97\"},{\"row\":98,\"goodsList_uqrow\":\"98\"},{\"row\":99,\"goodsList_uqrow\":\"99\"},{\"row\":100,\"goodsList_uqrow\":\"100\"},{\"row\":101,\"goodsList_uqrow\":\"101\"},{\"row\":102,\"goodsList_uqrow\":\"102\"},{\"row\":103,\"goodsList_uqrow\":\"103\"},{\"row\":104,\"goodsList_uqrow\":\"104\"},{\"row\":105,\"goodsList_uqrow\":\"105\"},{\"row\":106,\"goodsList_uqrow\":\"106\"},{\"row\":107,\"goodsList_uqrow\":\"107\"},{\"row\":108,\"goodsList_uqrow\":\"108\"},{\"row\":109,\"goodsList_uqrow\":\"109\"},{\"row\":110,\"goodsList_uqrow\":\"110\"},{\"row\":111,\"goodsList_uqrow\":\"111\"},{\"row\":112,\"goodsList_uqrow\":\"112\"},{\"row\":112,\"goodsList_uqrow\":\"112\"},{\"row\":113,\"goodsList_uqrow\":\"113\"},{\"row\":114,\"goodsList_uqrow\":\"114\"},{\"row\":115,\"goodsList_uqrow\":\"115\"},{\"row\":116,\"goodsList_uqrow\":\"116\"},{\"row\":117,\"goodsList_uqrow\":\"117\"},{\"row\":118,\"goodsList_uqrow\":\"118\"},{\"row\":119,\"goodsList_uqrow\":\"119\"},{\"row\":120,\"goodsList_uqrow\":\"120\"},{\"row\":121,\"goodsList_uqrow\":\"121\"},{\"row\":122,\"goodsList_uqrow\":\"122\"},{\"row\":123,\"goodsList_uqrow\":\"123\"},{\"row\":124,\"goodsList_uqrow\":\"124\",\"selected\":false},{\"row\":125,\"goodsList_uqrow\":\"125\"},{\"row\":126,\"goodsList_uqrow\":\"126\"},{\"row\":127,\"goodsList_uqrow\":\"127\"},{\"row\":128,\"goodsList_uqrow\":\"128\"},{\"row\":129,\"goodsList_uqrow\":\"129\"},{\"row\":130,\"goodsList_uqrow\":\"130\"},{\"row\":131,\"goodsList_uqrow\":\"131\"},{\"row\":132,\"goodsList_uqrow\":\"132\"},{\"row\":133,\"goodsList_uqrow\":\"133\"},{\"row\":134,\"goodsList_uqrow\":\"134\"},{\"row\":135,\"goodsList_uqrow\":\"135\"},{\"row\":135,\"goodsList_uqrow\":\"135\"}]},\"currentSelection\":{\"goodsList\":{\"row\":123,\"goodsList_uqrow\":\"123\"}}}";
        ExtDynamicObject b = JsonUtil.readValue(a, ExtDynamicObject.class);
        b.get("selections");
    }

    public static Object toInstance(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            LogUtil.error(Convert.class, e.getMessage());
        }
        catch (IllegalAccessException e) {
            LogUtil.error(Convert.class, e.getMessage());
        }
        catch (ClassNotFoundException e) {
            LogUtil.error(Convert.class, e.getMessage());
        }
        return null;
    }

    public static Class toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LogUtil.error(Convert.class, e.getMessage());
            return null;
        }
    }
}

