/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocepfp.common.util.StringUtil;

public class DateUtil {
    static Pattern cstTime = Pattern.compile(".*(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec).*");

    public static final String getCurrentDateStr() {
        return DateUtil.toDateStr(new Date());
    }

    public static final String toDateStr(Date date, String formatPattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatPattern);
        return formatter.format(date);
    }

    public static final String toDateStr(String formatPattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatPattern);
        return formatter.format(new Date());
    }

    public static final String toDateStr(Date currentTime) {
        if (currentTime == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(currentTime);
    }

    public static final String toShortDateStr(Object date) {
        return DateUtil.toShortDateStr(date.toString());
    }

    public static final String toShortDateStr(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static final String toShortDateStr(String date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        return formatter.format(date);
    }

    public static final Date toDate(String dateStr, String formatPattern) {
        if (StringUtil.isNull(dateStr)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat(formatPattern);
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static final Date toDate(Object dateStr) {
        if (dateStr == null) {
            return null;
        }
        return DateUtil.toDate(dateStr.toString());
    }

    public static final Date toDate(Object dateStr, String formatPattern) {
        if (dateStr == null) {
            return null;
        }
        return DateUtil.toDate(dateStr.toString(), formatPattern);
    }

    public static final Date toDate(String dateStr) {
        if (StringUtil.isNull(dateStr)) {
            return null;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return formatter.parse(dateStr);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static int getTimeDistance(Date beginDate, Date endDate) {
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(beginDate);
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(endDate);
        long beginTime = beginCalendar.getTime().getTime();
        long endTime = endCalendar.getTime().getTime();
        int betweenDays = (int)((endTime - beginTime) / 86400000L);
        endCalendar.add(5, -betweenDays);
        int diffDay = endTime - beginTime > 0L ? -1 : 1;
        endCalendar.add(5, diffDay);
        if (beginCalendar.get(5) == endCalendar.get(5)) {
            return betweenDays - diffDay;
        }
        return betweenDays;
    }

    public static final Date toDate4TimeMillis(String dateStr) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateFormat = formatter.format(Long.parseLong(dateStr));
        return DateUtil.toDate4yyyyMMdd(dateFormat);
    }

    public static final String toDate4yyyyMMStr(Date date) {
        return DateUtil.toDate4yyyyMMStr(date, "yyyy-MM");
    }

    public static final String toDate4yyyyMMStr(Date date, String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        String dateFormat = formatter.format(date);
        return dateFormat;
    }

    public static final Date toDate4yyyyMMdd(String dateStr) {
        if (dateStr.indexOf(":") < 0) {
            return DateUtil.toDate(dateStr);
        }
        if (DateUtil.isCSTTime(dateStr)) {
            try {
                SimpleDateFormat sdf1 = null;
                sdf1 = new SimpleDateFormat("EEE MMM dd HH:mm:ss Z yyyy", Locale.UK);
                return sdf1.parse(dateStr);
            }
            catch (ParseException sdf1) {
                // empty catch block
            }
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String dateToParse = "";
        if (dateStr.indexOf("/") > -1) {
            dateStr = dateStr.replaceAll("/", "-");
        }
        if (dateStr.indexOf("-") < 0) {
            if (dateStr.length() >= 8) {
                dateToParse = dateStr.substring(0, 4) + "-" + dateStr.substring(4, 6) + "-" + dateStr.substring(6, 8);
            }
            if (dateStr.length() == 14) {
                dateToParse = dateToParse + " " + dateStr.substring(8, 10) + ":" + dateStr.substring(10, 12) + ":" + dateStr.substring(12, 14);
            }
        } else {
            dateToParse = dateStr;
        }
        try {
            return formatter.parse(dateToParse);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static final Date formatBeginTime(Date currentTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentTime);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date beginDate = new Date(cal.getTime().getTime());
        return beginDate;
    }

    public static final Date formatEndTime(Date currentTime) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(currentTime);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 59);
        Date endTime = new Date(cal.getTime().getTime());
        return endTime;
    }

    public static Date getZeroDate(Date date) {
        long zero = System.currentTimeMillis() / 86400000L * 86400000L - (long)TimeZone.getDefault().getRawOffset();
        date.setTime(zero);
        return date;
    }

    public static Date getEndDate(Date date) {
        long twelve = DateUtil.getZeroDate(date).getTime() + 86400000L - 1L;
        date.setTime(twelve);
        return date;
    }

    public static Date getDate(int year, int month, int dayOfMonth, int hourOfDay, int minute, int second, int milliSecond) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month, dayOfMonth, hourOfDay, minute, second);
        if (milliSecond < 0) {
            milliSecond = 0;
        } else if (milliSecond >= 1000) {
            milliSecond = 999;
        }
        cal.set(14, milliSecond);
        return cal.getTime();
    }

    public static void main(String[] args) {
        System.out.println(DateUtil.toDate4yyyyMMStr(new Date(System.currentTimeMillis()), "yyyy/MM"));
    }

    public static final boolean isSameDay(Date d1, Date d2) {
        LocalDate localDate1 = ZonedDateTime.ofInstant(d1.toInstant(), ZoneId.systemDefault()).toLocalDate();
        LocalDate localDate2 = ZonedDateTime.ofInstant(d2.toInstant(), ZoneId.systemDefault()).toLocalDate();
        return localDate1.isEqual(localDate2);
    }

    public static Date calculateDate(Date date, int field, int amount) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(field, amount);
        return cal.getTime();
    }

    public static Date formateCutomerDate4Distribution(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (cal.get(11) >= 15) {
                cal.add(5, 1);
                return cal.getTime();
            }
            return date;
        }
        return date;
    }

    public static int getYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static int getMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(5);
    }

    public static int getHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinute(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getSecond(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(13);
    }

    public static long getMillis(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(14);
    }

    public static Date getDate(int field, int amount, DateResetType dateResetType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(field, amount);
        DateUtil.reset(calendar, dateResetType);
        return calendar.getTime();
    }

    public static Date getDate(Date start, int days, DateResetType dateResetType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(start);
        calendar.add(5, days);
        DateUtil.reset(calendar, dateResetType);
        return calendar.getTime();
    }

    public static Date getDate(int addDay, DateResetType dateResetType) {
        return DateUtil.getDate(new Date(), addDay, dateResetType);
    }

    public static Date getCurrentDate(DateResetType dateResetType) {
        return DateUtil.getDate(new Date(), 0, dateResetType);
    }

    public static Date getCurrentDate() {
        return DateUtil.getDate(new Date(), 0, DateResetType.none);
    }

    private static final boolean isCSTTime(String dateStr) {
        if (StringUtil.isNotNull(dateStr)) {
            Matcher match = cstTime.matcher(dateStr);
            return match.find();
        }
        return false;
    }

    public static Date getFirstDayOfWeek() {
        return DateUtil.getFirstDayOfWeek(DateResetType.min);
    }

    public static Date getFirstDayOfWeek(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(7, 1);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    public static Date getLastDayOfWeek() {
        return DateUtil.getLastDayOfWeek(DateResetType.max);
    }

    public static Date getLastDayOfWeek(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(7, 1);
        c.add(6, 6);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    public static Date getFirstDayOfYear() {
        return DateUtil.getFirstDayOfYear(DateResetType.min);
    }

    public static Date getFirstDayOfYear(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(6, 1);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    public static Date getLastDayOfYear() {
        return DateUtil.getLastDayOfYear(DateResetType.max);
    }

    public static Date getLastDayOfYear(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(6, 1);
        c.add(6, -1);
        c.add(1, 1);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    public static Date getFirstDayOfMonth() {
        return DateUtil.getFirstDayOfMonth(DateResetType.min);
    }

    public static Date getFirstDayOfMonth(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    public static Date getLastDayOfMonth() {
        return DateUtil.getLastDayOfMonth(DateResetType.max);
    }

    public static Date getLastDayOfMonth(DateResetType dateResetType) {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.add(2, 1);
        c.add(6, -1);
        DateUtil.reset(c, dateResetType);
        return c.getTime();
    }

    private static void reset(Calendar c, DateResetType dateResetType) {
        if (dateResetType == DateResetType.min) {
            DateUtil.reset0000(c);
        } else if (dateResetType == DateResetType.max) {
            DateUtil.reset235959(c);
        }
    }

    private static void reset0000(Calendar c) {
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
    }

    private static void reset235959(Calendar c) {
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        c.set(14, 999);
    }

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static int countDaysInMonth() {
        return LocalDate.now().getMonth().getValue();
    }

    public static Date getPastMonthOfDate() {
        return DateUtil.calculateDate(TimeServiceHelper.now(), 5, -1 * DateUtil.countDaysInMonth());
    }

    public static int getSecondsDistance(long timeStamp) {
        long beginTime = TimeServiceHelper.getTimeStamp();
        int betweenSeconds = (int)((timeStamp - beginTime) / 1000L);
        return betweenSeconds;
    }

    public static int daysBetween(Date smdate, Date bdate) {
        boolean flay = false;
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long day = time2 - time1;
        if (day < 0L) {
            flay = true;
            day = time1 - time2;
        }
        long between_days = day / 86400000L;
        if (flay) {
            return Integer.parseInt(String.valueOf(between_days));
        }
        return -1 * Integer.parseInt(String.valueOf(between_days));
    }

    public static enum DateResetType {
        min,
        max,
        none;

    }
}

