/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kd.occ.ocepfp.common.util.LogUtil;

public class GZIPUtils {
    public static final String GZIP_ENCODE_UTF_8 = "UTF-8";
    public static final String GZIP_ENCODE_ISO_8859_1 = "ISO-8859-1";

    public static byte[] compress(String str) {
        return GZIPUtils.compress(str, GZIP_ENCODE_UTF_8);
    }

    public static byte[] compress(String str, String encoding) {
        if (str == null || str.length() == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(str.getBytes(encoding));
            gzip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static byte[] compress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(bytes);
            gzip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static byte[] uncompress(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }

    public static String uncompressToString(byte[] bytes) {
        return GZIPUtils.uncompressToString(bytes, GZIP_ENCODE_UTF_8);
    }

    public static String uncompressToString(byte[] bytes, String encoding) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            int n;
            GZIPInputStream ungzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = ungzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return out.toString(encoding);
        }
        catch (IOException e) {
            LogUtil.info(GZIPUtils.class, e);
            return null;
        }
    }

    public static String uncompressByBase64(String base64Str) {
        byte[] b = Base64.getMimeDecoder().decode(base64Str);
        return GZIPUtils.uncompressToString(b);
    }

    public static String compressByBase64(String str) {
        byte[] b = GZIPUtils.compress(str);
        return Base64.getMimeEncoder().encodeToString(b);
    }

    public static final String unGzip(String gzipStr) {
        String value = GZIPUtils.uncompressToString(Base64.getMimeDecoder().decode(gzipStr));
        return value;
    }
}

