/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.response.ResponseHeaderManage;
import kd.bos.util.JSONUtils;
import kd.occ.ocepfp.common.util.LogUtil;

public class ResponseOutUtil {
    private static Log logger = LogFactory.getLog(ResponseOutUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeString(HttpServletResponse servletResponse, String str) throws IOException {
        try (OutputStreamWriter writer = null;){
            servletResponse.setContentType("text/html;charset=utf-8");
            writer = new OutputStreamWriter((OutputStream)servletResponse.getOutputStream(), StandardCharsets.UTF_8);
            writer.write(str);
            writer.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeHtmlTemplateString(HttpServletResponse servletResponse, String str, Map data) {
        BufferedReader in = new BufferedReader(new InputStreamReader(ResponseOutUtil.class.getResourceAsStream("/" + str)));
        StringBuilder buffer = new StringBuilder();
        String line = "";
        try {
            while ((line = in.readLine()) != null) {
                buffer.append(line).append("\r\n");
            }
            String input = buffer.toString();
            for (Object key : data.keySet()) {
                input = input.replaceAll("\\$\\{" + key.toString() + "\\}", data.get(key.toString()).toString());
            }
            ResponseOutUtil.writeString(servletResponse, input);
        }
        catch (IOException e) {
            LogUtil.info(ResponseOutUtil.class, e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static final void writeJsonString(HttpServletResponse response, Object data) throws IOException {
        ResponseOutUtil.writeJsonString(response, JSONUtils.toString((Object)data));
    }

    public static final void writeJsonString(HttpServletResponse response, String jsonString) throws IOException {
        ResponseOutUtil.writeResponseHeader((ServletResponse)response);
        response.setContentType("text/json;charset=utf-8");
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream((OutputStream)response.getOutputStream()), StandardCharsets.UTF_8);){
            writer.write(jsonString);
        }
    }

    private static void writeResponseHeader(ServletResponse response) {
        if (response instanceof HttpServletResponse) {
            HttpServletResponse res = (HttpServletResponse)response;
            Map headers = ResponseHeaderManage.getHeaders();
            headers.forEach((k, v) -> res.addHeader(k, v));
        }
    }
}

