/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import kd.occ.ocepfp.common.util.LogUtil;

public class StringUtil {
    public static final String EmptyString = "";

    public static boolean isNull(String o) {
        return o == null || o.trim().equals(EmptyString);
    }

    public static boolean isNull(Object o) {
        return o == null || StringUtil.isNull(o.toString());
    }

    public static boolean isNotNull(String o) {
        return o != null && o.trim().length() > 0;
    }

    public static final String toLowerCase(String o) {
        return StringUtil.isNotNull(o) ? o.toLowerCase() : o;
    }

    public static final String toLowerCase(Object o) {
        return StringUtil.isNotNull(o) ? o.toString().toLowerCase() : EmptyString;
    }

    public static boolean isNotNull(Object o) {
        return o != null && StringUtil.isNotNull(o.toString());
    }

    public static String toString(InputStream in) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int i;
            while ((i = in.read()) != -1) {
                baos.write(i);
            }
            return baos.toString();
        }
        catch (IOException e) {
            LogUtil.info(StringUtil.class, e);
            return EmptyString;
        }
    }

    public static String join(Object[] strs, String splitChar) {
        if (strs == null) {
            return EmptyString;
        }
        return StringUtil.join(strs, strs.length - 1, splitChar);
    }

    public static String join(Object[] strs, int maxIndex, String splitChar) {
        if (strs == null) {
            return EmptyString;
        }
        if (maxIndex == -1) {
            return EmptyString;
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(strs[i].toString());
            if (i == maxIndex) {
                return b.toString();
            }
            b.append(splitChar);
            ++i;
        }
    }

    public static List<String> toList(String strs) {
        if (StringUtil.isNull(strs)) {
            return null;
        }
        return Arrays.asList(strs.split(","));
    }

    public static String getEmptyString() {
        return EmptyString;
    }

    public static String getErrorMsg(Exception e) {
        StackTraceElement[] traceElements;
        StringBuilder a = new StringBuilder();
        a.append(e.getMessage()).append("\r\n");
        for (StackTraceElement traceElement : traceElements = e.getStackTrace()) {
            a.append(traceElement.toString()).append("\r\n");
        }
        return a.toString();
    }
}

