/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.FileNameUtils;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class WebUtil {
    private static Log Logger = LogFactory.getLog(WebUtil.class);
    private static final String CONTENTTYPE = "application/json";
    private static final String DEFAULT_CHARSETS = StandardCharsets.UTF_8.name();
    private static final String POST = "POST";
    private static FileService fileService = FileServiceFactory.getImageFileService();

    public static JSONObject getHttpClientPostData(String url) {
        return WebUtil.getHttpClientPostData(url, null);
    }

    public static JSONObject getHttpClientPostData(String url, LinkedHashMap<String, String> requestMap) {
        String returnData = WebUtil.httpClientPost(url, requestMap);
        return JSONObject.parseObject((String)returnData);
    }

    public static String httpClientPost(String postUrl, LinkedHashMap<String, String> requestMap) {
        return WebUtil.httpClientPost(postUrl, requestMap, DEFAULT_CHARSETS);
    }

    public static String httpClientPost(String postUrl, LinkedHashMap<String, String> requestMap, String codingType) {
        return WebUtil.httpClient(postUrl, POST, WebUtil.buildRequestData(requestMap, codingType), codingType);
    }

    public static String httpClientPost(String postUrl, String requestData) {
        return WebUtil.httpClient(postUrl, POST, requestData, DEFAULT_CHARSETS);
    }

    public static JSONObject httpClientPost(String postUrl, JSONObject requestJson) {
        String result = WebUtil.httpClient(postUrl, POST, requestJson.toJSONString(), DEFAULT_CHARSETS);
        return JSONObject.parseObject((String)result);
    }

    public static JSONObject httpClientResultJson(String postUrl, String requestData) {
        return JSONObject.parseObject((String)WebUtil.httpClient(postUrl, POST, requestData, DEFAULT_CHARSETS));
    }

    public static String httpClientPost(String postUrl, String requestData, String codingType) {
        return WebUtil.httpClient(postUrl, POST, requestData, codingType);
    }

    public static String buildRequestData(LinkedHashMap<String, String> requestMap, String codingType) {
        if (requestMap == null || requestMap.size() == 0) {
            return "";
        }
        StringBuilder requestData = new StringBuilder();
        for (Map.Entry<String, String> entry : requestMap.entrySet()) {
            if (StringUtil.isNotNull(requestData)) {
                requestData.append('&');
            }
            requestData.append(entry.getKey()).append('=').append(WebUtil.encode(entry.getValue(), codingType));
        }
        return requestData.toString();
    }

    private static String httpClient(String postUrl, String requestMethod, String requestData, String charset) {
        return WebUtil.httpClient(postUrl, requestMethod, requestData, null, charset);
    }

    public static String httpClientWithHeadsMap(String postUrl, String requestData, Map<String, String> headsMap) {
        return WebUtil.httpClient(postUrl, POST, requestData, headsMap, DEFAULT_CHARSETS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String httpClient(String postUrl, String requestMethod, String requestData, Map<String, String> headsMap, String charset) {
        CloseableHttpClient httpClient = HttpClients.createDefault();
        try {
            HttpPost httpPost = new HttpPost(postUrl);
            httpPost.setHeader("Content-type", CONTENTTYPE);
            if (headsMap != null && !headsMap.isEmpty()) {
                headsMap.forEach((key, value) -> httpPost.addHeader(key, value));
            }
            if (StringUtil.isNotNull(requestData)) {
                StringEntity requestEntity = new StringEntity(requestData, charset);
                requestEntity.setContentType(CONTENTTYPE);
                requestEntity.setContentEncoding(charset);
                httpPost.setEntity((HttpEntity)requestEntity);
            }
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                Logger.error((Throwable)e);
            }
        }
        return null;
    }

    public static String httpClientGet(String url) {
        return kd.occ.ocdbd.common.util.WebUtil.httpClientGet((String)url);
    }

    public static String encode(String content, String codingType) {
        try {
            return URLEncoder.encode(content, codingType);
        }
        catch (Exception e) {
            Logger.info(e.getMessage());
            return "";
        }
    }

    public static String doGetQrCode(String url) {
        return kd.occ.ocdbd.common.util.WebUtil.doGetQrCode((String)url);
    }

    private static String getQrCodeUrl(long timeStamp, String fullName) {
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        String pkId = Convert.toString(timeStamp);
        return FileNameUtils.getImageFileName((String)tenantId, (String)accountId, (String)"epfp", (String)"MiniProgramVersionPlugin", (Object)pkId, (String)fullName);
    }
}

