/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.util;

import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.RandomUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class XMLUtil {
    public static final Document getDocument(String xmlStr, String ... key) throws DocumentException {
        try {
            return DocumentHelper.parseText((String)xmlStr);
        }
        catch (DocumentException e) {
            if (key != null && key.length > 0) {
                LogUtil.error(XMLUtil.class, "view " + key[0] + " parser is error! ");
            } else {
                LogUtil.error(XMLUtil.class, e.getMessage(), e);
            }
            throw new DocumentException((Throwable)e);
        }
    }

    public static final Document copy2New(Document sourceDocument, boolean setIdIfIdIsNull) {
        Document newDocument = DocumentHelper.createDocument();
        newDocument.addElement("pageview");
        XMLUtil.cloneElementAttribute(sourceDocument.getRootElement(), newDocument.getRootElement());
        XMLUtil.copy2New(sourceDocument.getRootElement(), newDocument.getRootElement(), setIdIfIdIsNull);
        return newDocument;
    }

    private static final void copy2New(Element sourceParentElement, Element targetParentElement, boolean setIdIfIdIsNull) {
        Iterator node = sourceParentElement.elementIterator();
        while (node.hasNext()) {
            Element sourceElement = (Element)node.next();
            if (StringUtil.isNull(sourceElement.getName())) continue;
            if (setIdIfIdIsNull) {
                XMLUtil.setIdIfIdIsNull(sourceElement);
            }
            Element targetElement = targetParentElement.addElement(sourceElement.getName());
            XMLUtil.cloneElementAttribute(sourceElement, targetElement);
            if (sourceElement.nodeCount() <= 0) continue;
            XMLUtil.copy2New(sourceElement, targetElement, setIdIfIdIsNull);
        }
    }

    private static void setIdIfIdIsNull(Element element) {
        if (StringUtil.isNull(element.attributeValue("id"))) {
            String id;
            String name;
            switch (name = element.getName()) {
                case "view": {
                    id = "view";
                    break;
                }
                case "operations": {
                    id = "operations";
                    break;
                }
                case "plugins": 
                case "validations": 
                case "parameters": {
                    id = (element.getParent().attributeValue("id") + "_" + element.getName()).toLowerCase();
                    break;
                }
                default: {
                    id = (name + RandomUtil.getRandomString(5)).toLowerCase();
                }
            }
            element.setAttributeValue("id", id);
        }
    }

    private static void cloneElementAttribute(Element sourceParentElement, Element targetParentElement) {
        Iterator attributes = sourceParentElement.attributeIterator();
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            targetParentElement.addAttribute(attribute.getName(), attribute.getValue());
        }
        if (sourceParentElement.getName().equalsIgnoreCase("html") && StringUtil.isNotNull(sourceParentElement.getText())) {
            targetParentElement.setText(sourceParentElement.getText());
        }
    }

    public static String formatXml(Document document) throws Exception {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding("UTF-8");
        format.setNewLineAfterDeclaration(false);
        format.setTrimText(false);
        StringWriter writer = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter((Writer)writer, format);
        xmlWriter.write(document);
        xmlWriter.close();
        return writer.toString();
    }

    public static void reSetIndex(Element parentElement) {
        Iterator node = parentElement.elementIterator();
        int index = 1;
        while (node.hasNext()) {
            Element element = (Element)node.next();
            element.setAttributeValue("index", Integer.toString(index++));
            if (element.nodeCount() <= 0) continue;
            XMLUtil.reSetIndex(element);
        }
    }
}

