/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.formplugin;

import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.enums.Checked;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.formplugin.base.OcbaseBillPlugin;

public class PrivacyPolicyPlugin
extends OcbaseBillPlugin
implements BeforeF7SelectListener {
    public static final String DESCRIPTION_TAG = "description_tag";
    public static final String C_RICHTEXTEDITORAP = "richtexteditorap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addF7Listener(this, new String[]{"platform"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String description = (String)this.getModel().getValue(DESCRIPTION_TAG);
        if (OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{C_RICHTEXTEDITORAP});
        } else {
            RichTextEditor richTextEditor = (RichTextEditor)this.getControl(C_RICHTEXTEDITORAP);
            if (StringUtils.isEmpty((String)richTextEditor.getText()) && StringUtils.isNotEmpty((String)description)) {
                richTextEditor.setText(description);
            }
        }
        if (Checked.YES.toString().equals(this.getModel().getValue("enable"))) {
            this.getModel().setValue("isenable", (Object)true);
        } else {
            this.getModel().setValue("isenable", (Object)false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        super.beforeDoOperation(e);
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "save": 
            case "submit": {
                RichTextEditor richTextEditor = (RichTextEditor)this.getControl(C_RICHTEXTEDITORAP);
                String text = richTextEditor.getText();
                this.getModel().setValue(DESCRIPTION_TAG, (Object)text);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        switch (key = ((AbstractOperate)e.getSource()).getOperateKey()) {
            case "disable": {
                this.getModel().setValue("isenable", (Object)false);
                break;
            }
            case "enable": {
                this.getModel().setValue("isenable", (Object)true);
                break;
            }
        }
        super.afterDoOperation(e);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "platform": {
                DynamicObjectCollection data = QueryServiceHelper.query((String)"ocepfp_privacypolicy", (String)"platform", null);
                if (data == null || data.size() <= 0) break;
                List platformIds = data.stream().map(r -> r.getLong("platform")).collect(Collectors.toList());
                QFilter qFilter = new QFilter("id", "not in", platformIds);
                qFilter.and("enable", "=", (Object)Checked.YES.toString());
                F7Utils.addF7Filter((BeforeF7SelectEvent)e, (QFilter)qFilter);
            }
        }
    }
}

