/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.api;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ExtView;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.GZIPUtils;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.common.util.XMLUtil;
import kd.occ.ocepfp.core.form.util.ISVUtil;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.JfsXMLLoader;
import kd.occ.ocepfp.core.form.view.parser.JfsXMLMerger;
import kd.occ.ocepfp.core.service.view.ExtViewServiceHelper;
import org.dom4j.Document;
import org.dom4j.Element;

public class EditViewActionApi
implements IBillWebApiPlugin {
    protected static Log logger = LogFactory.getLog(EditViewActionApi.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        ExtWebContext extCtx = ExtWebContext.newInstanceFromMap(params);
        ApiResult apiResult = null;
        switch (extCtx.getForm().getEvent().toLowerCase(Locale.ENGLISH)) {
            case "initenv": {
                apiResult = this.initEnv();
                break;
            }
            case "getapps": {
                apiResult = this.getApps(extCtx);
                break;
            }
            case "loadview": {
                apiResult = this.loadView(extCtx);
                break;
            }
            case "saveview": {
                apiResult = this.saveView(extCtx);
                break;
            }
            case "save": {
                apiResult = this.save(extCtx);
                break;
            }
            case "getcontrols": {
                apiResult = this.getControls();
                break;
            }
            case "getfiles": {
                apiResult = this.getFiles(extCtx);
                break;
            }
            case "getfilecontent": {
                apiResult = this.getFileContent(extCtx);
                break;
            }
            case "history": {
                apiResult = this.getHistory(extCtx);
                break;
            }
            case "createfilecontent": {
                apiResult = this.createFileContent(extCtx);
                break;
            }
            case "delete": {
                apiResult = ExtViewServiceHelper.deleteView((ExtWebContext)extCtx, (String)extCtx.getForm().getString("viewId"));
            }
        }
        return apiResult;
    }

    private ApiResult initEnv() {
        return ApiResult.success((Object)(ISVUtil.isDevelopmentEnv() ? 101 : 0));
    }

    private ApiResult loadView(ExtWebContext extCtx) {
        JfsXMLLoader.initAllXML((ExtWebContext)extCtx);
        ExtView extView = ExtViewServiceHelper.getView((ExtWebContext)extCtx, (String)extCtx.getForm().getViewId());
        if (extView == null) {
            ViewFactory.get((ExtWebContext)extCtx, (String)extCtx.getForm().getViewId());
            extView = ExtViewServiceHelper.getView((ExtWebContext)extCtx, (String)extCtx.getForm().getViewId());
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        ApiResult apiResult = null;
        try {
            if (extView != null) {
                Element root = extView.getDetail().getRootElement();
                data.put("name", extView.getName());
                data.put("viewId", extView.getViewKey());
                data.put("detail", XMLUtil.formatXml((Document)JfsXMLMerger.getJFSFileMerger((ExtWebContext)extCtx, (String)extView.getViewKey(), (String)"").merge()));
                data.put("needlogin", Convert.toBoolean((Object)root.attributeValue("needlogin"), (boolean)false));
                data.put("logintype", StringUtil.isNull((String)root.attributeValue("logintype")) ? "none" : root.attributeValue("logintype"));
                data.put("appId", Long.toString(extView.getAppId()));
            }
            data.put("appList", ExtViewServiceHelper.loadApp());
            apiResult = ApiResult.success(data);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            apiResult = ApiResult.fail((String)e.getMessage());
            apiResult.setMessage(e.getMessage());
        }
        return apiResult;
    }

    private ApiResult saveView(ExtWebContext extCtx) {
        String viewKey = extCtx.getForm().getString("viewId");
        String zipDetail = extCtx.getForm().getString("detail");
        String detail = GZIPUtils.unGzip((String)(StringUtil.isNotNull((String)zipDetail) ? zipDetail.replaceAll("&#43;", "+") : zipDetail));
        long appId = extCtx.getForm().getLong("appId");
        String isNeedLogin = extCtx.getForm().getString("needlogin", "false");
        String loginType = extCtx.getForm().getString("logintype");
        ApiResult apiResult = this.saveView(extCtx, viewKey, detail, appId, isNeedLogin, loginType);
        return apiResult;
    }

    private ApiResult saveView(ExtWebContext extCtx, String viewKey, String detail, long appId, String isNeedLogin, String loginType) {
        ApiResult apiResult = null;
        try {
            if (StringUtil.isNull((String)viewKey.trim())) {
                apiResult = ApiResult.fail((String)"\u9875\u9762Id\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\uff01");
                return apiResult;
            }
            Document document = ExtViewServiceHelper.saveView((ExtWebContext)new ExtWebContext(), (String)viewKey, (String)detail, (long)appId, (String)isNeedLogin, (String)loginType);
            apiResult = ApiResult.success((Object)XMLUtil.formatXml((Document)document));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            apiResult = ApiResult.fail((String)e.getMessage());
            apiResult.setMessage(e.getMessage());
        }
        return apiResult;
    }

    private ApiResult save(ExtWebContext extCtx) {
        String viewKey = extCtx.getForm().getString("viewId");
        String zipDetail = extCtx.getForm().getString("detail");
        String detail = GZIPUtils.unGzip((String)(StringUtil.isNotNull((String)zipDetail) ? zipDetail.replaceAll("&#43;", "+") : zipDetail));
        long appId = extCtx.getForm().getLong("appId");
        String isNeedLogin = extCtx.getForm().getString("needlogin", "false");
        String loginType = extCtx.getForm().getString("logintype");
        ApiResult apiResult = this.saveView(extCtx, viewKey, detail, appId, isNeedLogin, loginType);
        return apiResult;
    }

    private ApiResult getControls() {
        ApiResult apiResult = ApiResult.success((Object)ExtViewServiceHelper.getControls());
        return apiResult;
    }

    private ApiResult getFiles(ExtWebContext extCtx) {
        return ApiResult.success((Object)ExtViewServiceHelper.getFiles((Long)extCtx.getForm().getLong("appId")));
    }

    private ApiResult getFileContent(ExtWebContext extCtx) {
        ApiResult apiResult;
        try {
            String appendId = extCtx.getForm().getString("appendId");
            String viewId = extCtx.getForm().getViewId();
            apiResult = ExtViewServiceHelper.getFileContent((ExtWebContext)extCtx, (String)viewId, (String)appendId);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            apiResult = ApiResult.fail((String)e.getMessage());
        }
        return apiResult;
    }

    private ApiResult getHistory(ExtWebContext extCtx) {
        return ApiResult.success((Object)ExtViewServiceHelper.getHistory((ExtWebContext)extCtx, (long)extCtx.getForm().getLong("appId")));
    }

    private ApiResult createFileContent(ExtWebContext extCtx) {
        return ExtViewServiceHelper.createFileContent((ExtWebContext)extCtx, (String)extCtx.getForm().getString("extendId"), (String)extCtx.getForm().getString("appendId"), (String)extCtx.getForm().getString("platform"), (String)extCtx.getForm().getString("viewId"), (String)extCtx.getForm().getString("name"));
    }

    private ApiResult getApps(ExtWebContext extCtx) {
        return ApiResult.success((Object)ExtViewServiceHelper.getApps((ExtWebContext)extCtx));
    }
}

