/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.business.plugin.CodeRuleValidator;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.coderule.api.ConditionEntryInfo;
import kd.bos.coderule.opplugin.pagecache.BillNoChangeCache;
import kd.bos.coderule.opplugin.pagecache.RecycleCache;
import kd.bos.coderule.opplugin.util.OrgUtil;
import kd.bos.coderule.service.CodeRuleServiceImp;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import org.apache.commons.collections4.CollectionUtils;

public class AbstractCodeRuleOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(AbstractCodeRuleOp.class);
    public static final int loopNum = 50;
    public static final String SKIPBILLNOVALIDATOR = "skipbillnovalidator";
    protected CodeRuleServiceImp codeRuleService = new CodeRuleServiceImp();

    protected String getClassName() {
        return "AbstractCodeRule";
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.rebackBillno(e);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        this.generateNumber(e.getDataEntities());
    }

    public void generateNumber(DynamicObject[] dynamicObjects) {
        if (!(this.billEntityType instanceof BillEntityType)) {
            return;
        }
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (!"save".equals(operateType) && !"submit".equals(operateType)) {
            return;
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            String importFlag;
            if (this.operateOption.tryGetVariableValue("ignoreinteraction", new RefObject()) && "true".equals(importFlag = this.operateOption.getVariableValue("ignoreinteraction"))) {
                logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u5f15\u5165>\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e(" + dynamicObjects.length + ")");
                this.batchGenerateNumberFromExcel(dynamicObjects);
                return;
            }
            if (dynamicObjects.length > 1) {
                logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u5217\u8868or\u5168\u90e8\u4e0b\u63a8>\u6279\u91cf\u5904\u7406\u591a\u6761\u6570\u636e (" + dynamicObjects.length + ")");
                for (DynamicObject dynamicObject : dynamicObjects) {
                    this.singleGenerateNumber(dynamicObject);
                }
                return;
            }
            logger.info("[CodeRuleOp]<\u5f53\u524d\u4e3a\u8868\u5355\u6216\u5217\u8868>\u4ec5\u5904\u7406\u4e00\u6761\u6570\u636e");
            this.singleGenerateNumber(dynamicObjects[0]);
        }
    }

    protected void rebackBillno(AddValidatorsEventArgs e) {
        DynamicObject[] dynamicObjects = e.getDataEntities();
        if (!(this.billEntityType instanceof BillEntityType)) {
            return;
        }
        Map operMeta = this.operateMeta;
        if (null == operMeta) {
            return;
        }
        String operateType = (String)operMeta.get("type");
        if (!"save".equals(operateType) && !"submit".equals(operateType)) {
            return;
        }
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            BillEntityType dataEntityType;
            String billno;
            String importFlag;
            if (this.operateOption.tryGetVariableValue("ignoreinteraction", new RefObject()) && "true".equals(importFlag = this.operateOption.getVariableValue("ignoreinteraction"))) {
                return;
            }
            if (dynamicObjects.length > 1) {
                return;
            }
            boolean skipbillnovalidator = this.operateOption.tryGetVariableValue(SKIPBILLNOVALIDATOR, new RefObject());
            if (skipbillnovalidator && this.operateOption.getVariableValue(SKIPBILLNOVALIDATOR).equals(String.valueOf(true)) && "".equals(billno = dynamicObjects[0].get(this.getBillNoField(dataEntityType = (BillEntityType)dynamicObjects[0].getDataEntityType())).toString())) {
                logger.info("[CodeRuleOp]\u8fd8\u539f\u88ab\u8868\u5355\u63d2\u4ef6\u8bbe\u7f6e\u7684\u7a7a\u503c,\u5e76\u8865\u5145CodeRuleValidator\u6821\u9a8c\u5668");
                CodeRuleValidator validator = new CodeRuleValidator(this.operateOption.getVariableValue("skipbillnovalidator_value"));
                e.getValidators().add(0, validator);
            }
        }
    }

    private void singleGenerateNumber(DynamicObject dynamicObject) {
        boolean isNew;
        BillEntityType billEntityType = (BillEntityType)dynamicObject.getDataEntityType();
        CodeRuleInfo codeRuleInfo = this.getCodeRuleInfo(dynamicObject);
        if (codeRuleInfo == null) {
            return;
        }
        boolean bl = isNew = !dynamicObject.getDataEntityState().getFromDatabase();
        if (isNew) {
            logger.info("[CodeRuleOp]\u65b0\u589e\u4e00\u6761\u6570\u636e");
            this.singleGenerateNewNumber(dynamicObject, billEntityType, codeRuleInfo);
        } else {
            logger.info("[CodeRuleOp]\u4fee\u6539\u4e00\u6761\u6570\u636e");
            this.singleGenerateUpdateNumber(dynamicObject, billEntityType, codeRuleInfo);
        }
    }

    protected CodeRuleInfo getCodeRuleInfo(DynamicObject dynamicObject) {
        String entityNum = this.getEntityName(dynamicObject.getDataEntityType());
        if (entityNum == null) {
            return null;
        }
        String orgId = OrgUtil.getMainOrgId((DynamicObject)dynamicObject);
        return CodeRuleServiceHelper.getCodeRule((String)entityNum, (DynamicObject)dynamicObject, (String)orgId);
    }

    private void singleGenerateNewNumber(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        logger.info("[CodeRuleOp]\u751f\u6210\u7f16\u53f7");
        String billNoFldKey = this.getBillNoField(billEntityType);
        if (!this.operateOption.tryGetVariableValue(SKIPBILLNOVALIDATOR, new RefObject()) && !"".equals(dynamicObject.getString(this.getBillNoField(billEntityType)))) {
            logger.info("[AbstractCodeRuleOp]\u901a\u8fc7OperationServiceHelper\u65b9\u5f0f\u8fdb\u5165\u5230\u64cd\u4f5c\u63d2\u4ef6");
            boolean fitCodeRule = this.codeRuleService.checkNumber(dynamicObject, dynamicObject.getString(this.getBillNoField(billEntityType)), codeRuleInfo);
            if (!fitCodeRule) {
                logger.info("[AbstractCodeRuleOp]\u4f20\u5165\u7684\u7f16\u53f7\u4e0e\u7f16\u7801\u89c4\u5219\u683c\u5f0f\u4e0d\u4e00\u81f4,\u5224\u65ad\u5f53\u524d\u573a\u666f\u662f\u5355\u5143\u6d4b\u8bd5");
                return;
            }
        }
        if (this.validateFitCodeRuleByOldNumber(codeRuleInfo)) {
            String newNumber = this.invokeGetNumber(dynamicObject, codeRuleInfo);
            if (this.isOpenForOnlyNumber(billNoFldKey, codeRuleInfo, dynamicObject)) {
                newNumber = this.generateNumberForUniqueBillno(dynamicObject, billNoFldKey, codeRuleInfo, newNumber);
            }
            dynamicObject.set(billNoFldKey, (Object)newNumber);
        }
    }

    private String invokeGetNumber(DynamicObject dynamicObject, CodeRuleInfo codeRuleInfo) {
        String number = null;
        try {
            number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)dynamicObject);
        }
        catch (KDException e) {
            if ("ERRCODE_CODERULE_VALIDATE_NUMBER".equals(e.getErrorCode().getCode())) {
                throw new KDBizException(e.getErrorCode(), new Object[0]);
            }
            throw new KDException(e.getErrorCode(), new Object[0]);
        }
        return number;
    }

    protected String getBillNoField(BillEntityType billEntityType) {
        return billEntityType.getBillNo();
    }

    private boolean validateFitCodeRuleByOldNumber(CodeRuleInfo codeRuleInfo) {
        return codeRuleInfo.getIsModifiable() == false || !new BillNoChangeCache(this.getClassName()).isChange(this.operateOption);
    }

    protected boolean isOpenForOnlyNumber(String billNoFldKey, CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        boolean onlyBillNoUnique = false;
        Map operMeta = this.operateMeta;
        List validationList = (List)operMeta.get("validations");
        for (Map validationInfo : validationList) {
            List fields;
            if (!((Boolean)validationInfo.get("enabled")).booleanValue() || !"GroupFieldUnique".equals((String)validationInfo.get("ruleType")) || (fields = (List)validationInfo.get("fields")).size() != 1 || !((Map)fields.get(0)).containsValue(billNoFldKey)) continue;
            onlyBillNoUnique = true;
            logger.info("[CodeRuleOp]\u627e\u5230\u7f16\u7801\u552f\u4e00\u6027\u6821\u9a8c");
            break;
        }
        return onlyBillNoUnique;
    }

    private String generateNumberForUniqueBillno(DynamicObject dynamicObject, String billNoFldKey, CodeRuleInfo codeRuleInfo, String number) {
        block2: {
            String entityNum = dynamicObject.getDataEntityType().getName();
            int loopCount = 0;
            do {
                boolean existBillNum;
                if (!(existBillNum = QueryServiceHelper.exists((String)entityNum, (QFilter[])this.getQFilterExistUniqueBillNo(billNoFldKey, number, dynamicObject)))) {
                    logger.info("[CodeRuleOp]\u5c1d\u8bd5" + loopCount + "\u6b21\u540e\u53d1\u73b0\u4e0d\u91cd\u590d\u7684\u7f16\u7801");
                    break block2;
                }
                number = this.invokeGetNumber(dynamicObject, codeRuleInfo);
            } while (++loopCount <= 50);
            logger.info("[CodeRuleOp]\u5c1d\u8bd550\u6b21\u540e\u4f9d\u7136\u6ca1\u6709\u53d1\u73b0\u4e0d\u91cd\u590d\u7684\u7f16\u7801,\u505c\u6b62\u7ee7\u7eed\u6d88\u8017\u6d41\u6c34\u53f7");
        }
        return number;
    }

    protected QFilter[] getQFilterExistUniqueBillNo(String billNoFldKey, String number, DynamicObject dynamicObject) {
        return new QFilter[]{new QFilter(billNoFldKey, "=", (Object)number)};
    }

    private void singleGenerateUpdateNumber(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        if (!this.validateFitCodeRuleByOldNumber(codeRuleInfo)) {
            this.recycleOldNumber(codeRuleInfo, dynamicObject);
            return;
        }
        if (this.validateRebuildNumberAtUpdate(dynamicObject, billEntityType, codeRuleInfo)) {
            logger.info("[CodeRuleOp]\u91cd\u751f\u6210\u7f16\u53f7");
            this.singleGenerateNewNumber(dynamicObject, billEntityType, codeRuleInfo);
            this.recycleOldNumber(codeRuleInfo, dynamicObject);
        }
    }

    protected boolean validateRebuildNumberAtUpdate(DynamicObject dynamicObject, BillEntityType billEntityType, CodeRuleInfo codeRuleInfo) {
        if (!codeRuleInfo.isUpdateRecover()) {
            return false;
        }
        String billNoFldKey = this.getBillNoField(billEntityType);
        String number = dynamicObject.getString(billNoFldKey);
        return StringUtils.isNotBlank((CharSequence)number) && this.dirtyPropsContainBillNoRelFieldKey(dynamicObject, billNoFldKey, codeRuleInfo);
    }

    protected void signResourceFromList() {
        this.operateOption.setVariableValue(SKIPBILLNOVALIDATOR, String.valueOf(true));
    }

    private boolean dirtyPropsContainBillNoRelFieldKey(DynamicObject dObj, String billNoFieldKey, CodeRuleInfo codeRuleInfo) {
        List dirtyProperties = dObj.getDataEntityState().GetDirtyProperties();
        if (CollectionUtils.isEmpty((Collection)dirtyProperties)) {
            return false;
        }
        List dirtyPropKeys = dirtyProperties.stream().map(IMetadata::getName).collect(Collectors.toList());
        Set propertiesSet = Optional.ofNullable(codeRuleInfo.getRuleEntry()).map(Collection::stream).orElseGet(Stream::empty).filter(StringUtils::isNotBlank).map(entry -> entry.getValueAtribute().split("\\.")[0]).collect(Collectors.toSet());
        List conditionEntry = codeRuleInfo.getConditionEntry();
        if (CollectionUtils.isNotEmpty((Collection)conditionEntry)) {
            String billStatusFieldKey = "";
            IDataEntityType dataEntityType = dObj.getDataEntityType();
            if (dataEntityType instanceof BillEntityType) {
                billStatusFieldKey = ((BillEntityType)dataEntityType).getBillStatus();
            }
            for (ConditionEntryInfo entryInfo : conditionEntry) {
                String conditionPropKey = entryInfo.getProperty();
                if (StringUtils.isNotEmpty((CharSequence)billStatusFieldKey) && billStatusFieldKey.equals(conditionPropKey)) continue;
                propertiesSet.add(entryInfo.getProperty());
            }
        }
        List<String> skipPropKeys = this.getSkipPropKeysForDirtyCheck();
        for (String propertyKey : propertiesSet) {
            if (!StringUtils.isNotEmpty((CharSequence)propertyKey) || !CollectionUtils.isEmpty(skipPropKeys) && skipPropKeys.contains(propertyKey) || !dirtyPropKeys.contains(propertyKey)) continue;
            return true;
        }
        return false;
    }

    protected List<String> getSkipPropKeysForDirtyCheck() {
        return null;
    }

    private void recycleOldNumber(CodeRuleInfo codeRuleInfo, DynamicObject dynamicObject) {
        if (codeRuleInfo.getIsNonBreak().booleanValue()) {
            RecycleCache recycleCache = new RecycleCache(this.getClassName());
            String recycleNumber = recycleCache.getNumber(this.operateOption);
            DynamicObject dynamicObj = recycleCache.getDynamicObj(this.operateOption, (DynamicObjectType)dynamicObject.getDataEntityType());
            if (StringUtils.isNotBlank((CharSequence)recycleNumber) && dynamicObj != null) {
                this.codeRuleService.recycleNumber(codeRuleInfo, dynamicObj, recycleNumber);
            }
        }
    }

    private void batchGenerateNumberFromExcel(DynamicObject[] dynamicObjects) {
        this.batchGenerateNumberBySimpleLogic(dynamicObjects);
    }

    private void batchGenerateNumberBySimpleLogic(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> mayGenerateDynamicObjs = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> unGenerateDynamicObjs = new ArrayList<DynamicObject>(8);
        this.composeDynamicObjs(dynamicObjects, mayGenerateDynamicObjs, unGenerateDynamicObjs);
        this.generateNumbers(mayGenerateDynamicObjs);
        this.updateMaxserialNumbers(unGenerateDynamicObjs);
    }

    private List<DynamicObject> composeDynamicObjs(DynamicObject[] originalDynamicObjects, List<DynamicObject> mayGenerateDynamicObjs, List<DynamicObject> unGenerateDynamicObjs) {
        if (!this.validateBillNo()) {
            return new ArrayList<DynamicObject>(0);
        }
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        for (DynamicObject obj : originalDynamicObjects) {
            String billNo = obj.getString(billNoFldKey);
            if (StringUtils.isNotBlank((CharSequence)billNo)) {
                unGenerateDynamicObjs.add(obj);
                continue;
            }
            mayGenerateDynamicObjs.add(obj);
        }
        return mayGenerateDynamicObjs;
    }

    private boolean validateBillNo() {
        BillEntityType dt = (BillEntityType)this.billEntityType;
        if (dt == null) {
            return false;
        }
        String billNoFldKey = this.getBillNoField(dt);
        return !StringUtils.isEmpty((CharSequence)billNoFldKey);
    }

    private void generateNumbers(List<DynamicObject> mayGenerateDynamicObjs) {
        if (!this.validateBillNo()) {
            return;
        }
        if (CollectionUtils.isEmpty(mayGenerateDynamicObjs)) {
            return;
        }
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        String entityName = mayGenerateDynamicObjs.get(0).getDataEntityType().getName();
        List numbers = this.codeRuleService.getNumbers(entityName, mayGenerateDynamicObjs);
        for (int i = 0; i < mayGenerateDynamicObjs.size(); ++i) {
            if (numbers.get(i) == null) continue;
            mayGenerateDynamicObjs.get(i).set(billNoFldKey, numbers.get(i));
        }
    }

    private void updateMaxserialNumbers(List<DynamicObject> unGenerateDynamicObjs) {
        String billNoFldKey = this.getBillNoField((BillEntityType)this.billEntityType);
        this.codeRuleService.updateMaxserialNumbers(unGenerateDynamicObjs, billNoFldKey);
    }

    private void batchGenerateNumber(DynamicObject[] dynamicObjects) {
        ArrayList<DynamicObject> nullNumberDatas = new ArrayList<DynamicObject>();
        BillEntityType dt = (BillEntityType)this.billEntityType;
        if (dt == null || StringUtils.isBlank((CharSequence)dt.getBillNo())) {
            return;
        }
        String billNoFldKey = this.getBillNoField(dt);
        ArrayList<DynamicObject> dynamicObjectList = new ArrayList<DynamicObject>();
        for (DynamicObject obj : dynamicObjects) {
            boolean isNew = !obj.getDataEntityState().getFromDatabase();
            String billNo = obj.getString(billNoFldKey);
            if (isNew && StringUtils.isNotBlank((CharSequence)billNo)) {
                dynamicObjectList.add(obj);
            }
            if (!StringUtils.isBlank((CharSequence)billNo)) continue;
            nullNumberDatas.add(obj);
        }
        for (DynamicObject dynamicObject : dynamicObjectList) {
            this.singleGenerateNumber(dynamicObject);
        }
        if (nullNumberDatas.size() == 0) {
            return;
        }
        String entityName = ((DynamicObject)nullNumberDatas.get(0)).getDataEntityType().getName();
        logger.info("[CodeRuleOp]\u5b9e\u4f53:" + entityName + "\u8ba1\u5212\u751f\u6210" + nullNumberDatas.size() + "\u4e2a\u7f16\u7801");
        if (dt.getBillNo().equals(this.getBillNoField(dt))) {
            this.codeRuleService.injectNumbers(entityName, nullNumberDatas);
        } else if (this.getCodeRuleInfo((DynamicObject)nullNumberDatas.get(0)) != null) {
            List numbers = this.codeRuleService.getNumbers(entityName, nullNumberDatas, this.getCodeRuleInfo((DynamicObject)nullNumberDatas.get(0)));
            for (int i = 0; i < nullNumberDatas.size(); ++i) {
                if (numbers.get(i) == null) continue;
                ((DynamicObject)nullNumberDatas.get(i)).set(this.getBillNoField(dt), numbers.get(i));
            }
        }
        int count = 0;
        for (DynamicObject numberData : nullNumberDatas) {
            Object realBillNo = numberData.get(this.getBillNoField(dt));
            if (ObjectUtils.isEmpty((Object)realBillNo)) continue;
            ++count;
        }
        logger.info("[CodeRuleOp]\u5b9e\u4f53:" + entityName + "\u6210\u529f\u751f\u6210" + count + "\u4e2a\u7f16\u7801");
    }

    protected String getEntityName(IDataEntityType dataEntityType) {
        BillEntityType dt = (BillEntityType)this.billEntityType;
        MainMetadata mainMetadata = MetadataFactory.getMetadata((String)dt.getName());
        if (mainMetadata.getBillNoField() == null) {
            return null;
        }
        String baseViewId = mainMetadata.getBillNoField().getBaseViewId();
        return StringUtil.isNull((String)baseViewId) ? dataEntityType.getName() : baseViewId;
    }
}

