/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocepfp.opplugin.AbstractCodeRuleOp;

public class CodeRuleOp
extends AbstractCodeRuleOp {
    private static final Log logger = LogFactory.getLog(CodeRuleOp.class);
    private DynamicObject[] allData = null;

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        this.rebackBillno(e);
        this.allData = e.getDataEntities();
        this.generateNumber(e.getDataEntities());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        if (this.allData == null || this.allData.length == 0) {
            return;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(Arrays.asList(this.allData));
        for (int i = this.allData.length - 1; i >= 0; --i) {
            if (e.getOperationResult().getSuccessPkIds().contains(this.allData[i].getPkValue())) {
                list.remove(i);
                continue;
            }
            boolean isEdit = this.allData[i].getDataEntityState().getFromDatabase();
            if (!isEdit) continue;
            list.remove(i);
        }
        if (!list.isEmpty()) {
            logger.info("[CodeRuleOp]\u672c\u6b21\u64cd\u4f5c\u6ca1\u6709\u6210\u529f\u51c6\u5907\u5c1d\u8bd5\u56de\u6536\u5904\u7406");
            this.recycleNumber(list);
        }
    }

    private void recycleNumber(List<DynamicObject> list) {
        BillEntityType dt = (BillEntityType)this.billEntityType;
        if (dt == null) {
            return;
        }
        String billNoFldKey = this.getBillNoField(dt);
        if (StringUtils.isBlank((String)billNoFldKey)) {
            return;
        }
        for (DynamicObject dynamicObject : list) {
            String number;
            String entityNum = dynamicObject.getDataEntityType().getName();
            boolean b = this.validateNumberInBusinessDB(entityNum, billNoFldKey, dynamicObject, number = dynamicObject.getString(billNoFldKey));
            if (!b) continue;
            this.codeRuleService.recycleNumber(this.getEntityName(dynamicObject.getDataEntityType()), dynamicObject, null, number);
        }
    }

    private boolean validateNumberInBusinessDB(String entityNum, String billNoFldKey, DynamicObject dynamicObject, String number) {
        boolean existBillNum = QueryServiceHelper.exists((String)entityNum, (QFilter[])this.getQFilterExistUniqueBillNo(billNoFldKey, number, dynamicObject));
        return !existBillNum;
    }
}

