/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.business.loginverifycode;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Random;
import javax.imageio.ImageIO;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.util.FileNameUtils;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.ExtAppCache;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class LoginVerifyCodeProcessor {
    private static final String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
    private static final String verify_codes = "0123456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKMNPQRSTUVWXYZ";
    private static final int width = 100;
    private static final int height = 40;
    private static final int code_length = 4;
    private static final Random random = new SecureRandom();
    private static final TempFileCache tempfile = CacheFactory.getCommonCacheFactory().getTempFileCache();
    private static final int timeout = 600;

    public String getVerifyCodeImage() {
        return LoginVerifyCodeProcessor.creatVerifyRandcode(true);
    }

    private static Font randomFont() {
        int index = random.nextInt(fontNames.length);
        int style = random.nextInt(4);
        int size = random.nextInt(10) + 29;
        return new Font("Arial", 3, 25);
    }

    private static String creatVerifyRandcode(boolean outputImage) {
        String url = "";
        StringBuffer randomCode = new StringBuffer();
        if (outputImage) {
            int i;
            BufferedImage image = new BufferedImage(100, 40, 4);
            Graphics graphics = image.getGraphics();
            graphics.fillRect(0, 0, 100, 40);
            for (i = 0; i <= 20; ++i) {
                LoginVerifyCodeProcessor.drowLines(graphics);
            }
            for (i = 1; i <= 4; ++i) {
                randomCode.append(LoginVerifyCodeProcessor.drowString(graphics, i));
            }
            graphics.dispose();
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)image, "JPEG", os);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(os.toByteArray());
                url = LoginVerifyCodeProcessor.uploadTempPicUrl(inputStream);
            }
            catch (Exception e) {
                LogUtil.error(LoginVerifyCodeProcessor.class, (String)StringUtil.getErrorMsg((Exception)e));
            }
        } else {
            for (int i = 1; i <= 4; ++i) {
                randomCode.append(Convert.toString((Object)Character.valueOf(verify_codes.charAt(random.nextInt(verify_codes.length())))));
            }
        }
        LoginVerifyCodeProcessor.setCacheRandCode(randomCode.toString());
        LogUtil.info(LoginVerifyCodeProcessor.class, (String)String.format("randomString:%s,url%s", randomCode, url));
        return url;
    }

    private static void drowLines(Graphics graphics) {
        int rgb = 110 + random.nextInt(9);
        graphics.setColor(new Color(rgb, rgb, rgb));
        graphics.setFont(LoginVerifyCodeProcessor.randomFont());
        int x = random.nextInt(100);
        int y = random.nextInt(40);
        int xl = random.nextInt(30);
        int yl = random.nextInt(30);
        graphics.drawLine(x, y, x + xl, y + yl);
        int[] xPoints = new int[]{100, 100, 250, 250};
        int[] yPoints = new int[]{180, 150, 150, 180};
        graphics.drawPolyline(xPoints, yPoints, 4);
    }

    private static String drowString(Graphics graphics, int strIndex) {
        graphics.setFont(LoginVerifyCodeProcessor.randomFont());
        graphics.setColor(new Color(random.nextInt(101), random.nextInt(111), random.nextInt(121)));
        String rand = LoginVerifyCodeProcessor.getRandCode();
        graphics.translate(random.nextInt(3), random.nextInt(3));
        graphics.drawString(rand, (18 + random.nextInt(3)) * strIndex, 18 + random.nextInt(9));
        return rand;
    }

    private static String getRandCode() {
        return Convert.toString((Object)Character.valueOf(verify_codes.charAt(random.nextInt(verify_codes.length()))));
    }

    private static String getRandCodeCacheKey() {
        return String.format("randcode_%s", RequestContext.get().getGlobalSessionId());
    }

    public String getCacheRandCode() {
        return (String)ExtAppCache.getPrivateValue((String)LoginVerifyCodeProcessor.getRandCodeCacheKey(), String.class);
    }

    private static void setCacheRandCode(String randCode) {
        ExtAppCache.setPrivateValue((String)LoginVerifyCodeProcessor.getRandCodeCacheKey(), (Object)randCode, (int)600);
    }

    public static String uploadTempPicUrl(InputStream inputStream) {
        return tempfile.saveAsFullUrl(LoginVerifyCodeProcessor.getRandCodeUrl(), inputStream, 600);
    }

    private static String getRandCodeUrl() {
        long pkId = TimeServiceHelper.getTimeStamp();
        String fullName = String.format("randcode_%s%s", pkId, ".JPEG");
        String tenantId = RequestContext.get().getTenantId();
        String accountId = RequestContext.get().getAccountId();
        return FileNameUtils.getImageFileName((String)tenantId, (String)accountId, (String)"epfp", (String)"LoginVerifyCodeProcessor", (Object)pkId, (String)fullName);
    }
}

