/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.business.memberlogin;

import com.alibaba.fastjson.JSONObject;
import java.security.Key;
import java.util.Base64;
import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.RSAUtils;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.helper.UserHelper;
import kd.occ.ocbase.common.pojo.dto.member.user.LoginByIdentifierAndPwdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.RegisterByMobileDTO;
import kd.occ.ocepfp.business.loginverifycode.LoginVerifyCodeHelper;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.InvokeResult;
import kd.occ.ocepfp.common.entity.MemberRegisterInfo;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.ExtAppCache;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class MemberProcessor {
    private static final String cloudId = "occ";
    private static final String appID = "ocdbd";
    private static final String serviceName = "MemberService";
    private static final String method_register = "insertMemberInfo";
    private static final String method_querymember = "queryMemberByUserNameAndPwd";
    private static final String error_registerinfo = ResManager.loadKDString((String)"\u6ce8\u518c\u7528\u6237\u4fe1\u606f\u4e0d\u6b63\u786e\u3002", (String)"MemberLoginProcessor_0", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String blank_phonenumber = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u624b\u673a\u53f7\u3002", (String)"MemberLoginProcessor_1", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String blank_accountname = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u7528\u6237\u540d\u3002", (String)"MemberLoginProcessor_2", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String blank_password = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u5bc6\u7801\u3002", (String)"MemberLoginProcessor_3", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String registerfail = ResManager.loadKDString((String)"\u4f1a\u5458\u6ce8\u518c\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\u3002", (String)"MemberLoginProcessor_4", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String error_verifycode = ResManager.loadKDString((String)"\u9a8c\u8bc1\u7801\u8f93\u5165\u4e0d\u6b63\u786e\u3002", (String)"MemberLoginProcessor_6", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static final String error_decrypted = ResManager.loadKDString((String)"\u9875\u9762\u5df2\u8fc7\u671f\uff0c\u8bf7\u5237\u65b0\u3002", (String)"MemberLoginProcessor_7", (String)"drp-epfp-business", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(MemberProcessor.class);

    public String registerMember(MemberRegisterInfo registerInfo) {
        String checkResult = this.checkRegisterMemberInfo(registerInfo);
        if (StringUtil.isNotNull((String)checkResult)) {
            return checkResult;
        }
        InvokeResult invokeResult = this.invokeMemberRegister(registerInfo);
        if (!"0".equalsIgnoreCase(invokeResult.getCode())) {
            return invokeResult.getMessage();
        }
        return "";
    }

    private InvokeResult invokeMemberRegister(MemberRegisterInfo registerInfo) {
        InvokeResult invokeResult = new InvokeResult();
        try {
            String decryptedPassword = this.getDecryptedPassword(registerInfo.getPassword());
            RegisterByMobileDTO dto = new RegisterByMobileDTO();
            dto.setSplitNumber("");
            dto.setMobile(registerInfo.getPhoneNumber());
            dto.setSex(0);
            dto.setAccount(registerInfo.getAccountName());
            dto.setPassword(decryptedPassword);
            dto.setCreateOrgId(null);
            dto.setSrcAppType("A");
            dto.setSrcAppName("");
            dto.setOrgId(Long.valueOf(100000L));
            dto.setChannelId(null);
            dto.setDeveloperId(null);
            dto.setConsultantId(null);
            dto.setAgentId(null);
            dto.setNationalityId(null);
            dto.setEducationId(null);
            dto.setOccupationId(null);
            dto.setMonthlyIncomeId(null);
            dto.setCountryCode("+86");
            JSONObject result = UserHelper.registerByMobile((RegisterByMobileDTO)dto);
            return (InvokeResult)JsonUtil.readValue((String)result.toString(), InvokeResult.class);
        }
        catch (Exception e) {
            logger.error(StringUtil.getErrorMsg((Exception)e));
            invokeResult.setCode("-1");
            invokeResult.setMessage(registerfail);
            return invokeResult;
        }
    }

    private String getDecryptedPassword(String password) {
        try {
            password = password.replaceAll("&#43;", "+");
            String privateKey = (String)ExtAppCache.getPrivateValue((String)this.getAccessKey(), String.class);
            return new String(RSAUtils.decryptByKey((Key)RSAUtils.getPrivateKey((byte[])Base64.getDecoder().decode(privateKey)), (byte[])Base64.getDecoder().decode(password.getBytes("UTF-8"))), "UTF-8");
        }
        catch (Exception ex) {
            logger.error(StringUtil.getErrorMsg((Exception)ex));
            return "";
        }
    }

    private final String getAccessKey() {
        return String.format("loginAccessKey_%s", RequestContext.get().getGlobalSessionId());
    }

    private String checkRegisterMemberInfo(MemberRegisterInfo registerInfo) {
        if (registerInfo == null) {
            return error_registerinfo;
        }
        if (StringUtil.isNull((String)registerInfo.getAccountName())) {
            return blank_accountname;
        }
        if (StringUtil.isNull((String)registerInfo.getPassword())) {
            return blank_password;
        }
        if (StringUtil.isNull((String)registerInfo.getPhoneNumber())) {
            return blank_phonenumber;
        }
        if (!registerInfo.getVerifyCode().equalsIgnoreCase(LoginVerifyCodeHelper.getCacheRandCode())) {
            return error_verifycode;
        }
        return "";
    }

    public void H5MemberLogin(ExtWebContext extWebContext, MemberRegisterInfo loginInfo) throws KDBizException {
        String decryptedPassword = "";
        try {
            decryptedPassword = this.getDecryptedPassword(loginInfo.getPassword());
        }
        catch (Exception ex) {
            logger.error(StringUtil.getErrorMsg((Exception)ex));
        }
        if (StringUtil.isNull((String)decryptedPassword)) {
            throw new KDBizException(error_decrypted);
        }
        LoginByIdentifierAndPwdDTO dto = new LoginByIdentifierAndPwdDTO();
        dto.setSplitNumber("");
        dto.setOrgId(Long.valueOf(loginInfo.getOrgId()));
        dto.setIdentifier(loginInfo.getAccountName());
        dto.setPassword(decryptedPassword);
        JSONObject invokeReuslt = UserHelper.loginByIdentifierAndPwd((LoginByIdentifierAndPwdDTO)dto);
        JSONObject member = invokeReuslt.getJSONObject("data");
        if (!invokeReuslt.getBooleanValue("success")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7528\u6237\u540d\u6216\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e\uff0c\u767b\u5f55\u5931\u8d25\u3002", (String)"MemberProcessor_7", (String)"drp-epfp-business", (Object[])new Object[0]));
        }
        this.saveMemberLoginInfo(extWebContext, member.getLong("userId"), loginInfo.getAccountName(), loginInfo.getPhoneNumber());
    }

    private void saveMemberLoginInfo(ExtWebContext extCtx, Long memberId, String userName, String phoneNumber) {
        Date date = TimeServiceHelper.now();
        String token = UUID.randomUUID().toString();
        QFilter filters = new QFilter("nickname", "=", (Object)userName);
        DynamicObject userInfo = ORM.create().queryOne("ocepfp_memberologininfo", filters.toArray());
        if (userInfo == null) {
            userInfo = BusinessDataServiceHelper.newDynamicObject((String)"ocepfp_memberologininfo");
            userInfo.set("token", (Object)token);
            userInfo.set("logintime", (Object)date);
            userInfo.set("nickname", (Object)userName);
            userInfo.set("member_Id", (Object)memberId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{userInfo});
        } else {
            userInfo.set("logintime", (Object)date);
            SaveServiceHelper.update((DynamicObject)userInfo);
        }
        extCtx.setToken(token);
        extCtx.setMemberId(Convert.toLong((Object)memberId));
    }
}

