/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.common.entity;

import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocepfp.common.constant.DeviceUtil;
import kd.occ.ocepfp.common.entity.Form;
import kd.occ.ocepfp.common.entity.LoginContext;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.common.util.ClientTypeUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.ExtAppCache;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;

public class ExtWebContext
implements Serializable {
    private static final long serialVersionUID = -5200423877976553552L;
    private Form form;
    private PageView pageView;

    public static final ExtWebContext newInstance(HttpServletRequest request) {
        ExtWebContext extWebContext = new ExtWebContext();
        extWebContext.form = new Form(request);
        return extWebContext;
    }

    public static final ExtWebContext newInstanceFromMap(Map<String, Object> params) {
        ExtWebContext extWebContext = new ExtWebContext();
        extWebContext.form = new Form(params);
        return extWebContext;
    }

    public static final ExtWebContext newInstance() {
        ExtWebContext extWebContext = new ExtWebContext();
        extWebContext.form = new Form();
        return extWebContext;
    }

    public Object getUserID() {
        return Long.parseLong(RequestContext.get().getUserId());
    }

    public String getRootPath() {
        int l;
        String b = RequestContext.get().getClientFullContextPath();
        if (b.charAt(l = b.length() - 1) == '/') {
            b = b.substring(0, l);
        }
        return b;
    }

    public String getLang() {
        return RequestContext.get().getLang().getLangTag();
    }

    public long getOrgId() {
        return RequestContext.get().getOrgId();
    }

    public String getAccountId() {
        return RequestContext.get().getAccountId();
    }

    public boolean isFromMobile() {
        return ClientTypeUtil.isFromMobile();
    }

    public boolean isMemberLogined() {
        return this.getMemberId() > 0L;
    }

    public void setToken(String token) {
        ExtAppCache.setPrivateValue((String)"_usertoken_", (Object)token);
    }

    public String getToken() {
        String token = (String)ExtAppCache.getPrivateValue((String)"_usertoken_", String.class);
        return token == null ? "" : token;
    }

    public void setMemberId(long memberId) {
        ExtAppCache.setPrivateValue((String)("_memberId_" + this.getToken()), (Object)memberId);
    }

    public void setAppId(String appId) {
        ExtAppCache.setPrivateValue((String)("_appId_" + this.getToken()), (Object)appId);
    }

    public String getAppId() {
        return (String)ExtAppCache.getPrivateValue((String)("_appId_" + this.getToken()), String.class);
    }

    public void setOpenId(String openId) {
        ExtAppCache.setPrivateValue((String)("_openId_" + this.getToken()), (Object)openId);
    }

    public String getOpenId() {
        return (String)ExtAppCache.getPrivateValue((String)("_openId_" + this.getToken()), String.class);
    }

    public void logout() {
        String appId = this.getAppId();
        if (StringUtil.isNotNull((String)appId)) {
            DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocepfp", (String)"MemberService", (String)"deleteMemberLoginInfo", (Object[])new Object[]{appId, this.getMemberId()});
        }
        ExtAppCache.removePrivateValue((String)("_memberId_" + this.getToken()));
        ExtAppCache.removePrivateValue((String)"_usertoken_");
    }

    public long getMemberId() {
        String memberId = (String)ExtAppCache.getPrivateValue((String)("_memberId_" + this.getToken()), String.class);
        return Convert.toLong((String)memberId);
    }

    public Form getForm() {
        return this.form;
    }

    public void setForm(Form form) {
        this.form = form;
    }

    public LoginContext getLoginContext() {
        return LoginContext.get();
    }

    public PageView getCurrentPageView() {
        if (this.pageView == null) {
            boolean isFramePage = false;
            if ("index".equalsIgnoreCase(this.getForm().getViewId())) {
                isFramePage = true;
                MainPortal mainPortal = ExtPortalServiceHelper.getMainPortal(this);
                if (StringUtil.isNotNull((String)mainPortal.getIndexViewId())) {
                    this.getForm().setViewId(mainPortal.getIndexViewId());
                }
            }
            this.getForm().setIsFramePage(isFramePage);
            this.pageView = ViewFactory.get(this, this.getForm().getViewId());
        }
        return this.pageView;
    }

    public boolean isFromMiniProgram() {
        return DeviceUtil.isFromMiniProgram((String)this.getForm().getDevice());
    }
}

