/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.editor;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;

public class LocalAppUtil {
    private static Map<String, String> _cache = new HashMap<String, String>(4);

    public static final LocalAppUtil getInstance() {
        return LocalUtilHolder.instance;
    }

    public String getRealPath(String path) {
        String app;
        if (StringUtil.isNull((String)path)) {
            return "";
        }
        List<String> p = LocalAppUtil.extractMessageByRegular(path);
        String string = app = p != null && p.size() > 0 ? p.get(0) : null;
        if (app == null) {
            return "";
        }
        String local = this.getLocalAppPath(app);
        if (StringUtil.isNull((String)local)) {
            return "";
        }
        return path.replaceAll("\\{" + app + "\\}", local);
    }

    public static List<String> extractMessageByRegular(String msg) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern p = Pattern.compile("(\\{[^\\]]*\\})");
        Matcher m = p.matcher(msg);
        while (m.find()) {
            list.add(m.group().substring(1, m.group().length() - 1));
        }
        return list;
    }

    public String getLocalAppPath(String app) {
        if (_cache.size() == 0) {
            this.localLocalAppPath();
        }
        return _cache.get(app);
    }

    private final void localLocalAppPath() {
        try {
            Enumeration<URL> enumerations = this.getClass().getClassLoader().getResources("JfsView/app.properties");
            while (enumerations.hasMoreElements()) {
                URL fileURL = enumerations.nextElement();
                Properties pro = this.loadProperties(fileURL);
                String app = pro.getOrDefault((Object)"app", "").toString().trim();
                String local = pro.getOrDefault((Object)"local", "").toString().trim();
                if (!StringUtil.isNotNull((String)app)) continue;
                _cache.put(app, local);
            }
        }
        catch (IOException e) {
            LogUtil.info(this.getClass(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Properties loadProperties(URL url) {
        ZipFile jarFile = null;
        Properties pro = new Properties();
        InputStream isr = null;
        try {
            URLConnection con = url.openConnection();
            if (con instanceof JarURLConnection) {
                JarURLConnection jarCon = (JarURLConnection)con;
                jarFile = jarCon.getJarFile();
                isr = ((JarFile)jarFile).getInputStream(((JarFile)jarFile).getEntry("JfsView/app.properties"));
                pro.load(isr);
            }
        }
        catch (IOException e) {
            LogUtil.info(this.getClass(), (Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    LogUtil.info(this.getClass(), (Throwable)e);
                }
            }
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    LogUtil.info(this.getClass(), (Throwable)e);
                }
            }
        }
        return pro;
    }

    private static class LocalUtilHolder {
        private static final LocalAppUtil instance = new LocalAppUtil();

        private LocalUtilHolder() {
        }
    }
}

