/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.editor;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.util.CleanPathUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.editor.LocalAppUtil;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class LocalFileSaveUtil {
    private static Log logger = LogFactory.getLog(LocalFileSaveUtil.class);
    public static final String jfsfile = "/src/main/resources/JfsView/";

    public static final String save2Local(String svn, String viewId, Document xml, long appId, String version) {
        if (StringUtil.isNull((String)svn)) {
            return "-1";
        }
        String path = new StringBuilder(100).append(svn).append(jfsfile).append(viewId).append(".xml").toString();
        return LocalFileSaveUtil.save2Local(path, xml, appId, version);
    }

    public static final String save2Local(String path, Document xml, long appId, String version) {
        String realPath = LocalAppUtil.getInstance().getRealPath(path);
        if (StringUtil.isNull((String)realPath)) {
            return "-1";
        }
        return LocalFileSaveUtil.writeFile(realPath, xml, appId, version) ? "1" : "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean writeFile(String filepath, Document document, long appId, String version) {
        if (StringUtil.isNotNull((String)filepath) && filepath.indexOf(jfsfile) == -1) {
            return false;
        }
        filepath = CleanPathUtil.cleanString((String)filepath);
        File file = new File(filepath);
        XMLWriter writer = null;
        FileOutputStream fo = null;
        try {
            if (!file.getParentFile().exists()) {
                boolean bl = false;
                return bl;
            }
            document.getRootElement().setAttributeValue("version", version);
            document.getRootElement().setAttributeValue("appid", Long.toString(appId));
            OutputFormat format = new OutputFormat();
            format.setEncoding("utf-8");
            format.setTrimText(true);
            format.setIndent(true);
            format.setNewlines(true);
            format.setNewLineAfterDeclaration(false);
            fo = new FileOutputStream(file);
            writer = new XMLWriter((OutputStream)fo, format);
            writer.write(document);
            writer.flush();
            writer.close();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            LogUtil.error(LocalFileSaveUtil.class, (String)e.getMessage(), (Throwable)e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            if (fo != null) {
                try {
                    fo.close();
                }
                catch (IOException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return false;
    }
}

