/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.SortType;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Price;
import kd.occ.ocepfp.core.form.control.controls.Qty;
import kd.occ.ocepfp.core.form.control.controls.Unit;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import org.dom4j.DocumentException;

public class ListDataProvider {
    private ExtWebContext ctx;
    private MainEntityType mainEntityType;
    private MainMetadata mainMetadata;
    private Map<String, SortType> orderFieldsMap = new HashMap<String, SortType>(4);
    private PageBody pageBody;
    private List<ListField> listFields = new ArrayList<ListField>();
    private Set<String> selectFieldSet = new HashSet<String>(16);
    private Set<String> currencyFieldSet = new HashSet<String>(16);
    private Set<String> unitFieldSet = new HashSet<String>(16);
    private String seqField;
    private List<ListField> pkFields = new ArrayList<ListField>();
    private List<ListField> keyFields = new ArrayList<ListField>();
    private EntityType entityType;
    private List<QFilter> qFilters = new ArrayList<QFilter>();
    private String orderByExpr;
    private int maxReturnData;
    private int start;
    private int limit;
    private boolean isSelectedAllRowsFlag;

    public List<ListField> getListFields() {
        return this.listFields;
    }

    public void setListFields(List<ListField> listFields) {
        this.listFields = listFields;
    }

    public String getSeqField() {
        return this.seqField;
    }

    public ListDataProvider(ExtWebContext ctx, MainEntityType mainEntityType, MainMetadata mainMetadata) {
        this.ctx = ctx;
        this.mainEntityType = mainEntityType;
        this.mainMetadata = mainMetadata;
        PageView mainPageView = null;
        try {
            mainPageView = PageViewBuilder.getPageView(ctx, mainMetadata.getBaseMetadataId());
            this.seqField = this.mainMetadata.getMainListDataGridId() + "_uqrow";
        }
        catch (IllegalAccessException | InstantiationException | DocumentException e) {
            e.printStackTrace();
        }
        this.pageBody = mainPageView != null ? mainPageView.getPageBody() : null;
    }

    public List<ListField> getPKFields() {
        return this.pkFields;
    }

    public void setPKFields(String pkFields) {
        this.createListFields(this.pkFields, pkFields);
    }

    public void setPKFields(List<ListField> pkFields) {
        this.pkFields = pkFields;
    }

    public List<ListField> getKeyFields() {
        return this.keyFields;
    }

    public void setKeyFields(List<ListField> keyFields) {
        this.keyFields = keyFields;
    }

    public void setKeyFields(String keyFields) {
        this.getOrderField();
        this.createListFields(this.keyFields, keyFields);
        this.setListFields(this.keyFields);
        this.createSortField();
        this.createSelectCurrencyFields();
        this.createSelectUnitFields();
        this.getListFields().add(this.createSeqField("fseq", true, null));
    }

    private void createListFields(List<ListField> fieldList, String fields) {
        String[] fs;
        if (StringUtil.isNull((String)fields)) {
            return;
        }
        for (String f : fs = fields.split(",")) {
            this.selectFieldSet.add(f);
            SortType sortType = this.orderFieldsMap.get(f);
            fieldList.add(this.createListField(f, true, sortType));
            if (sortType == null) continue;
            this.orderFieldsMap.remove(f);
        }
    }

    private ListField createListField(String f, boolean visible, SortType sortType) {
        Field field = this.findFieldProperty(f);
        ListField listField = new ListField(f);
        listField.setEntityName(field.getEntityId());
        listField.setFieldName(f);
        String key = StringUtil.isNotNull((String)listField.getEntityName()) ? f.replaceAll(field.getEntityId() + "\\.", "") : f;
        listField.setKey(key);
        listField.setListFieldKey(key);
        if (sortType != null) {
            listField.setSortType(sortType);
        }
        listField.setVisible(visible);
        this.buildCurrency(field.getId());
        this.buildUnit(field.getId());
        return listField;
    }

    private ListField createSeqField(String f, boolean visible, SortType sortType) {
        ListField listField = new ListField(f);
        listField.setEntityName(this.ctx.getCurrentPageView().getViewId());
        listField.setFieldName(this.getSeqField());
        listField.setKey(f);
        listField.setListFieldKey(f);
        listField.setVisible(visible);
        listField.setSeq(true);
        return listField;
    }

    private void buildCurrency(String id) {
        String curreny;
        if (this.pageBody == null) {
            return;
        }
        Control control = (Control)this.pageBody.getControl(id);
        if (control == null) {
            return;
        }
        if (control.getType().equals("Currency") && this.currencyFieldSet.remove(id)) {
            return;
        }
        if ((control.getType().equals("Amount") || control.getType().equals("Price")) && StringUtil.isNotNull((String)(curreny = ((Price)control).getCurrency())) && !this.selectFieldSet.contains(curreny)) {
            this.currencyFieldSet.add(curreny);
        }
    }

    private void buildUnit(String id) {
        String unit;
        if (this.pageBody == null) {
            return;
        }
        Control control = (Control)this.pageBody.getControl(id);
        if (control == null) {
            return;
        }
        if (control.getType().equals("Unit") && this.unitFieldSet.remove(id)) {
            return;
        }
        if (control.getType().equals("Qty") && StringUtil.isNotNull((String)(unit = ((Qty)control).getUnit())) && !this.selectFieldSet.contains(unit)) {
            Unit unitControl = (Unit)this.pageBody.getControl(unit);
            this.unitFieldSet.add(StringUtil.isNotNull((String)unitControl.getSrcDataGrid()) ? unitControl.getSrcDataGrid() + "." + unit : unit);
        }
    }

    private void createSelectCurrencyFields() {
        Iterator<String> iterator = this.currencyFieldSet.iterator();
        while (iterator.hasNext()) {
            this.getKeyFields().add(this.createListField(iterator.next(), false, null));
        }
    }

    private void createSelectUnitFields() {
        Iterator<String> iterator = this.unitFieldSet.iterator();
        while (iterator.hasNext()) {
            this.getKeyFields().add(this.createListField(iterator.next(), false, null));
        }
    }

    private void getOrderField() {
        String[] orderBys;
        String orderBy = this.getOrderByExpr();
        if (StringUtil.isNull((String)orderBy)) {
            return;
        }
        for (String order : orderBys = orderBy.trim().split(",")) {
            String[] orderExp = order.split(" ");
            String orderField = orderExp[0];
            String orderModel = null;
            if (orderExp.length > 1) {
                orderModel = orderExp[orderExp.length - 1];
            }
            SortType sortType = orderModel == null ? SortType.NotOrder : (orderModel.equalsIgnoreCase("asc") ? SortType.ASC : SortType.DESC);
            this.orderFieldsMap.put(orderField.toLowerCase(), sortType);
        }
    }

    private void createSortField() {
        for (Map.Entry<String, SortType> entry : this.orderFieldsMap.entrySet()) {
            this.getKeyFields().add(this.createListField(entry.getKey(), false, entry.getValue()));
        }
    }

    private Field findFieldProperty(String key) {
        String[] keys = key.split("\\.");
        Field field = new Field();
        this.findFieldProperty(keys, 0, field, this.getMainEntityType().getProperty(keys[0]));
        return field;
    }

    private void findFieldProperty(String[] key, int index, Field field, DynamicProperty d) {
        field.setEntityId(d.getParent().getName());
        if (d instanceof EntryProp) {
            int nextIndex = index + 1;
            field.setEntityId(key[index]);
            if (key.length - 1 > index) {
                this.findFieldProperty(key, nextIndex, field, ((EntryProp)d).getDynamicCollectionItemPropertyType().getProperty(key[nextIndex]));
                return;
            }
        }
        field.setId(key[index]);
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public void setQFilters(List<QFilter> qFilters) {
        this.qFilters = qFilters;
    }

    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    public String getOrderByExpr() {
        return this.orderByExpr;
    }

    public void setOrderByExpr(String orderByExpr) {
        this.orderByExpr = orderByExpr;
    }

    public int getMaxReturnData() {
        return this.maxReturnData;
    }

    public void setMaxReturnData(int maxReturnData) {
        this.maxReturnData = maxReturnData;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setPageInfo(int page, int pageSize) {
        this.start = (page - 1) * pageSize;
        this.limit = pageSize;
    }

    public boolean isSelectedAllRows() {
        return this.isSelectedAllRowsFlag;
    }

    public void setSelectedAllRows(boolean isSelectedAllRows) {
        this.isSelectedAllRowsFlag = isSelectedAllRows;
    }

    public ExtWebContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ExtWebContext ctx) {
        this.ctx = ctx;
    }

    public MainEntityType getMainEntityType() {
        return this.mainEntityType;
    }

    public void setMainEntityType(MainEntityType mainEntityType) {
        this.mainEntityType = mainEntityType;
    }
}

