/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.control;

import java.util.HashMap;
import java.util.Map;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.core.form.control.IControlParser;

public class ControlFactory {
    private static final Map<String, Face> CONTROLS = new HashMap<String, Face>(100);

    public static final Map<String, Face> getControls() {
        return CONTROLS;
    }

    public static final Face getControlFace(String controlName) {
        return CONTROLS.get(controlName.toLowerCase());
    }

    public static final void regControl(String key, String name, String control, FaceCategory category) {
        Face face = new Face(name, control, control + "Parser", category);
        ControlFactory.reg(key, face);
    }

    public static final void regControl(String key, String name, String control, String controlParser, FaceCategory category) {
        Face face = new Face(name, control, controlParser, category);
        ControlFactory.reg(key, face);
    }

    public static final void regControl(String key, String name, String control, String controlParser, String platform, FaceCategory category) {
        Face face = new Face(name, control, controlParser, platform, category);
        ControlFactory.reg(key, face);
    }

    private static final void reg(String key, Face face) {
        key = key.toLowerCase();
        CONTROLS.put(key, face);
    }

    static {
        ControlFactory.regControl("ToolBar", "\u5de5\u5177\u680f", "ToolBar", FaceCategory.Base);
        ControlFactory.regControl("MenuButtonGroup", "\u83dc\u5355\u5206\u7ec4", "MenuButtonGroup", FaceCategory.Base);
        ControlFactory.regControl("MenuButton", "\u83dc\u5355", "MenuButton", FaceCategory.Base);
        ControlFactory.regControl("Text", "\u6587\u672c\u6846", "Text", FaceCategory.Base);
        ControlFactory.regControl("MultiLanguageText", "\u6587\u8bed\u8a00\u6587\u672c", "MultiLanguageText", FaceCategory.Layout);
        ControlFactory.regControl("Panel", "\u9762\u677f", "Panel", FaceCategory.Layout);
        ControlFactory.regControl("FormPanel", "\u8868\u5355\u9762\u677f", "FormPanel", FaceCategory.Layout);
        ControlFactory.regControl("FlexPanel", "Flex\u9762\u677f", "FlexPanel", FaceCategory.Layout);
        ControlFactory.regControl("LatticePanel", "\u6805\u683c\u9762\u677f", "LatticePanel", FaceCategory.Layout);
        ControlFactory.regControl("TopHiddenPanel", "\u9876\u90e8\u9690\u85cf\u9762\u677f", "TopHiddenPanel", FaceCategory.Layout);
        ControlFactory.regControl("Include", "\u5d4c\u5165\u89c6\u56fe", "Include", FaceCategory.Layout);
        ControlFactory.regControl("CreateDate", "\u521b\u5efa\u65f6\u95f4", "CreateDate", FaceCategory.Base);
        ControlFactory.regControl("ModifyDate", "\u4fee\u6539\u65f6\u95f4", "ModifyDate", FaceCategory.Base);
        ControlFactory.regControl("DateTime", "\u957f\u65f6\u95f4", "DateTime", FaceCategory.Base);
        ControlFactory.regControl("Date", "\u65e5\u671f", "Date", FaceCategory.Base);
        ControlFactory.regControl("Creator", "\u521b\u5efa\u4eba", "Creator", FaceCategory.Base);
        ControlFactory.regControl("Modifier", "\u4fee\u6539\u4eba", "Modifier", FaceCategory.Base);
        ControlFactory.regControl("CheckboxGroup", "\u591a\u9009\u6309\u94ae\u5206\u7ec4", "CheckBoxGroup", FaceCategory.Base);
        ControlFactory.regControl("Checkbox", "\u591a\u9009\u6309\u94ae", "CheckBox", FaceCategory.Base);
        ControlFactory.regControl("RadioGroup", "\u5355\u9009\u6309\u94ae\u5206\u7ec4", "RadioGroup", FaceCategory.Base);
        ControlFactory.regControl("Radio", "\u5355\u9009\u6309\u94ae\u5206\u7ec4", "Radio", FaceCategory.Base);
        ControlFactory.regControl("Qty", "\u6570\u91cf", "Qty", FaceCategory.Base);
        ControlFactory.regControl("Price", "\u5355\u4ef7", "Price", FaceCategory.Base);
        ControlFactory.regControl("Number", "\u6570\u5b57", "Number", FaceCategory.Base);
        ControlFactory.regControl("Textarea", "\u591a\u884c\u6587\u672c", "TextArea", FaceCategory.Base);
        ControlFactory.regControl("Select", "\u4e0b\u62c9\u9009\u62e9\u6846", "Select", FaceCategory.Base);
        ControlFactory.regControl("Option", "\u4e0b\u62c9\u6846\u9009\u9879", "Option", FaceCategory.Base);
        ControlFactory.regControl("TabGroup", "\u5206\u7ec4\u9875\u7b7e", "TabGroup", FaceCategory.Layout);
        ControlFactory.regControl("Tab", "\u9875\u7b7e", "Tab", FaceCategory.Layout);
        ControlFactory.regControl("SelectData", "\u57fa\u7840\u8d44\u6599", "SelectData", FaceCategory.Base);
        ControlFactory.regControl("Label", "\u6807\u7b7e", "Label", FaceCategory.Base);
        ControlFactory.regControl("Img", "\u56fe\u7247", "Img", FaceCategory.Base);
        ControlFactory.regControl("FirstClassMenu", "\u4e00\u7ea7\u83dc\u5355", "FirstClassMenu", FaceCategory.Base);
        ControlFactory.regControl("DataGrid", "\u8868\u683c", "DataGrid", FaceCategory.Base);
        ControlFactory.regControl("List", "\u8868\u683c", "List", FaceCategory.Base);
        ControlFactory.regControl("Fields", "\u8868\u683c\u5b57\u6bb5", "Fields", FaceCategory.Base);
        ControlFactory.regControl("Button", "\u6309\u94ae", "Button", FaceCategory.Base);
        ControlFactory.regControl("AppMain", "\u4e3b\u9762\u677f", "AppMain", FaceCategory.Layout);
        ControlFactory.regControl("QueryFilter", "\u641c\u7d22\u9762\u677f", "QueryFilter", FaceCategory.Layout);
        ControlFactory.regControl("DefaultFilter", "\u9ed8\u8ba4\u641c\u7d22\u9762\u677f", "DefaultFilter", FaceCategory.Layout);
        ControlFactory.regControl("MoreFilter", "\u66f4\u591a\u641c\u7d22\u9762\u677f", "MoreFilter", FaceCategory.Layout);
        ControlFactory.regControl("Global", "\u5168\u5c40\u53c2\u6570", "Global", FaceCategory.Layout);
        ControlFactory.regControl("Property", "\u53c2\u6570", "Property", FaceCategory.Layout);
        ControlFactory.regControl("Portal", "\u95e8\u6237", "Portal", FaceCategory.Layout);
        ControlFactory.regControl("Card", "\u5361\u7247", "Card", FaceCategory.Layout);
        ControlFactory.regControl("Timer", "\u5b9a\u65f6\u5668", "Timer", FaceCategory.Layout);
        ControlFactory.regControl("LevelMenu", "\u5c42\u7ea7\u83dc\u5355", "LevelMenu", FaceCategory.Layout);
        ControlFactory.regControl("KSwitch", "\u5f00\u5173", "KSwitch", FaceCategory.Base);
        ControlFactory.regControl("Palette", "\u8c03\u8272\u677f", "Palette", FaceCategory.Base);
        ControlFactory.regControl("ImgGroup", "\u56fe\u7247\u7ec4", "ImgGroup", FaceCategory.Base);
        ControlFactory.regControl("A", "\u8d85\u7ea7\u94fe\u63a5", "A", FaceCategory.Base);
        ControlFactory.regControl("Code", "\u7f16\u7801", "Code", FaceCategory.Base);
        ControlFactory.regControl("RichText", "\u5bcc\u6587\u672c", "RichText", FaceCategory.Base);
        ControlFactory.regControl("KSwiper", "\u6eda\u52a8\u56fe\u7247", "KSwiper", FaceCategory.Base);
        ControlFactory.regControl("TabBar", "\u5bfc\u822a\u83dc\u5355", "TabBar", FaceCategory.Base);
        ControlFactory.regControl("TabBarItem", "\u5bfc\u822a\u83dc\u5355\u5b50\u9879", "TabBarItem", FaceCategory.Base);
        ControlFactory.regControl("Scroller", "\u6eda\u52a8\u6761", "Scroller", FaceCategory.Base);
        ControlFactory.regControl("Html", "html", "Html", FaceCategory.Base);
        ControlFactory.regControl("SwitchTabBar", "\u6eda\u52a8\u9875\u7b7e", "SwitchTabBar", FaceCategory.Base);
        ControlFactory.regControl("SwitchTabBarItem", "\u6eda\u52a8\u9875\u7b7e\u9879", "SwitchTabBarItem", FaceCategory.Base);
        ControlFactory.regControl("SwitchTabBarCItem", "\u7ec4\u7ec7\u6eda\u52a8\u9875\u7b7e\u9879", "SwitchTabBarCItem", FaceCategory.Base);
        ControlFactory.regControl("LeftSlipButtonGroup", "\u5de6\u6ed1\u6309\u94ae\u7ec4", "LeftSlipButtonGroup", FaceCategory.Base);
        ControlFactory.regControl("CardItem", "\u6a71\u7a97\u5546\u54c1", "CardItem", FaceCategory.Base);
        ControlFactory.regControl("AdminDivision", "\u884c\u653f\u533a\u5212", "AdminDivision", FaceCategory.Base);
        ControlFactory.regControl("Operations", "\u64cd\u4f5c\u5b9a\u4e49", "Operations", FaceCategory.inner);
        ControlFactory.regControl("Operation", "\u64cd\u4f5c", "Operation", FaceCategory.inner);
        ControlFactory.regControl("Plugins", "\u63d2\u4ef6\u5b9a\u4e49", "Plugins", FaceCategory.inner);
        ControlFactory.regControl("Plugin", "\u63d2\u4ef6", "Plugin", FaceCategory.inner);
        ControlFactory.regControl("BillStatus", "\u5355\u636e\u72b6\u6001", "BillStatus", FaceCategory.Base);
        ControlFactory.regControl("Location", "\u5b9a\u4f4d", "Location", FaceCategory.Base);
        ControlFactory.regControl("CountDown", "\u5012\u8ba1\u65f6", "CountDown", FaceCategory.Base);
        ControlFactory.regControl("GroupFooter", "\u5206\u7ec4\u5e95\u90e8", "GroupFooter", FaceCategory.Base);
        ControlFactory.regControl("StarScore", "\u661f\u661f\u8bc4\u4ef7", "StarScore", FaceCategory.Base);
        ControlFactory.regControl("flexfield", "\u5f39\u6027\u57df", "FlexField", FaceCategory.Base);
        ControlFactory.regControl("SearchHistory", "\u641c\u7d22\u7ed3\u679c", "SearchHistory", FaceCategory.Base);
        ControlFactory.regControl("Currency", "\u5e01\u522b", "Currency", FaceCategory.Base);
        ControlFactory.regControl("Amount", "\u91d1\u989d", "Amount", FaceCategory.Base);
        ControlFactory.regControl("Unit", "\u8ba1\u91cf\u5355\u4f4d", "Unit", FaceCategory.Base);
        ControlFactory.regControl("auxpty", "\u8f85\u52a9\u5c5e\u6027\u63a7\u4ef6", "Auxpty", FaceCategory.Base);
        ControlFactory.regControl("Sku", "\u7269\u6599sku\u63a7\u4ef6", "Sku", FaceCategory.Base);
        ControlFactory.regControl("spu", "\u7269\u6599spu\u63a7\u4ef6", "Spu", FaceCategory.Base);
        ControlFactory.regControl("ImageUpload", "\u56fe\u7247\u4e0a\u4f20", "ImageUpload", FaceCategory.Base);
        ControlFactory.regControl("Steps", "\u6b65\u9aa4\u7ec4", "Steps", FaceCategory.Base);
        ControlFactory.regControl("Step", "\u6b65\u9aa4", "Step", FaceCategory.Base);
        ControlFactory.regControl("Calendar", "\u65e5\u5386", "Calendar", FaceCategory.Base);
    }

    public static enum FaceCategory {
        Base("\u57fa\u672c\u63a7\u4ef6"),
        Layout("\u5e03\u5c40"),
        query("\u67e5\u8be2"),
        inner("\u5185\u90e8\u63a7\u4ef6");

        private final String name;

        private FaceCategory(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Face {
        private String name;
        private boolean isMainControl = false;
        private String control;
        private IControlParser controlParse;
        private String platform = "pc";
        private String category;

        public Face(String control, String controlParser) {
            this.regControl(control, controlParser);
        }

        public Face(String name, String control, String controlParser, FaceCategory category) {
            this.regControl(control, controlParser);
            this.name = name;
            this.isMainControl = true;
            this.category = category.toString();
        }

        public Face(String name, String control, String controlParser, String platform, FaceCategory category) {
            this.regControl(control, controlParser);
            this.name = name;
            this.isMainControl = true;
            this.category = category.toString();
            this.platform = platform;
        }

        public Face(String name, String control, String controlParser, boolean isMainControl) {
            this.regControl(control, controlParser);
            this.name = name;
            this.isMainControl = isMainControl;
        }

        public Object getControlInstance() {
            return Convert.toInstance((String)this.control);
        }

        private void regControl(String control, String controlParser) {
            try {
                this.control = this.getDefaultFullPath(control, "kd.occ.ocepfp.core.form.control.controls");
                this.controlParse = (IControlParser)Class.forName(this.getDefaultFullPath(controlParser, "kd.occ.ocepfp.core.form.control.parser")).newInstance();
            }
            catch (Exception e) {
                LogUtil.error(ControlFactory.class, (Throwable)e);
            }
        }

        private String getDefaultFullPath(String key, String defaultPackage) {
            if (key.indexOf(46) < 0) {
                key = defaultPackage + "." + key;
            }
            return key;
        }

        public String getControl() {
            return this.control;
        }

        public void setControl(String control) {
            this.control = control;
        }

        public IControlParser getControlParse() {
            return this.controlParse;
        }

        public void setControlParse(IControlParser controlParse) {
            this.controlParse = controlParse;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isMainControl() {
            return this.isMainControl;
        }

        public void setMainControl(boolean isMainControl) {
            this.isMainControl = isMainControl;
        }

        public String getPlatform() {
            return this.platform;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String category) {
            this.category = category;
        }
    }
}

