/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.control;

import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.ControlParserData;
import kd.occ.ocepfp.core.form.util.XMLTemplateUtil;
import kd.occ.ocepfp.core.form.view.parser.ViewObjectConverter;
import org.dom4j.DocumentException;

public abstract class IControlParser {
    public abstract String create(ExtWebContext var1, Control var2, String var3, Map<String, Control> var4);

    protected String render(ExtWebContext extCtx, String templateName, ControlParserData data) {
        try {
            Control control = data.getControl();
            if (control.getCols24() == null && control.getParentControl() != null && control.getParentControl().getType().equals("LatticePanel")) {
                control.setCols24(control.getCols() * 6);
            }
            data.put("_style", this.reBuildStyle(control));
            data.put("_labelstyle", this.reBuildLabelStyle(control));
            data.put("_inputstyle", this.reInputLabelStyle(control));
            data.put("_commonproperties", this.renderCommonProperties(extCtx, data));
            return XMLTemplateUtil.parse("kd/drp/ext/core/form/control/parser/template/" + templateName, data);
        }
        catch (DocumentException e) {
            LogUtil.error(IControlParser.class, (String)("templateName " + templateName + " is not found."), (Throwable)e);
            return "";
        }
    }

    private String reBuildStyle(Control control) {
        String style = "";
        style = style + this.addStyle("width", this.addUnit(control.getWidth()));
        style = style + this.addStyle("height", this.addUnit(control.getHeight()));
        style = style + this.addStyle("margin-top", this.addUnit(control.getMarginTop()));
        style = style + this.addStyle("margin-left", this.addUnit(control.getMarginLeft()));
        style = style + this.addStyle("margin-right", this.addUnit(control.getMarginRight()));
        style = style + this.addStyle("margin-bottom", this.addUnit(control.getMarginBottom()));
        style = style + this.addStyle("text-align", control.getTextAlign());
        style = style + this.addStyle("color", control.getColor());
        style = style + this.addStyle("background", control.getBackground());
        style = style + this.addStyle("font-size", this.addUnit(control.getFontSize()));
        if (StringUtil.isNotNull((String)control.getStyle())) {
            style = style + ";" + control.getStyle();
        }
        return StringUtil.isNotNull((String)style) ? style + ";" : null;
    }

    private String reBuildLabelStyle(Control control) {
        String style = "";
        style = style + this.addStyle("width", this.addUnit(control.getLabelWidth()));
        style = style + this.addStyle("height", this.addUnit(control.getLabelHeight()));
        style = style + this.addStyle("margin-top", this.addUnit(control.getLabelMarginTop()));
        style = style + this.addStyle("margin-left", this.addUnit(control.getLabelMarginLeft()));
        style = style + this.addStyle("margin-right", this.addUnit(control.getLabelMarginRight()));
        style = style + this.addStyle("margin-bottom", this.addUnit(control.getLabelMarginBottom()));
        style = style + this.addStyle("text-align", control.getLabelTextAlign());
        style = style + this.addStyle("color", control.getLabelColor());
        style = style + this.addStyle("background", control.getLabelBackground());
        style = style + this.addStyle("font-size", this.addUnit(control.getLabelFontSize()));
        if (StringUtil.isNotNull((String)control.getLabelStyle())) {
            style = style + ";" + control.getLabelStyle();
        }
        return StringUtil.isNotNull((String)style) ? style + ";" : null;
    }

    private String reInputLabelStyle(Control control) {
        String style = "";
        style = style + this.addStyle("width", this.addUnit(control.getInputWidth()));
        style = style + this.addStyle("height", this.addUnit(control.getInputHeight()));
        style = style + this.addStyle("margin-top", this.addUnit(control.getInputMarginTop()));
        style = style + this.addStyle("margin-left", this.addUnit(control.getInputMarginLeft()));
        style = style + this.addStyle("margin-right", this.addUnit(control.getInputMarginRight()));
        style = style + this.addStyle("margin-bottom", this.addUnit(control.getInputMarginBottom()));
        style = style + this.addStyle("text-align", control.getInputTextAlign());
        style = style + this.addStyle("color", control.getInputColor());
        style = style + this.addStyle("background", control.getInputBackground());
        style = style + this.addStyle("font-size", this.addUnit(control.getInputFontSize()));
        style = style + this.addStyle("border", control.getInputBorer());
        if (StringUtil.isNotNull((String)control.getInputStyle())) {
            style = style + ";" + control.getInputStyle();
        }
        return StringUtil.isNotNull((String)style) ? style + ";" : null;
    }

    private String addUnit(String value) {
        return this.addUnit(value, "px");
    }

    private String addUnit(String value, String defaultUnit) {
        if (StringUtil.isNotNull((String)value) && value.indexOf(37) < 0 && value.indexOf("px") < 0) {
            return value + defaultUnit;
        }
        return value;
    }

    private String addStyle(String property, String value) {
        if (StringUtil.isNotNull((String)value)) {
            return ";" + property + ":" + value;
        }
        return "";
    }

    protected String renderChild(ExtWebContext extCtx, List<Control> controls, String pageId, Map<String, Control> customControlStack) {
        return ViewObjectConverter.create(extCtx, controls, pageId, customControlStack);
    }

    protected String renderCommonProperties(ExtWebContext extCtx, ControlParserData data) {
        try {
            String hidden;
            String billtype;
            String editable = data.getControl().getString("editable");
            if (editable == null && StringUtil.isNotNull((String)(billtype = data.getControl().getString("_billtype"))) && BillViewType.ListView.getValue().equalsIgnoreCase(billtype)) {
                editable = "false";
            }
            data.put("_editable", editable);
            String disable = data.getControl().getString("disable");
            if (disable != null && (disable.equalsIgnoreCase("true") || disable.equalsIgnoreCase("false"))) {
                data.put("_disable", disable);
            }
            if ((hidden = data.getControl().getString("hidden")) != null && (hidden.equalsIgnoreCase("true") || hidden.equalsIgnoreCase("false"))) {
                data.put("_hidden", hidden);
            }
            return XMLTemplateUtil.parseProperties("kd/drp/ext/core/form/control/parser/template/commonproperties.xml", data).toString();
        }
        catch (DocumentException e) {
            LogUtil.error(IControlParser.class, (String)"templateName commonproperties is not found.", (Throwable)e);
            return "";
        }
    }
}

