/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.control;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.ControlSortByIndex;
import kd.occ.ocepfp.core.form.view.parser.XmlSerial;

public abstract class MixControl
extends Control
implements XmlSerial {
    @JsonIgnore
    protected Map<String, Control> controlElement = new LinkedHashMap<String, Control>();
    List<Control> data = new ArrayList<Control>();
    boolean isSorted = false;

    public MixControl() {
    }

    public MixControl(int columnCount) {
        super(columnCount);
    }

    public List<Control> getChilds() {
        this.addSordData();
        return this.data;
    }

    public void setChilds(List<Control> childs) {
        if (childs != null && childs.size() > 0) {
            for (Control child : childs) {
                child.setParentControl(this);
                this.controlElement.put(child.getId(), child);
            }
        }
        this.data = childs;
    }

    @JsonIgnore
    protected List<Control> getOriginalChilds() {
        return this.data;
    }

    @JsonIgnore
    protected void addChild(Control control) {
        if (control.getParentControl() != null && control.getParentControl().containsKey("_isfilter")) {
            control.setIsFilterField(control.getParentControl().isFilterField());
        }
        if (!control.containsKey("index")) {
            control.setIndex(this.data.size() + 1);
            control.put("_SI", Boolean.TRUE);
        }
        this.data.add(control);
    }

    @JsonIgnore
    private synchronized void addSordData() {
        if (!this.isSorted) {
            Collections.sort(this.data, new ControlSortByIndex());
            this.isSorted = true;
        }
    }

    @Override
    @JsonIgnore
    public boolean hasChild() {
        return this.data != null && this.data.size() > 0;
    }

    @Override
    @JsonIgnore
    public Map<String, Control> getElement() {
        return this.controlElement;
    }

    @JsonIgnore
    public Map<String, Control> getControlElement() {
        return this.controlElement;
    }

    @JsonIgnore
    public void setControlElement(Map<String, Control> controlElement) {
        this.controlElement = controlElement;
    }

    @Override
    protected void regPrivateProperties() {
    }
}

