/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.dispatch;

import java.util.Locale;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.CloseEvent;
import kd.occ.ocepfp.core.form.event.ConfirmPopDataEvent;
import kd.occ.ocepfp.core.form.event.CountTimeoutEvent;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.GetEnableGroupEvent;
import kd.occ.ocepfp.core.form.event.GoHistoryEvent;
import kd.occ.ocepfp.core.form.event.LevelClickEvent;
import kd.occ.ocepfp.core.form.event.LoadAdminDivisionEvent;
import kd.occ.ocepfp.core.form.event.LoadCardDataEvent;
import kd.occ.ocepfp.core.form.event.LoadCountryEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.LoadFilterDataEvent;
import kd.occ.ocepfp.core.form.event.LoadPopPanelDataEvent;
import kd.occ.ocepfp.core.form.event.LocationCallBackEvent;
import kd.occ.ocepfp.core.form.event.LocationEvent;
import kd.occ.ocepfp.core.form.event.MessageCallBackEvent;
import kd.occ.ocepfp.core.form.event.OnTimeEvent;
import kd.occ.ocepfp.core.form.event.PayBackEvent;
import kd.occ.ocepfp.core.form.event.ScanCodeEvent;
import kd.occ.ocepfp.core.form.event.SearchEvent;
import kd.occ.ocepfp.core.form.event.SelectAllEvent;
import kd.occ.ocepfp.core.form.event.SelectDataEvent;
import kd.occ.ocepfp.core.form.event.SelectionEvent;
import kd.occ.ocepfp.core.form.event.ToolbarClickEvent;
import kd.occ.ocepfp.core.form.event.UpdateFlexMetaEvent;
import kd.occ.ocepfp.core.form.view.parser.PageView;

public class EventFactory {
    public static ClientEvent getClientEvent(ExtWebContext extCtx, PageView pageView) {
        Control control;
        String event = extCtx.getForm().getEvent().toLowerCase(Locale.ENGLISH);
        ClientEvent clientEvent = null;
        switch (event) {
            case "loaddata": 
            case "refresh": 
            case "onpage": 
            case "getrecordcount": {
                clientEvent = new LoadDataEvent(extCtx, pageView);
                break;
            }
            case "dosearch": {
                clientEvent = new SearchEvent(extCtx, pageView);
                break;
            }
            case "toolbarclick": {
                clientEvent = new ToolbarClickEvent(extCtx, pageView);
                break;
            }
            case "datachange": {
                clientEvent = new DataChangeEvent(extCtx, pageView);
                break;
            }
            case "onmessageback": {
                clientEvent = new MessageCallBackEvent(extCtx, pageView);
                break;
            }
            case "gohistory": {
                clientEvent = new GoHistoryEvent(extCtx, pageView);
                break;
            }
            case "onrowdoubleclick": 
            case "confirmselectdata": {
                clientEvent = new SelectionEvent(extCtx, pageView);
                if (StringUtil.isNull((String)clientEvent.getId())) {
                    clientEvent.setId(pageView.getMetadata().getEntries().get(0).getId());
                    break;
                }
                ((SelectionEvent)clientEvent).setCurrentEntryId(clientEvent.getId());
                break;
            }
            case "confirmskudata": {
                clientEvent = new SelectionEvent(extCtx, pageView);
                if (StringUtil.isNull((String)clientEvent.getId())) {
                    clientEvent.setId(pageView.getMetadata().getEntries().get(0).getId());
                    break;
                }
                ((SelectionEvent)clientEvent).setCurrentEntryId(clientEvent.getId());
                break;
            }
            case "popselectdata": 
            case "dropselectdata": {
                clientEvent = new SelectDataEvent(extCtx, pageView);
                break;
            }
            case "onclick": {
                clientEvent = new ClickEvent(extCtx, pageView);
                break;
            }
            case "ontime": {
                clientEvent = new OnTimeEvent(extCtx, pageView);
                break;
            }
            case "loadcarddata": {
                clientEvent = new LoadCardDataEvent(extCtx, pageView);
                break;
            }
            case "loadfilterdata": {
                clientEvent = new LoadFilterDataEvent(extCtx, pageView);
                break;
            }
            case "onselectall": 
            case "onrowselected": {
                clientEvent = new SelectAllEvent(extCtx, pageView);
                break;
            }
            case "loadadmindivision": {
                clientEvent = new LoadAdminDivisionEvent(extCtx, pageView);
                break;
            }
            case "loadcountry": {
                clientEvent = new LoadCountryEvent(extCtx, pageView);
                break;
            }
            case "oncustomevent": {
                clientEvent = new CustomEvent(extCtx, pageView);
                break;
            }
            case "loadpoppaneldata": {
                clientEvent = new LoadPopPanelDataEvent(extCtx, pageView);
                break;
            }
            case "confirmpopdata": {
                clientEvent = new ConfirmPopDataEvent(extCtx, pageView);
                break;
            }
            case "close": {
                clientEvent = new CloseEvent(extCtx, pageView);
                break;
            }
            case "updateflexmeta": {
                clientEvent = new UpdateFlexMetaEvent(extCtx, pageView);
                break;
            }
            case "counttimeout": {
                clientEvent = new CountTimeoutEvent(extCtx, pageView);
                break;
            }
            case "payback": {
                clientEvent = new PayBackEvent(extCtx, pageView);
                break;
            }
            case "getenablegroup": {
                clientEvent = new GetEnableGroupEvent(extCtx, pageView);
                break;
            }
            case "locationcallback": {
                clientEvent = new LocationCallBackEvent(extCtx, pageView);
                break;
            }
            case "initCountDown": {
                clientEvent = new LocationCallBackEvent(extCtx, pageView);
                break;
            }
            case "onscancode": {
                clientEvent = new ScanCodeEvent(extCtx, pageView);
                break;
            }
            case "onlevelclick": {
                clientEvent = new LevelClickEvent(extCtx, pageView);
                break;
            }
            case "onlocation": {
                clientEvent = new LocationEvent(extCtx, pageView);
                break;
            }
            default: {
                clientEvent = new ClientEvent(extCtx, pageView);
            }
        }
        if (clientEvent instanceof SelectionEvent && StringUtil.isNotNull((String)clientEvent.getId()) && (control = (Control)pageView.getPageBody().getControl(clientEvent.getId())) != null) {
            if (event.equalsIgnoreCase("toolbarclick") && pageView.getBillViewType().equalsIgnoreCase(BillViewType.ListView.getValue())) {
                ((SelectionEvent)clientEvent).setCurrentEntryId(pageView.getPageBody().getFirstDataGridId());
            } else {
                String currentEntryId;
                if (StringUtil.isNotNull((String)control.getSrcDataGrid())) {
                    Control dataGrid = (Control)pageView.getPageBody().getControl(control.getSrcDataGrid());
                    currentEntryId = dataGrid.getId();
                } else {
                    currentEntryId = pageView.getPageBody().getDataGridIds().size() == 1 ? pageView.getPageBody().getDataGridIds().get(0) : (StringUtil.isNotNull((String)control.getDepend()) ? control.getDepend() : control.getId());
                }
                ((SelectionEvent)clientEvent).setCurrentEntryId(currentEntryId);
            }
        }
        return clientEvent;
    }
}

