/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.dispatch;

import com.alibaba.fastjson.JSONObject;
import java.security.KeyPair;
import java.sql.ResultSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.RSAUtils;
import kd.occ.ocepfp.common.constant.ExtDbRouter;
import kd.occ.ocepfp.common.entity.ExtResponse;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.MiniProgramResponse;
import kd.occ.ocepfp.common.util.ExtAppCache;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.portal.AbstractPortalGateWay;
import kd.occ.ocepfp.core.service.miniprogram.MiniProgramLoginHelper;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;
import kd.occ.ocepfp.core.service.portal.PortalPluginUtil;

public class LoginDispatcher {
    private static final String js_code = "js_code";
    private static final String eventparam = "eventparam";
    private static final String session_key = "token";
    private static Log logger = LogFactory.getLog(LoginDispatcher.class);

    public static final ExtResponse getPublicKey(ExtWebContext extCtx) {
        ExtResponse response = new ExtResponse();
        try {
            KeyPair keyPair = RSAUtils.generateKeyPair();
            String publicKey = RSAUtils.generateBase64Key((byte[])keyPair.getPublic().getEncoded());
            String privateKey = RSAUtils.generateBase64Key((byte[])keyPair.getPrivate().getEncoded());
            ExtAppCache.setPrivateValue((String)LoginDispatcher.getGlobalSessionIdKey(), (Object)privateKey);
            response.setData((Object)publicKey);
        }
        catch (Exception e) {
            response.setCode(500);
            response.setMessage(StringUtil.getErrorMsg((Exception)e));
        }
        return response;
    }

    public static final ExtResponse getMiniProgramToken(ExtWebContext extCtx) {
        String jsCode;
        ExtResponse response;
        String plugin = LoginDispatcher.getPortalPlugin(extCtx, extCtx.getForm().getPortalIdentity());
        AbstractPortalGateWay portalGateWay = PortalPluginUtil.getPortalGateWay(extCtx, plugin);
        String extAppId = portalGateWay.getExtAppId(extCtx);
        String extAppSecret = portalGateWay.getExtAppSecret(extCtx);
        if (StringUtil.isNull((String)extAppId) || StringUtil.isNull((String)extAppSecret)) {
            extAppId = "";
            extAppSecret = "";
        }
        if ((response = MiniProgramLoginHelper.getAutoLoginResponse(extCtx, extAppId, extAppSecret, jsCode = extCtx.getForm().getString(js_code))).getCode() == 200) {
            DynamicObject userInfo = (DynamicObject)extCtx.getForm().get((Object)"loginUserInfo");
            AbstractPortalGateWay loginGateWay = ExtPortalServiceHelper.getPortalPlugin(extCtx);
            if (loginGateWay != null) {
                loginGateWay.afterLogin(extCtx, userInfo.getString("openid"), userInfo.getString("unionid"));
            }
        }
        return response;
    }

    public static final ExtResponse memberRegister(ExtWebContext extCtx) {
        try {
            AbstractPortalGateWay loginGateWay;
            String token = extCtx.getForm().getString(session_key);
            long orgId = LoginDispatcher.getMemberOrgId(extCtx);
            JSONObject eventParam = (JSONObject)extCtx.getForm().getJson(eventparam, JSONObject.class);
            ExtResponse response = MiniProgramLoginHelper.miniProgramMemberRegister(extCtx, eventParam, token, orgId);
            if (response.getCode() == 200 && (loginGateWay = ExtPortalServiceHelper.getPortalPlugin(extCtx)) != null) {
                loginGateWay.afterRegisterFirst(extCtx, token);
            }
            return response;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            MiniProgramResponse response = new MiniProgramResponse();
            response.setCode(500);
            response.setMessage(StringUtil.getErrorMsg((Exception)ex));
            return response;
        }
    }

    public static ExtResponse updateMemberPhoneNumber(ExtWebContext extCtx) {
        try {
            AbstractPortalGateWay loginGateWay;
            String token = extCtx.getForm().getString(session_key);
            long orgId = LoginDispatcher.getMemberOrgId(extCtx);
            JSONObject eventParam = (JSONObject)extCtx.getForm().getJson(eventparam, JSONObject.class);
            ExtResponse response = MiniProgramLoginHelper.updateMemberPhoneNumber(extCtx, eventParam, token, orgId);
            if (response.getCode() == 200 && (loginGateWay = ExtPortalServiceHelper.getPortalPlugin(extCtx)) != null) {
                loginGateWay.afterRegisterSecond(extCtx, token);
            }
            return response;
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
            MiniProgramResponse response = new MiniProgramResponse();
            response.setCode(500);
            response.setMessage(StringUtil.getErrorMsg((Exception)ex));
            return response;
        }
    }

    private static long getMemberOrgId(ExtWebContext extCtx) {
        String plugin = LoginDispatcher.getPortalPlugin(extCtx, extCtx.getForm().getPortalIdentity());
        AbstractPortalGateWay portalGateWay = PortalPluginUtil.getPortalGateWay(extCtx, plugin);
        if (portalGateWay == null) {
            return 0L;
        }
        return portalGateWay.getExtAppOrgId(extCtx);
    }

    public static String getPortalPlugin(ExtWebContext extCtx, String portal) {
        return LoginDispatcher.queryPortalPlugin(extCtx, portal);
    }

    public static final String queryPortalPlugin(ExtWebContext extCtx, String portal) {
        char clientType = extCtx.isFromMobile() ? (char)'5' : '1';
        SqlParameter param1 = new SqlParameter(":clienttype", 1, (Object)Character.valueOf(clientType));
        SqlParameter param2 = new SqlParameter(":number", 12, (Object)portal);
        return (String)DB.query((DBRoute)ExtDbRouter.EXT, (String)"SELECT FID,FPLUGIN FROM T_OCEPFP_PLATFORM WHERE FENABLE='1' and FCLIENTTYPE=? and FNUMBER=? ORDER BY FPRIORITY", (Object[])new SqlParameter[]{param1, param2}, (ResultSetHandler)new ResultSetHandler<String>(){

            public String handle(ResultSet resultSet) throws Exception {
                String result = "";
                if (resultSet.next()) {
                    result = resultSet.getString("FPLUGIN");
                }
                return result;
            }
        });
    }

    private static final String getGlobalSessionIdKey() {
        return String.format("loginAccessKey_%s", RequestContext.get().getGlobalSessionId());
    }
}

