/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.dispatch;

import java.util.HashMap;
import java.util.Map;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocepfp.common.entity.ExtResponse;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.Form;
import kd.occ.ocepfp.common.entity.LoadViewResponse;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.dispatch.LoginDispatcher;
import kd.occ.ocepfp.core.form.dispatch.ViewDispatcher;
import kd.occ.ocepfp.core.form.view.parser.JfsXMLLoader;
import kd.occ.ocepfp.core.form.view.parser.PageViewCache;
import kd.occ.ocepfp.core.login.LoginCheckHelper;
import kd.occ.ocepfp.core.login.LoginCheckResult;
import kd.occ.ocepfp.core.orm.OrmBuilder;

public class ViewActionDispatcher {
    protected static Log logger = LogFactory.getLog(ViewActionDispatcher.class);
    private static final String Event_LoadView = "loadView";
    private static final String Event_Rebuild = "rebuild";
    private static final String Event_GetBuildStr = "getbuildstr";
    private static final String Event_GetPrivacyPolicy = "getprivacypolicy";

    public static final ExtResponse dispatch(ExtWebContext extCtx) {
        JfsXMLLoader.initAllXML(extCtx);
        LoginCheckResult loginCheckResult = LoginCheckHelper.check(extCtx);
        ExtResponse response = null;
        if (!loginCheckResult.isSuccess()) {
            response = new ExtResponse();
            response.setCode(900);
            response.setLogin((Object)loginCheckResult);
            return response;
        }
        return ViewActionDispatcher.getEventResponse(extCtx);
    }

    public static final ExtResponse dispatchLoadView(OpenParam openParam) {
        ExtWebContext extCtx = new ExtWebContext();
        extCtx.setForm(new Form());
        extCtx.getForm().put((Object)"p", (Object)openParam.getString("p"));
        if (openParam.getCustomParam().getBoolean("force_login").booleanValue()) {
            extCtx.getForm().put((Object)"force_login", (Object)true);
            openParam.getCustomParam().remove((Object)"force_login");
        }
        for (Map.Entry entry : openParam.entrySet()) {
            if (((String)entry.getKey()).equalsIgnoreCase("customparam")) continue;
            extCtx.getForm().put(entry.getKey(), entry.getValue());
        }
        if (openParam.getCustomParam().size() > 0) {
            HashMap<String, SimpleMap> eventParam = new HashMap<String, SimpleMap>(2);
            eventParam.put("customparam", openParam.getCustomParam());
            extCtx.getForm().put((Object)"eventparam", (Object)JsonUtil.toString(eventParam));
        }
        extCtx.getForm().put((Object)"event", (Object)Event_LoadView);
        return ViewActionDispatcher.dispatch(extCtx);
    }

    private static final ExtResponse getEventResponse(ExtWebContext extCtx) {
        String event = extCtx.getForm().getEvent();
        ExtResponse response = null;
        long begin = System.currentTimeMillis();
        switch (event) {
            case "loadView": {
                response = ViewActionDispatcher.loadView(extCtx);
                break;
            }
            case "wxLogin": {
                response = LoginDispatcher.getMiniProgramToken(extCtx);
                break;
            }
            case "regFans": {
                response = LoginDispatcher.memberRegister(extCtx);
                break;
            }
            case "wxRegister": {
                response = LoginDispatcher.updateMemberPhoneNumber(extCtx);
                break;
            }
            case "getPublicKey": {
                response = LoginDispatcher.getPublicKey(extCtx);
                break;
            }
            case "rebuild": {
                response = new ExtResponse();
                OrmBuilder.buildMetadata(extCtx, extCtx.getForm().getViewId(), true);
                break;
            }
            case "getbuildstr": {
                response = new ExtResponse();
                response.setData((Object)PageViewCache.getPageViewStr(extCtx.getForm().getViewId()));
                break;
            }
            case "getprivacypolicy": {
                response = new ExtResponse();
                response.setData((Object)ViewActionDispatcher.getPrivacyPolicy(extCtx));
                break;
            }
            default: {
                response = ViewActionDispatcher.doAction(extCtx);
            }
        }
        response.setM(System.currentTimeMillis() - begin);
        return response;
    }

    private static final ExtResponse loadView(ExtWebContext extCtx) {
        LoadViewResponse response = null;
        try {
            response = ViewDispatcher.renderView(extCtx);
            return response;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            StackTraceElement[] sts = e.getStackTrace();
            StringBuilder b = new StringBuilder(400);
            b.append(e.getMessage()).append("\r\n");
            for (StackTraceElement st : sts) {
                b.append(st.toString()).append("\r\n");
            }
            response = new LoadViewResponse();
            response.setCode(500);
            if (e instanceof KDException && ((KDException)e).getErrorCode().getCode().equalsIgnoreCase("###")) {
                response.setCode(550);
                response.setMessage(((KDException)e).getErrorCode().getMessage());
            }
            response.setDetail(b.toString());
            return response;
        }
    }

    private static final ExtResponse doAction(ExtWebContext extCtx) {
        ExtResponse response = ViewDispatcher.dispatch(extCtx);
        return response;
    }

    private static final String getPrivacyPolicy(ExtWebContext extCtx) {
        String description = (String)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocbmall", (String)"PortalService", (String)"getPrivacyPolicy", (Object[])new Object[]{extCtx.getForm().getPortalIdentity()});
        return StringUtil.isNotNull((String)description) ? description : "";
    }
}

