/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.dispatch;

import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocepfp.common.entity.ExtResponse;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.LoadViewResponse;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.dispatch.EventFactory;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadFilterDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.AbstractExtPlugin;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicViewBuilder;
import kd.occ.ocepfp.core.form.view.base.PageProxy;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;

public class ViewDispatcher {
    protected static Log logger = LogFactory.getLog(ViewDispatcher.class);

    public static final LoadViewResponse renderView(ExtWebContext extCtx) {
        PageView pageView = extCtx.getCurrentPageView();
        InitViewEvent clientEvent = new InitViewEvent(extCtx, pageView);
        logger.info(extCtx.getForm().getViewId() + " pageView:" + (pageView != null));
        AbstractExtFormPlugin pluginInstance = pageView.getPlugin();
        ExtDynamicView<?> dynamicView = PageProxy.getView(extCtx, pageView, true);
        dynamicView.setExtCtx(extCtx);
        dynamicView.resetView();
        boolean isModifiedInInitView = false;
        String pageTitle = null;
        if (pluginInstance != null) {
            ((AbstractExtPlugin)pluginInstance).setView(dynamicView);
            dynamicView.setInitView(true);
            isModifiedInInitView = pluginInstance.initView(clientEvent);
            pageTitle = pluginInstance.initPageTitle(clientEvent);
            dynamicView.setInitView(false);
            dynamicView.serializeCustomControl();
            LoadFilterDataEvent loadFilterDataEvent = new LoadFilterDataEvent(extCtx, pageView);
            ((AbstractExtPlugin)pluginInstance).loadFilterData(loadFilterDataEvent);
        }
        LoadViewResponse extResponse = dynamicView.toViewObject(isModifiedInInitView, pageTitle);
        return extResponse;
    }

    public static final ExtResponse dispatch(ExtWebContext extCtx) {
        ExtResponse response = new ExtResponse();
        try {
            ExtDynamicView<?> dynamicView;
            MainPortal mainPortal;
            if ("index".equalsIgnoreCase(extCtx.getForm().getViewId()) && StringUtil.isNotNull((String)(mainPortal = ExtPortalServiceHelper.getMainPortal(extCtx)).getIndexViewId())) {
                extCtx.getForm().setViewId(mainPortal.getIndexViewId());
            }
            if ((dynamicView = ExtDynamicViewBuilder.buildDynamicView(extCtx, extCtx.getForm().getViewId())) == null) {
                return response;
            }
            AbstractExtFormPlugin pluginInstance = dynamicView.getPageView().getPlugin();
            ClientEvent clientEvent = EventFactory.getClientEvent(extCtx, dynamicView.getPageView());
            if (pluginInstance != null) {
                pluginInstance.doEvent(dynamicView, clientEvent);
                dynamicView.setPreventDefault(clientEvent.getId(), clientEvent.isPreventDefault());
                response.setData(dynamicView.getViewCommandOperations());
            }
        }
        catch (KDException e) {
            LogUtil.error(ViewDispatcher.class, (String)e.getMessage());
            response.setCode(500);
            response.setMessage(StringUtil.getErrorMsg((Exception)((Object)e)));
            if (e instanceof KDException && e.getErrorCode().getCode().equalsIgnoreCase("###")) {
                response.setCode(550);
                response.setMessage(e.getErrorCode().getMessage());
            }
        }
        catch (Exception e) {
            LogUtil.error(ViewDispatcher.class, (String)e.getMessage());
            response.setCode(500);
            response.setMessage(StringUtil.getErrorMsg((Exception)e));
        }
        return response;
    }
}

