/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Option;
import kd.occ.ocepfp.core.form.control.controls.Select;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.filter.DefaultFilterBuilder;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import org.dom4j.DocumentException;

public class AbstractQueryFilterEvent
extends ClientEvent {
    private QueryFilter queryFilter;
    private static final long serialVersionUID = -8841510833565687025L;

    public AbstractQueryFilterEvent(ExtWebContext extCtx, PageView pageView) {
        super(extCtx, pageView);
        this.initQueryFilter(extCtx);
        this.initOrderBy();
    }

    private void initQueryFilter(ExtWebContext extCtx) {
        Map filterMap = (Map)this.getEventParam().get((Object)"filter");
        if (filterMap == null || filterMap.size() == 0) {
            return;
        }
        PageBody pageBody = this.getPageView().getPageBody();
        QueryFilterParam queryFilterParam = null;
        Object tempFilterParam = null;
        Object filterValue = null;
        SelectData selectDataControl = null;
        ArrayList valueList = null;
        String iservice = "";
        for (Map.Entry filterData : filterMap.entrySet()) {
            String ormKey = "";
            Control control = (Control)pageBody.getControl((String)filterData.getKey());
            if (filterData.getValue() instanceof List) {
                valueList = (ArrayList)filterData.getValue();
            } else {
                valueList = new ArrayList(2);
                valueList.add(filterData.getValue());
            }
            if (valueList == null || valueList.size() == 0) continue;
            ArrayList<Object> computeValueList = new ArrayList<Object>(valueList.size());
            if (control != null) {
                ormKey = control.getORM();
                iservice = control.getType().equalsIgnoreCase("Input") ? "like" : control.getString("iservice");
            }
            for (Object value : valueList) {
                if (!this.validateQueryValue(control, value)) continue;
                if (control != null) {
                    if (control.getType().equalsIgnoreCase("Select")) {
                        Option o = null;
                        if (value instanceof Map) {
                            o = ((Select)control).getOptionByValue(((Map)value).get("v").toString());
                            if (((Map)value).get("v") == null) {
                                value = null;
                            }
                        } else {
                            o = ((Select)control).getOptionByValue(value.toString());
                        }
                        if (o != null) {
                            iservice = o.getString("iservice");
                        }
                    } else if (control.isF7()) {
                        String baseViewId = ((SelectData)control).getSelectDataEntity(extCtx).getBaseViewId();
                        PageView selectPageView = null;
                        try {
                            if (StringUtil.isNotNull((String)baseViewId)) {
                                selectPageView = PageViewBuilder.getPageView(extCtx, baseViewId);
                            }
                        }
                        catch (IllegalAccessException | InstantiationException | DocumentException throwable) {
                            // empty catch block
                        }
                        if (value instanceof Map) {
                            value = ((Map)value).get("id");
                        }
                        if (selectPageView == null || selectPageView.getPkType() == 1) {
                            value = Long.valueOf(value.toString());
                        }
                    }
                } else if (this.getEvent().equalsIgnoreCase("dropselectdata")) {
                    selectDataControl = (SelectData)pageBody.getControl(this.getId());
                    ormKey = StringUtil.isNotNull((String)selectDataControl.getDropSearchOrm()) ? selectDataControl.getDropSearchOrm() : (StringUtil.isNotNull((String)selectDataControl.getString("display")) ? selectDataControl.getString("display") : "number,name");
                    iservice = "like";
                }
                computeValueList.add(value);
            }
            iservice = StringUtil.isNull((String)iservice) ? "=" : iservice;
            queryFilterParam = DefaultFilterBuilder.initIServiceValue((String)filterData.getKey(), ormKey, iservice, computeValueList);
            this.getQueryFilter().addFilter(queryFilterParam);
        }
    }

    private final boolean validateQueryValue(Control control, Object value) {
        Map k;
        if (StringUtil.isNull((Object)value)) {
            return false;
        }
        if (control != null && control.getType().equalsIgnoreCase("Select") && value instanceof Map && StringUtil.isNull((k = (Map)value).get("v"))) {
            return false;
        }
        return !this.getEvent().equalsIgnoreCase("dropselectdata") || !StringUtil.isNull((String)Convert.toString((Object)value));
    }

    private final void initOrderBy() {
        List orderByList = (List)this.getEventParam().get((Object)"orderby");
        if (orderByList != null && orderByList.size() > 0) {
            for (Map orderBy : orderByList) {
                Control control = (Control)this.getPageView().getPageBody().getControl((String)orderBy.get("f"));
                if (control == null || !StringUtil.isNotNull((String)control.getField()) && !StringUtil.isNotNull((String)control.getORM())) continue;
                String field = (String)orderBy.get("f");
                String mode = (String)orderBy.get("m");
                this.getQueryFilter().addOrderBy(field + (StringUtil.isNotNull((String)mode) && mode.equalsIgnoreCase("desc") ? " desc" : ""));
            }
        }
    }

    public QueryFilter getQueryFilter() {
        if (this.queryFilter == null) {
            this.queryFilter = new QueryFilter();
        }
        return this.queryFilter;
    }

    public void setQueryFilter(QueryFilter queryFilter) {
        this.queryFilter = queryFilter;
    }
}

