/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event;

import java.util.HashMap;
import java.util.Map;
import kd.bos.mvc.cache.PageCache;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.AbstractQueryFilterEvent;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.view.parser.PageView;

public class LoadDataEvent
extends AbstractQueryFilterEvent {
    private static final long serialVersionUID = 356158204805899684L;
    private static final String Refresh = "refresh";
    private Map<String, PageInfoEntity> pageInfoMap = new HashMap<String, PageInfoEntity>(2);
    private boolean isF7;

    public LoadDataEvent(ExtWebContext extCtx, PageView pageView) {
        super(extCtx, pageView);
        this.isF7 = extCtx.getForm().getBoolean("f7", Boolean.valueOf(false));
        this.initPageInfo();
        this.initParentFilter();
        this.initRefresh();
    }

    private void initPageInfo() {
        Map pageInfoMapSource = (Map)this.getEventParam().get((Object)"pageInfo");
        if (pageInfoMapSource != null) {
            for (Map.Entry entry : pageInfoMapSource.entrySet()) {
                int page = Convert.toInt(((Map)entry.getValue()).get("page"));
                int pageSize = Convert.toInt(((Map)entry.getValue()).get("pageSize"));
                this.pageInfoMap.put((String)entry.getKey(), new PageInfoEntity(page, pageSize));
            }
        }
    }

    public boolean isF7() {
        return this.isF7;
    }

    private void initParentFilter() {
        QueryFilter parentFilter;
        PageCache pageCache = new PageCache(this.getPageId());
        String parentFilterStr = pageCache.get("_parentFilter");
        if (!this.isF7() || StringUtil.isNull((String)parentFilterStr)) {
            // empty if block
        }
        if (StringUtil.isNotNull((String)parentFilterStr) && (parentFilter = (QueryFilter)JsonUtil.readValue((String)parentFilterStr, QueryFilter.class)) != null) {
            if (parentFilter.getFilter() != null && parentFilter.getFilter().size() > 0) {
                this.getQueryFilter().getFilter().addAll(parentFilter.getFilter());
            }
            if (parentFilter.getQFilters() != null && parentFilter.getQFilters().size() > 0) {
                this.getQueryFilter().addQFilters(parentFilter.getQFilters());
            }
            this.getQueryFilter().addOrderBy(parentFilter.getOrderBy());
            this.getQueryFilter().addGroupBy(parentFilter.getGroupBy());
        }
    }

    private void initRefresh() {
        if (Refresh.equalsIgnoreCase(this.getEvent())) {
            this.getQueryFilter().setRefresh(true);
        }
    }

    public int getPage() {
        PageInfoEntity pageInfoEntity = this.pageInfoMap.get(this.getPageView().getMetadata().getMainListDataGridId());
        return pageInfoEntity == null || pageInfoEntity.getPage() <= 0 ? 1 : pageInfoEntity.getPage();
    }

    public void setPage(int page) {
        PageInfoEntity pageInfoEntity = this.pageInfoMap.get(this.getPageView().getMetadata().getMainListDataGridId());
        if (pageInfoEntity == null) {
            pageInfoEntity = new PageInfoEntity();
            this.pageInfoMap.put(this.getId(), pageInfoEntity);
        }
        pageInfoEntity.setPage(page);
    }

    public int getPageSize() {
        PageInfoEntity pageInfoEntity = this.pageInfoMap.get(this.getPageView().getMetadata().getMainListDataGridId());
        return pageInfoEntity == null || pageInfoEntity.getPageSize() <= 0 ? 200 : pageInfoEntity.getPageSize();
    }

    public void setPageSize(int pageSize) {
        PageInfoEntity pageInfoEntity = this.pageInfoMap.get(this.getPageView().getMetadata().getMainListDataGridId());
        if (pageInfoEntity == null) {
            pageInfoEntity = new PageInfoEntity();
            this.pageInfoMap.put(this.getId(), pageInfoEntity);
        }
        pageInfoEntity.setPageSize(pageSize);
    }

    public Map<String, Object> getFilterParam() {
        return (Map)this.getEventParam().get((Object)"filter");
    }

    public static class PageInfoEntity {
        private int page;
        private int pageSize;

        public PageInfoEntity() {
        }

        public PageInfoEntity(int page, int pageSize) {
            this.page = page;
            this.pageSize = pageSize;
        }

        public int getPage() {
            return this.page;
        }

        public void setPage(int page) {
            this.page = page;
        }

        public int getPageSize() {
            return this.pageSize;
        }

        public void setPageSize(int pageSize) {
            this.pageSize = pageSize;
        }
    }
}

