/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.entity.operate.result.OperationResult;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.core.form.event.AbstractQueryFilterEvent;
import kd.occ.ocepfp.core.form.view.parser.PageView;

public class SelectionEvent
extends AbstractQueryFilterEvent {
    private static final long serialVersionUID = 7461796302317107458L;
    private String currentEntryId;
    private Map<String, List<SelectedRow>> selections;
    private Map<String, SelectedRow> currentSelection;
    private List<SelectedRow> confirmSelectDataRow;
    private int parentRow = -1;
    OperationResult operationResult = new OperationResult();

    public SelectionEvent(ExtWebContext extCtx, PageView pageView) {
        super(extCtx, pageView);
        this.parentRow = extCtx.getForm().getInt("row", Integer.valueOf(-1));
        this.operationResult.setSuccess(true);
    }

    public SelectedRow getCurrentRow() {
        return this.getCurrentRow(this.currentEntryId);
    }

    protected Map<String, List<SelectedRow>> getSelectionMap() {
        return this.selections;
    }

    protected Map<String, SelectedRow> getCurrentSelectionMap() {
        return this.currentSelection;
    }

    public SelectedRow getCurrentRow(String entryId) {
        entryId = entryId.toLowerCase();
        if (this.currentSelection == null || this.currentSelection.get(entryId) == null) {
            return new SelectedRow();
        }
        return this.currentSelection.get(entryId);
    }

    public List<SelectedRow> getSelections() {
        return this.getSelections(this.currentEntryId);
    }

    public List<Integer> getSelectionRowIds() {
        List<SelectedRow> selectionRows = this.getSelections();
        if (selectionRows != null && selectionRows.size() > 0) {
            ArrayList<Integer> selectedIds = new ArrayList<Integer>(16);
            for (SelectedRow selectedRow : selectionRows) {
                selectedIds.add(selectedRow.getRow());
            }
            return selectedIds;
        }
        return null;
    }

    public List<Object> getSelectionPkValues() {
        List<SelectedRow> selectionRows = this.getSelections();
        if (selectionRows != null && selectionRows.size() > 0) {
            ArrayList<Object> pkValues = new ArrayList<Object>(16);
            for (SelectedRow selectedRow : selectionRows) {
                pkValues.add(selectedRow.getPkValue());
            }
            return pkValues;
        }
        return null;
    }

    public boolean isF7() {
        return this.getEventParam().getBoolean("f7", Boolean.valueOf(false));
    }

    public List<SelectedRow> getSelections(String entryId) {
        entryId = entryId.toLowerCase();
        if (this.selections == null || this.selections.get(entryId) == null) {
            return new ArrayList<SelectedRow>(1);
        }
        return this.selections.get(entryId);
    }

    public int getRowByIndex(String entryId, int index) {
        List<SelectedRow> selectedRow = this.getSelections(entryId);
        if (selectedRow != null && selectedRow.size() > index) {
            return selectedRow.get(index).getRow();
        }
        return -1;
    }

    public void setCurrentEntryId(String entryId) {
        this.currentEntryId = entryId;
    }

    public String getCurrentEntryId() {
        return this.currentEntryId;
    }

    public void setSelections(Map<String, List<SelectedRow>> selections) {
        this.selections = selections;
    }

    public void setCurrentSelection(Map<String, SelectedRow> currentSelection) {
        this.currentSelection = currentSelection;
    }

    public int getParentRow() {
        return this.parentRow;
    }

    public void setParentRow(int parentRow) {
        this.parentRow = parentRow;
    }

    public OperationResult getOperationResult() {
        return this.operationResult;
    }

    public void setOperationResult(OperationResult operationResult) {
        this.operationResult = operationResult;
    }

    public List<SelectedRow> getConfirmSelectDataRow() {
        if (this.confirmSelectDataRow == null) {
            this.confirmSelectDataRow = new ArrayList<SelectedRow>();
            List confirmSelectdata = (List)this.getEventParam().get((Object)"confirmdata");
            if (confirmSelectdata != null && confirmSelectdata.size() > 0) {
                for (Map confirmdata : confirmSelectdata) {
                    SelectedRow selectedRow = new SelectedRow();
                    selectedRow.setPkValue(confirmdata.get("pkValue"));
                    selectedRow.setCustomData(confirmdata);
                    this.confirmSelectDataRow.add(selectedRow);
                }
            } else {
                SelectedRow selectedRow = new SelectedRow();
                selectedRow.setPkValue((Object)0);
                this.confirmSelectDataRow.add(selectedRow);
            }
        }
        return this.confirmSelectDataRow;
    }

    public void copySelections(SelectionEvent selectionEvent) {
        this.setCurrentEntryId(selectionEvent.getCurrentEntryId());
        this.setCurrentSelection(selectionEvent.getCurrentSelectionMap());
        this.setSelections(selectionEvent.getSelectionMap());
    }
}

