/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event.filter;

import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.core.form.event.filter.AbstractFilterBuilder;
import kd.occ.ocepfp.core.form.event.filter.BetweenFilterValue;
import kd.occ.ocepfp.core.form.event.filter.FilterValue;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;

public class DateTimeFilterBuilder
extends AbstractFilterBuilder {
    @Override
    public QueryFilterParam build(String id, String orm, String iservice, List<Object> valueList) {
        QueryFilterParam queryFilterParam = null;
        for (Object value : valueList) {
            QueryFilterParam tempFilterParam = new QueryFilterParam();
            tempFilterParam.setOrmKey(orm);
            tempFilterParam.setSqlCompareOperator(Enums.SqlCompareOperator.between);
            tempFilterParam.setId(id);
            tempFilterParam.setValue(this.buildFilterValue(id, orm, iservice, value));
            if (queryFilterParam == null) {
                queryFilterParam = tempFilterParam;
                continue;
            }
            queryFilterParam = queryFilterParam.or(tempFilterParam);
        }
        return queryFilterParam;
    }

    private FilterValue buildFilterValue(String id, String orm, String iservice, Object value) {
        BetweenFilterValue v = null;
        Map dateValue = (Map)value;
        switch (iservice) {
            case "today": {
                Date currentTime = TimeServiceHelper.now();
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.formatBeginTime((Date)currentTime), DateUtil.formatEndTime((Date)currentTime));
                break;
            }
            case "thisweek": {
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.getFirstDayOfWeek(), DateUtil.getLastDayOfWeek());
                break;
            }
            case "thismonth": {
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.getFirstDayOfMonth(), DateUtil.getLastDayOfMonth());
                break;
            }
            case "threemonth": {
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.getDate((int)2, (int)-3, (DateUtil.DateResetType)DateUtil.DateResetType.min), DateUtil.getCurrentDate((DateUtil.DateResetType)DateUtil.DateResetType.max));
                break;
            }
            case "thisyear": {
                break;
            }
            case "oneyear": {
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.getDate((int)1, (int)-1, (DateUtil.DateResetType)DateUtil.DateResetType.min), DateUtil.getCurrentDate((DateUtil.DateResetType)DateUtil.DateResetType.max));
                break;
            }
            case "customdate": {
                v = this.initBetweenFilterValue(dateValue.get("v"), DateUtil.toDate(dateValue.get("start")), DateUtil.toDate(dateValue.get("end")));
            }
        }
        return v;
    }
}

