/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.event.filter.BetweenFilterValue;
import kd.occ.ocepfp.core.form.event.filter.QueryFilterParam;

public class QueryFilter
implements Serializable {
    private static final long serialVersionUID = 5205273671714634194L;
    private List<QueryFilterParam> filter;
    private List<String> orderBy;
    private List<String> groupBy;
    private SimpleMap<String, QueryFilterParam> _idMap = new SimpleMap(4);
    private List<QFilter> qFilters;
    private boolean refresh = false;

    public QueryFilter() {
        this.filter = new ArrayList<QueryFilterParam>();
    }

    public final QueryFilter addOrderBy(String orderBy) {
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<String>();
        }
        this.orderBy.add(orderBy);
        return this;
    }

    public final QueryFilter addOrderBy(List<String> orderBy) {
        if (orderBy == null || orderBy.size() == 0) {
            return this;
        }
        if (this.orderBy == null) {
            this.orderBy = new ArrayList<String>();
        }
        this.orderBy.addAll(orderBy);
        return this;
    }

    public List<QueryFilterParam> getFilter() {
        return this.filter;
    }

    public List<String> getOrderBy() {
        return this.orderBy;
    }

    @JsonIgnore
    public List<QFilter> getQFilters() {
        return this.qFilters;
    }

    @JsonIgnore
    public void addQFilters(List<QFilter> qFilters) {
        this.getQFiltersPrivate().addAll(qFilters);
    }

    @JsonIgnore
    public void addQFilter(QFilter qFilters) {
        this.getQFiltersPrivate().add(qFilters);
    }

    private List<QFilter> getQFiltersPrivate() {
        if (this.qFilters == null) {
            this.qFilters = new ArrayList<QFilter>(2);
        }
        return this.qFilters;
    }

    public void setQfilterString(String qFilterStr) {
        List _qfilters;
        if (qFilterStr != null && (_qfilters = (List)SerializationUtils.fromJsonString((String)qFilterStr, List.class)) != null && _qfilters.size() > 0) {
            this.qFilters = new ArrayList<QFilter>(16);
            for (String _qfilter : _qfilters) {
                this.qFilters.add(QFilter.fromSerializedString((String)_qfilter));
            }
        }
    }

    public String getQFilterString() {
        String qfilterStr = null;
        if (null != this.qFilters && this.qFilters.size() > 0) {
            ArrayList<String> qfilterStrs = new ArrayList<String>(16);
            for (QFilter qfilter : this.qFilters) {
                String str = qfilter.toSerializedString();
                qfilterStrs.add(str);
            }
            qfilterStr = SerializationUtils.toJsonString(qfilterStrs);
        }
        return qfilterStr;
    }

    @JsonIgnore
    public String getOrderByStr() {
        if (this.orderBy != null) {
            StringBuilder r = new StringBuilder();
            for (String s : this.getOrderBy()) {
                if (r.length() > 0) {
                    r.append(",");
                }
                r.append(s);
            }
            return r.toString();
        }
        return null;
    }

    public QueryFilter addFilter(QueryFilterParam queryFilterParam) {
        if (queryFilterParam != null) {
            this.addFilter(Enums.SqlCompareOperator.equal, queryFilterParam);
        }
        return this;
    }

    public QueryFilter addFilter(String key, Enums.SqlCompareOperator sqlCompareOperator, Object value) {
        QueryFilterParam queryFilterParam = QueryFilterParam.create(key, sqlCompareOperator, value);
        return this.addFilter(queryFilterParam);
    }

    public QueryFilter addFilter(Enums.SqlCompareOperator sqlCompareOperator, QueryFilterParam queryFilterParam) {
        return this.addFilter(sqlCompareOperator, queryFilterParam, Enums.SqlLogicalOperator.AND);
    }

    public QueryFilter addFilter(Enums.SqlCompareOperator sqlCompareOperator, QueryFilterParam queryFilterParam, Enums.SqlLogicalOperator sqlLogicalOperator) {
        if (this.filter == null) {
            this.filter = new ArrayList<QueryFilterParam>();
        }
        this.filter.add(queryFilterParam);
        this.add2IdMap(queryFilterParam);
        return this;
    }

    private final void add2IdMap(QueryFilterParam queryFilterParam) {
        if (StringUtil.isNotNull((String)queryFilterParam.getId())) {
            this._idMap.put((Object)queryFilterParam.getId().toLowerCase(), (Object)queryFilterParam);
        }
    }

    @JsonIgnore
    public final QueryFilterParam getQueryFilterParam(String id) {
        return (QueryFilterParam)this._idMap.get((Object)id.toLowerCase());
    }

    public final QueryFilter addGroupBy(String groupBy) {
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.add(groupBy);
        return this;
    }

    public final QueryFilter addGroupBy(List<String> groupBy) {
        if (groupBy == null || groupBy.size() == 0) {
            return this;
        }
        if (this.groupBy == null) {
            this.groupBy = new ArrayList<String>();
        }
        this.groupBy.addAll(groupBy);
        return this;
    }

    public List<String> getGroupBy() {
        return this.groupBy;
    }

    public String toUString() {
        StringBuilder s = new StringBuilder();
        if (this.filter != null && this.filter.size() > 0) {
            for (QueryFilterParam filterParam : this.filter) {
                s.append(filterParam.toUString());
            }
        }
        s.append(",").append(Convert.toString(this.orderBy));
        s.append(",").append(Convert.toString(this.groupBy));
        s.append(",").append(this.qFilters != null ? this.qFilters.toString() : "");
        return s.toString();
    }

    public QFilter[] toQFilter() {
        return this.toQFilter(this.getQFilters());
    }

    public QFilter[] toQFilter(QFilter qfilter) {
        ArrayList<QFilter> q = new ArrayList<QFilter>(1);
        q.add(qfilter);
        return this.toQFilter(q);
    }

    public List<QFilter> toQFilterList() {
        return this.toQFilterList(this.getQFilters());
    }

    public List<QFilter> toQFilterList(List<QFilter> _qfilter) {
        boolean hasQfilter;
        boolean hasFilter = this.getFilter() != null && this.getFilter().size() > 0;
        boolean bl = hasQfilter = this.getQFilters() != null && this.getQFilters().size() > 0;
        if (hasFilter || hasQfilter) {
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
            if (hasFilter) {
                int i = 0;
                String[] ormKeys = null;
                for (QueryFilterParam filterParam : this.getFilter()) {
                    QFilter qFilter = null;
                    if (filterParam.getOrmKey() == null || !StringUtil.isNotNull((String)filterParam.getOrmKey())) continue;
                    ormKeys = filterParam.getOrmKey().split(",");
                    i = 0;
                    do {
                        List<QueryFilterParam> allFilterParams = filterParam.getAllQueryFilter();
                        for (QueryFilterParam childFilterParam : allFilterParams) {
                            QFilter tempFilter = null;
                            if (childFilterParam.getValue() instanceof BetweenFilterValue) {
                                BetweenFilterValue bv = (BetweenFilterValue)childFilterParam.getValue();
                                if (StringUtil.isNull((Object)bv.getStartValue()) && StringUtil.isNull((Object)bv.getEndValue())) continue;
                                if (StringUtil.isNotNull((Object)bv.getStartValue())) {
                                    tempFilter = new QFilter(ormKeys[i], bv.getStartCompare(), bv.getStartValue());
                                }
                                if (StringUtil.isNotNull((Object)bv.getEndValue())) {
                                    tempFilter = tempFilter == null ? new QFilter(ormKeys[i], bv.getEndCompare(), bv.getEndValue()) : tempFilter.and(new QFilter(ormKeys[i], bv.getEndCompare(), bv.getEndValue()));
                                }
                            } else {
                                List<Object> value = childFilterParam.getValue().getValue().size() == 1 ? childFilterParam.getValue().getValue().get(0) : childFilterParam.getValue().getValue();
                                tempFilter = new QFilter(ormKeys[i], childFilterParam.getSqlCompareOperator().getValue(), value);
                            }
                            if (qFilter == null) {
                                qFilter = tempFilter;
                                continue;
                            }
                            qFilter = qFilter.or(tempFilter);
                        }
                    } while (++i < ormKeys.length);
                    qFilters.add(qFilter);
                }
            }
            if (hasQfilter) {
                qFilters.addAll(_qfilter);
            }
            return qFilters;
        }
        return null;
    }

    public QFilter[] toQFilter(List<QFilter> _qfilter) {
        List<QFilter> qFilterList = this.toQFilterList(_qfilter);
        if (qFilterList != null) {
            return qFilterList.toArray(new QFilter[qFilterList.size()]);
        }
        return null;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }
}

