/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.event.filter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kd.occ.ocepfp.common.constant.Enums;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.core.form.event.filter.BetweenFilterValue;
import kd.occ.ocepfp.core.form.event.filter.FilterValue;

public class QueryFilterParam
implements Serializable {
    private static final long serialVersionUID = -3090075529896635012L;
    private String id;
    private String ormKey;
    private FilterValue value;
    private Enums.SqlLogicalOperator sqlLogicalOperator;
    private Enums.SqlCompareOperator sqlCompareOperator;
    private List<QueryFilterParam> childQueryFilterParamList = new ArrayList<QueryFilterParam>(2);

    public String getOrmKey() {
        return this.ormKey;
    }

    public static final QueryFilterParam create(String id, Enums.SqlCompareOperator sqlCompareOperator, Object value) {
        QueryFilterParam queryFilterParam = new QueryFilterParam();
        queryFilterParam.setId(id);
        queryFilterParam.setOrmKey(id);
        queryFilterParam.setSqlCompareOperator(sqlCompareOperator);
        FilterValue filterValue = new FilterValue(FilterValue.FilterValueType.Normal);
        if (!(value instanceof List)) {
            ArrayList<Object> valueList = new ArrayList<Object>(2);
            valueList.add(value);
            filterValue.setValue(valueList);
        } else {
            filterValue.setValue(value);
        }
        queryFilterParam.setValue(filterValue);
        return queryFilterParam;
    }

    public void setOrmKey(String ormKey) {
        this.ormKey = ormKey == null ? "" : ormKey;
    }

    public FilterValue getValue() {
        return this.value;
    }

    @JsonIgnore
    public List<Object> getFilterValue() {
        return this.value.getValue();
    }

    public void setValue(FilterValue value) {
        if (this.sqlCompareOperator != null && this.sqlCompareOperator == Enums.SqlCompareOperator.like) {
            value.getValue().set(0, "%" + Convert.toString((Object)value.getValue().get(0)) + "%");
        }
        this.value = value;
    }

    public Enums.SqlLogicalOperator getSqlLogicalOperator() {
        return this.sqlLogicalOperator;
    }

    public void setSqlLogicalOperator(Enums.SqlLogicalOperator sqlLogicalOperator) {
        this.sqlLogicalOperator = sqlLogicalOperator;
    }

    public Enums.SqlCompareOperator getSqlCompareOperator() {
        return this.sqlCompareOperator;
    }

    public void setSqlCompareOperator(Enums.SqlCompareOperator sqlCompareOperator) {
        this.sqlCompareOperator = sqlCompareOperator;
    }

    public QueryFilterParam or(QueryFilterParam queryFilterParam) {
        queryFilterParam.setSqlLogicalOperator(Enums.SqlLogicalOperator.OR);
        this.childQueryFilterParamList.add(queryFilterParam);
        return this;
    }

    public QueryFilterParam and(QueryFilterParam queryFilterParam) {
        queryFilterParam.setSqlLogicalOperator(Enums.SqlLogicalOperator.AND);
        this.childQueryFilterParamList.add(queryFilterParam);
        return this;
    }

    public List<QueryFilterParam> getChildQueryFilterParamList() {
        return this.childQueryFilterParamList;
    }

    public void setChildQueryFilterParamList(List<QueryFilterParam> childQueryFilterParamList) {
        this.childQueryFilterParamList = childQueryFilterParamList;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonIgnore
    public List<QueryFilterParam> getAllQueryFilter() {
        ArrayList<QueryFilterParam> allQueryFilterParamList = new ArrayList<QueryFilterParam>(2);
        allQueryFilterParamList.add(this);
        allQueryFilterParamList.addAll(this.childQueryFilterParamList);
        return allQueryFilterParamList;
    }

    public String toUString() {
        StringBuilder str = new StringBuilder();
        str.append("{").append(Convert.toString((String)this.id)).append("[").append(Convert.toString((String)this.ormKey)).append(this.sqlCompareOperator.getValue());
        if (this.value instanceof BetweenFilterValue) {
            str.append(Convert.toString((Object)((BetweenFilterValue)this.value).getStartValue())).append(",");
            str.append(Convert.toString((Object)((BetweenFilterValue)this.value).getEndValue()));
        } else {
            str.append(Convert.toString(this.value.getValue()));
        }
        str.append("]");
        str.append(this.sqlLogicalOperator != null ? this.sqlLogicalOperator.getValue() : "");
        str.append("}");
        return str.toString();
    }
}

