/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.occ.ocepfp.common.constant.BillDataType;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.FormValue;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.CodeRuleUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SelectionEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtBillViewPlugin;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.formatter.ExtBillFormDataFormatter;
import kd.occ.ocepfp.core.form.util.BillSelectionEventUtil;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.servicehelper.ExtFormServiceHelper;

public class ExtBillViewPlugin
extends AbstractExtBillViewPlugin {
    @Override
    public final void initialize(ClientEvent clientEvent) {
        BillFormData billData = new BillFormData(((ExtBillView)this.getView()).getViewId(), (ExtDynamicView)this.getView(), (AbstractExtFormPlugin)this);
        DynamicObject cacheDataObject = null;
        if (!clientEvent.isLoadDataEvent()) {
            cacheDataObject = billData.getCacheAll();
        }
        if (cacheDataObject != null) {
            billData.setDataObject(cacheDataObject);
        }
        this.setBillData(billData);
        this.updateUnSubmitValue(clientEvent.getBillData(), clientEvent);
    }

    @Override
    public boolean initView(InitViewEvent initViewEvent) {
        return true;
    }

    @Override
    protected void doEvent(ClientEvent clientEvent) {
        String billStatusField = ((ExtBillView)this.getView()).getPageView().getPageBody().getBillStatusField();
        String oldBillStatusValue = "-";
        if (StringUtil.isNotNull((String)billStatusField)) {
            oldBillStatusValue = "";
            if (((BillFormData)this.getBillData()).getDataObject() != null) {
                oldBillStatusValue = ((BillFormData)this.getBillData()).getDataObject().getString(billStatusField);
            }
        }
        switch (clientEvent.getType().toLowerCase(Locale.ENGLISH)) {
            case "dosearch": {
                this.onSearch((LoadDataEvent)clientEvent);
                if (!clientEvent.isPreventDefault()) break;
                return;
            }
        }
        super.doEvent(clientEvent);
        if (!oldBillStatusValue.equalsIgnoreCase("-")) {
            String newBillStatusValue = "";
            if (((BillFormData)this.getBillData()).getDataObject() != null) {
                newBillStatusValue = ((BillFormData)this.getBillData()).getDataObject().getString(billStatusField);
            }
            if (!oldBillStatusValue.equalsIgnoreCase(newBillStatusValue)) {
                super.doDisableField();
                super.doHideField();
            }
        }
        this.updateDefaultFieldValue();
    }

    private void updateDefaultFieldValue() {
        List<String> autoSetValueFields = ((ExtBillView)this.getView()).getPageView().getPageBody().getAutoSetValueFields();
        DynamicObject dataObject = ((BillFormData)this.getBillData()).getDataObject();
        for (String fieldId : autoSetValueFields) {
            if (dataObject == null) continue;
            ((BillFormData)this.getBillData()).updateValue(fieldId, dataObject.get(fieldId));
        }
    }

    @Override
    public DynamicObject onDataLoad(LoadDataEvent event) {
        DynamicObject dataObject = null;
        Object pkValue = ((ExtBillView)this.getView()).getExtCtx().getForm().getPkValue();
        dataObject = pkValue != null && !((ExtBillView)this.view).getPageView().getBillDataType().equalsIgnoreCase(BillDataType.Custom.getValue()) ? ExtFormServiceHelper.loadSingle(((ExtBillView)this.getView()).getExtCtx(), ((ExtBillView)this.getView()).getViewId(), pkValue) : ((BillFormData)this.getBillData()).createNewBillData();
        ((BillFormData)this.getBillData()).setDataObject(dataObject);
        return dataObject;
    }

    private final void doLoadData(LoadDataEvent event) {
        BillFormData billData = (BillFormData)this.getBillData();
        if (billData.getDataObject() == null) {
            DynamicObject dataObject = this.onDataLoad(event);
            if (dataObject == null) {
                dataObject = ((BillFormData)this.getBillData()).createNewBillData();
            }
            ((BillFormData)this.getBillData()).setDataObject(dataObject);
            this.afterDataLoad(event);
            this.setBillNoStatus();
            ((BillFormData)this.getBillData()).getFormModifiedManager().setAllModified();
        }
    }

    private final void setBillNoStatus() {
        MainMetadata metadata = MetadataFactory.getMetadata(((ExtBillView)this.getView()).getExtCtx());
        if (metadata.getBillNoField() != null && StringUtil.isNotNull((String)metadata.getBillNoField().getBaseViewId()) && !CodeRuleUtil.isHaveCodeRule((String)metadata.getBillNoField().getBaseViewId())) {
            ((ExtBillView)this.view).disable(metadata.getBillNoField().getId(), false);
        }
    }

    @Override
    protected final void loadData(LoadDataEvent event) {
        ((BillFormData)this.getBillData()).beginInit();
        this.doLoadData(event);
        ((BillFormData)this.getBillData()).endInit();
        if (!event.isPreventDefault()) {
            ExtDynamicObject dataObject = ExtBillFormDataFormatter.newInstance((ExtDynamicView)this.getView(), ((BillFormData)this.getBillData()).getDataObject()).convert();
            ((ExtBillView)this.getView()).bindData(dataObject);
        }
        this.afterBindData(event);
    }

    public void afterBindData(LoadDataEvent event) {
    }

    @Override
    protected final void afterDoEvent(ClientEvent clientEvent) {
        super.afterDoEvent(clientEvent);
        ((BillFormData)this.getBillData()).saveAll2Cache();
    }

    private final void updateUnSubmitValue(SimpleMap<String, Object> postBillData, ClientEvent clientEvent) {
        if (postBillData != null && postBillData.size() > 0) {
            Control control = null;
            SimpleMap needDataChageMap = new SimpleMap(4);
            for (Map.Entry postData : postBillData.entrySet()) {
                if (((String)postData.getKey()).equalsIgnoreCase(clientEvent.getId()) && clientEvent.getEvent().equalsIgnoreCase("confirmselectdata") || (control = (Control)((ExtBillView)this.view).getPageView().getPageBody().getControl((String)postData.getKey())) == null) continue;
                if (control.getType().equalsIgnoreCase("DataGrid")) {
                    List entryDataList = (List)postData.getValue();
                    if (entryDataList == null) continue;
                    for (Map entryDataMap : entryDataList) {
                        int row = Convert.toInt(entryDataMap.get("row"));
                        int parentRow = Convert.toInt(entryDataMap.get("_pr"));
                        if (parentRow >= 0) {
                            this.setParentCurrentSelectRow(((DataGrid)control).getParentDataGrid(), parentRow);
                        }
                        for (Map.Entry entryData : entryDataMap.entrySet()) {
                            if (((String)entryData.getKey()).equalsIgnoreCase(clientEvent.getId()) && clientEvent.getEvent().equalsIgnoreCase("confirmselectdata") || ((String)entryData.getKey()).equalsIgnoreCase("row") || ((String)entryData.getKey()).equalsIgnoreCase(control.getId() + "_uqrow") || ((String)entryData.getKey()).equalsIgnoreCase("_pr")) continue;
                            this.updateNoDataChangeValue((Control)((ExtBillView)this.view).getPageView().getPageBody().getControl((String)entryData.getKey()), (String)entryData.getKey(), row, parentRow, entryData.getValue(), false, (SimpleMap<String, FormValue>)needDataChageMap, clientEvent);
                        }
                    }
                    continue;
                }
                this.updateNoDataChangeValue(control, (String)postData.getKey(), -1, -1, postData.getValue(), false, (SimpleMap<String, FormValue>)needDataChageMap, clientEvent);
            }
            if (needDataChageMap.size() > 0) {
                for (Map.Entry postData : needDataChageMap.entrySet()) {
                    FormValue formValue = (FormValue)postData.getValue();
                    if (formValue.getId().equalsIgnoreCase(clientEvent.getId()) || (control = (Control)((ExtBillView)this.view).getPageView().getPageBody().getControl(formValue.getId())) == null) continue;
                    if (formValue.getParentRow() >= 0) {
                        DataGrid subDataGrid = (DataGrid)((ExtBillView)this.view).getPageView().getPageBody().getControl(control.getSrcDataGrid());
                        this.setParentCurrentSelectRow(subDataGrid.getParentDataGrid(), formValue.getParentRow());
                    }
                    this.updateValue(control, formValue.getId(), formValue.getRow(), formValue.getParentRow(), formValue.getValue(), true, clientEvent);
                }
            }
            ((BillFormData)this.getBillData()).setCurrentSelection(null);
        }
    }

    private final void setParentCurrentSelectRow(String parentDataGridId, int row) {
        if (row >= 0) {
            ((BillFormData)this.getBillData()).preSetCurrentSelection(parentDataGridId, row);
        }
    }

    private final void updateNoDataChangeValue(Control control, String key, int row, int parentRow, Object value, boolean doDataChange, SimpleMap<String, FormValue> needDataChageMap, ClientEvent clientEvent) {
        if (!control.isEnableDatachanged()) {
            this.updateValue(control, key, row, parentRow, value, false, clientEvent);
        } else {
            needDataChageMap.put((Object)key, (Object)new FormValue(key, row, parentRow, value));
        }
    }

    private final void updateValue(Control control, String key, int row, int parentRow, Object value, boolean doDataChange, ClientEvent clientEvent) {
        if (!control.getType().equalsIgnoreCase("DataGrid")) {
            this.updateValue(key, row, value, doDataChange, clientEvent);
        } else {
            List entryList = (List)value;
            if (entryList != null && entryList.size() > 0) {
                this.updateEntryValue(key, entryList, doDataChange, clientEvent);
            }
        }
    }

    private final boolean updateValue(String key, int row, Object value, boolean doDataChange, ClientEvent clientEvent) {
        boolean isUpdated = true;
        if (doDataChange) {
            Control control;
            DataChangeEvent dataChangeEvent = new DataChangeEvent(((ExtBillView)this.view).getExtCtx(), ((ExtBillView)this.view).getPageView(), key, value, row);
            if (clientEvent instanceof SelectionEvent) {
                dataChangeEvent.copySelections((SelectionEvent)clientEvent);
            }
            if ((control = (Control)((ExtBillView)this.view).getPageView().getPageBody().getControl(dataChangeEvent.getId())).isF7()) {
                dataChangeEvent.setValue(((BillFormData)this.billData).loadF7Data(dataChangeEvent.getId(), value));
            }
            this.tryOnDataChange(dataChangeEvent);
            boolean bl = isUpdated = !dataChangeEvent.isPreventDefault();
        }
        if (isUpdated) {
            ((BillFormData)this.getBillData()).updateValue(key, row, value);
        }
        return isUpdated;
    }

    private final void updateEntryValue(String entityId, List<Map> entryList, boolean doDataChange, ClientEvent clientEvent) {
        int row = -1;
        for (Map entry : entryList) {
            row = (Integer)entry.get("row");
            boolean isUpdate = false;
            for (Map.Entry entryData : entry.entrySet()) {
                if (((String)entryData.getKey()).equalsIgnoreCase("row") || ((String)entryData.getKey()).equalsIgnoreCase(entityId + "_uqrow")) continue;
                isUpdate = this.updateValue((String)entryData.getKey(), row, entryData.getValue(), doDataChange, clientEvent) || isUpdate;
            }
        }
    }

    @Override
    protected final void validateSelectionRow(SelectionEvent selectionClientEvent) {
        BillSelectionEventUtil.validateSelectionRow(selectionClientEvent, (AbstractFormData)this.getBillData());
    }

    @Override
    public final void tryOnDataChange(DataChangeEvent event) {
        Control control = (Control)((ExtBillView)this.view).getPageView().getPageBody().getControl(event.getId());
        Object oldValue = event.getOldValue();
        if (control != null && StringUtil.isNotNull((String)control.getSrcDataGrid())) {
            if (!control.isF7()) {
                oldValue = ((BillFormData)this.getBillData()).getEntryRowData(control.getSrcDataGrid(), event.getRow(), event.getId());
                event.setOldValue(oldValue);
            }
        } else {
            oldValue = ((BillFormData)this.getBillData()).get(event.getId());
            event.setOldValue(oldValue);
        }
        ((BillFormData)this.billData).updateValue(event.getId(), event.getRow(), event.getValue());
        this.onDataChange(event);
        if (event.isPreventDefault()) {
            ((BillFormData)this.billData).updateValue(event.getId(), event.getRow(), event.getOldValue());
            return;
        }
    }

    public void onSearch(LoadDataEvent event) {
    }

    @Override
    protected final DynamicObject[] getCurrentRowData(SelectionEvent selectionEvent) {
        DynamicObject[] data = new DynamicObject[]{((BillFormData)this.getBillData()).getDataObject()};
        return data;
    }

    protected final boolean checkFormRequired() {
        Map<String, Map> formElement = ((ExtBillView)this.view).getPageView().getPageBody().getFormElement();
        ArrayList<String> requiredNames = new ArrayList<String>();
        for (String key : formElement.keySet()) {
            Control control = (Control)((ExtBillView)this.view).getPageView().getPageBody().getControl(key);
            if (!"true".equalsIgnoreCase(control.getRequired())) continue;
            switch (control.getType()) {
                case "Input": {
                    if (!StringUtil.isNull((String)((BillFormData)this.billData).getString(key))) break;
                    requiredNames.add(control.getName());
                    break;
                }
                case "AdminDivision": {
                    if (((BillFormData)this.billData).getLong(key) != 0L) break;
                    requiredNames.add(control.getName());
                }
            }
        }
        if (requiredNames.size() > 0) {
            ((ExtBillView)this.view).showMessage("\u6709\u5185\u5bb9\u672a\u586b\u5199\uff1a" + StringUtil.join((Object[])requiredNames.toArray(new String[requiredNames.size()]), (String)","));
            return false;
        }
        return true;
    }
}

