/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.list.query.PageRowCacheUtils;
import kd.occ.ocepfp.common.constant.BillDataType;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.BillStatus;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.control.controls.Operation;
import kd.occ.ocepfp.core.form.control.controls.Option;
import kd.occ.ocepfp.core.form.control.controls.Plugin;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.event.SearchEvent;
import kd.occ.ocepfp.core.form.event.SelectionEvent;
import kd.occ.ocepfp.core.form.event.ToolbarClickEvent;
import kd.occ.ocepfp.core.form.event.filter.QueryFilter;
import kd.occ.ocepfp.core.form.plugin.AbstractExtListViewPlugin;
import kd.occ.ocepfp.core.form.util.ListSelectionEventUtil;
import kd.occ.ocepfp.core.form.util.QueryUtil;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.base.ListFormData;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.servicehelper.ExtFormServiceHelper;
import org.dom4j.DocumentException;

public class ExtListViewPlugin
extends AbstractExtListViewPlugin {
    @Override
    public final void initialize(ClientEvent clientEvent) {
        ListFormData listFormData = new ListFormData(((ExtListView)this.view).getViewId(), (ExtDynamicView)this.view, this);
        if (listFormData.isNeedCache()) {
            DynamicObject cacheDataObject = null;
            if (!clientEvent.isLoadDataEvent()) {
                cacheDataObject = listFormData.getCacheAll();
            }
            if (cacheDataObject != null) {
                listFormData.setDataObject(cacheDataObject);
            }
        }
        this.setBillData(listFormData);
    }

    @Override
    protected final void loadData(LoadDataEvent event) {
        this.loadData(event, true);
    }

    protected final void loadData(LoadDataEvent event, boolean clearCache) {
        ((ListFormData)this.billData).beginInit();
        if (clearCache) {
            PageRowCacheUtils.clearPageRowcache((String)this.getCachePageId(), (String)"occ_billlist");
        }
        PageRowCacheUtils.setPageId((String)this.getCachePageId());
        PageRowCacheUtils.setControlKey((String)"occ_billlist");
        this.buildListDataSet(event);
        ((ListFormData)this.billData).endInit();
        if (event.isPreventDefault()) {
            return;
        }
        ListFormData listFormData = (ListFormData)this.getBillData();
        ListDataSet<DynamicObjectCollection> listDataSet = new ListDataSet<DynamicObjectCollection>(event.getPage(), listFormData.getDynamicObjectCollection(), listFormData.getRecordCount(), event.getPageSize());
        ((ExtListView)this.getView()).bindData(listDataSet);
    }

    @Override
    protected final void afterDoEvent(ClientEvent clientEvent) {
        super.afterDoEvent(clientEvent);
        ((ListFormData)this.getBillData()).saveAll2Cache();
    }

    private void buildListDataSet(LoadDataEvent event) {
        ListFormData listFormData = (ListFormData)this.getBillData();
        listFormData.initDynamicObject();
        ListDataSet<Object> listDataSet = new ListDataSet();
        DataGrid dataGrid = ((ExtListView)this.getView()).getPageView().getPageBody().getControl(((ExtListView)this.getView()).getMainDataGridId(), DataGrid.class);
        QueryFilter queryFilter = this.buildQueryFilter(event.getQueryFilter(), event);
        listDataSet = this.loadDataSet(dataGrid, event, queryFilter);
        listFormData.setPageInfo(listDataSet.getPage(), listDataSet.getRecordCount(), listDataSet.getTotalPage());
        if (listDataSet.getRows() != null) {
            listFormData.getDynamicObjectCollection().addAll((Collection)((DynamicObjectCollection)listDataSet.getRows()));
        }
        this.beforeBindData(event);
    }

    private ListDataSet<?> loadDataSet(DataGrid dataGrid, LoadDataEvent event, QueryFilter queryFilter) {
        ListDataSet<?> listDataSet = this.onDataLoad(event);
        return listDataSet;
    }

    @Override
    public ListDataSet<?> onDataLoad(LoadDataEvent event) {
        MainMetadata metadata = MetadataFactory.getMetadata(((ExtListView)this.getView()).getExtCtx(), ((ExtListView)this.getView()).getViewId());
        if (metadata == null || StringUtil.isNull((String)metadata.getBaseMetadataId())) {
            return new ListDataSet();
        }
        return ExtFormServiceHelper.loadList(((ExtListView)this.getView()).getExtCtx(), ((ExtListView)this.getView()).getViewId(), event.getQueryFilter(), event.getPage(), event.getPageSize());
    }

    @Override
    protected void onGetRecordCount(LoadDataEvent event) {
        QueryFilter queryFilter = this.buildQueryFilter(event.getQueryFilter(), event);
        int recordCount = this.getRecordCount(event);
        ((ExtListView)this.view).updateRecordCount(recordCount);
    }

    @Override
    protected int getRecordCount(LoadDataEvent event) {
        int recordCount = 0;
        if (!BillDataType.Custom.toString().equalsIgnoreCase(((ExtListView)this.getView()).getPageView().getBillDataType())) {
            recordCount = ExtFormServiceHelper.getRecordCount(((ExtListView)this.getView()).getExtCtx(), ((ExtListView)this.getView()).getViewId(), event.getQueryFilter());
        }
        return recordCount;
    }

    protected void onPage(LoadDataEvent event) {
        this.loadData(event, false);
    }

    @Override
    protected void onRowDoubleClick(SelectionEvent event) {
        SelectedRow currentRow;
        if (!event.isPreventDefault() && (currentRow = event.getCurrentRow()) != null) {
            this.showBillView(currentRow.getPkValue());
        }
        super.onRowDoubleClick(event);
    }

    private void showBillView(Object pkValue) {
        String viewId = ((ExtListView)this.getView()).getViewOrmId();
        OpenParam openParam = new OpenParam();
        openParam.setViewId(viewId);
        openParam.setPkValue(pkValue);
        openParam.setTarget(OpenParam.OpenTarget.MainTab);
        MainMetadata mainMetadata = MetadataFactory.getMetadata(((ExtListView)this.getView()).getExtCtx(), viewId);
        if (mainMetadata != null) {
            openParam.setTitle(mainMetadata.getName() + "-\u7f16\u8f91");
            ((ExtListView)this.getView()).showView(openParam);
            return;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)((ExtListView)this.getView()).getViewOrmId().toLowerCase());
        if (mainEntityType != null) {
            openParam.setTitle(mainEntityType.getName() + "-\u7f16\u8f91");
            ((ExtListView)this.getView()).showCloudBillView(openParam);
            return;
        }
        ((ExtListView)this.getView()).showView(openParam);
    }

    @Override
    protected final void doEvent(ClientEvent clientEvent) {
        super.doEvent(clientEvent);
        switch (clientEvent.getType().toLowerCase(Locale.ENGLISH)) {
            case "onpage": {
                this.onPage((LoadDataEvent)clientEvent);
            }
        }
    }

    @Override
    protected final void tryToolbarClick(ToolbarClickEvent event) {
        super.tryToolbarClick(event);
        if (!event.isPreventDefault()) {
            boolean isRefresh;
            String id = event.getId();
            Control menuButton = (Control)((ExtListView)this.getView()).getPageView().getPageBody().getControl(id);
            String iservice = menuButton.getIService();
            if (menuButton == null || StringUtil.isNull((String)iservice)) {
                return;
            }
            boolean bl = isRefresh = iservice.equals("delete") || iservice.equals("submit") || iservice.equals("unsubmit") || iservice.equals("audit") || iservice.equals("unaudit") || menuButton.getBoolean("refresh", false) != false;
            if (isRefresh && event.getOperationResult().getSuccessPkIds().size() > 0) {
                ((ExtListView)this.view).refresh();
            }
        }
    }

    @Override
    protected final void validateSelectionRow(SelectionEvent selectionClientEvent) {
        ListSelectionEventUtil.validateSelectionRow(selectionClientEvent, (AbstractFormData)this.getBillData());
        ((ListFormData)this.getBillData()).initSelectionRowInfo(selectionClientEvent.getCurrentRow(), selectionClientEvent.getSelections());
    }

    @Override
    public final void tryOnDataChange(DataChangeEvent event) {
        Control control = (Control)((ExtListView)this.view).getPageView().getPageBody().getControl(event.getId());
        Object oldValue = null;
        if (!control.isFilterField()) {
            oldValue = StringUtil.isNotNull((String)control.getSrcDataGrid()) ? ((ListFormData)this.getBillData()).getEntryRowData(control.getSrcDataGrid(), event.getRow(), event.getId()) : ((ListFormData)this.getBillData()).get(event.getId());
        }
        if (control.isInGroupFooter()) {
            String srcId = control.getSrcDataGrid();
            List groupUpdateList = (List)event.getBillData().get((Object)srcId);
            for (Map groupUpdate : groupUpdateList) {
                ((ListFormData)this.getBillData()).updateValue(event.getId(), (Integer)groupUpdate.get("row"), event.getValue());
            }
        }
        ((ListFormData)this.getBillData()).updateValue(event.getId(), event.getRow(), event.getValue());
        this.onDataChange(event);
        if (event.isPreventDefault()) {
            ((ListFormData)this.getBillData()).updateValue(event.getId(), event.getRow(), oldValue);
            return;
        }
    }

    @Override
    protected final DynamicObject[] getCurrentRowData(SelectionEvent selectionEvent) {
        Control control = (Control)((ExtListView)this.view).getControl(selectionEvent.getId());
        String fieldKeyStr = null;
        if (control != null && StringUtil.isNotNull((String)control.getIService())) {
            Operation operation = null;
            if (StringUtil.isNotNull((String)((ExtListView)this.view).getPageView().getBaseViewId())) {
                try {
                    PageView baseView = PageViewBuilder.getPageView(((ExtListView)this.view).getExtCtx(), ((ExtListView)this.view).getPageView().getBaseViewId());
                    operation = baseView.getOperatios().get(control.getIService());
                }
                catch (IllegalAccessException | InstantiationException | DocumentException baseView) {}
            } else {
                operation = ((ExtListView)this.view).getPageView().getOperatios().get(control.getIService());
            }
            if (operation != null) {
                String fieldid;
                List<Plugin> plugins = operation.getPlugins();
                if (plugins != null) {
                    PreparePropertysEventArgs args = new PreparePropertysEventArgs();
                    ArrayList fieldKeys = new ArrayList();
                    args.setFieldKeys(fieldKeys);
                    for (Plugin plugin : plugins) {
                        AbstractOperationServicePlugIn servicePlugin = (AbstractOperationServicePlugIn)Convert.toInstance((String)plugin.getClassName());
                        if (servicePlugin == null) continue;
                        servicePlugin.onPreparePropertys(args);
                    }
                    fieldKeyStr = String.join((CharSequence)",", fieldKeys);
                }
                if (StringUtil.isNotNull((String)(fieldid = operation.getParamter().getString("fieldid")))) {
                    Control objControl;
                    PageView basePageView = ViewFactory.get(((ExtListView)this.view).getExtCtx(), ((ExtListView)this.view).getPageView().getBaseViewId());
                    Control control2 = objControl = basePageView != null ? (Control)basePageView.getPageBody().getControl(fieldid) : null;
                    if (objControl != null && objControl.getType().equals("BillStatus")) {
                        String fieldValue = operation.getParamter().getString("value");
                        Option option = ((BillStatus)objControl).getOptionByValue(fieldValue);
                        String operationKey = option.getOperationerKey();
                        String operationDateKey = option.getOperationDateKey();
                        if (fieldKeyStr != null) {
                            fieldKeyStr = this.addKey(fieldKeyStr, operationKey);
                            fieldKeyStr = this.addKey(fieldKeyStr, operationDateKey);
                        }
                    }
                }
            }
        }
        MainMetadata metadata = MetadataFactory.getMetadata(((ExtListView)this.view).getExtCtx(), ((ExtListView)this.view).getViewId());
        DynamicObject[] selectRowData = ((ListFormData)this.getBillData()).getSelectedRowDatas(QueryUtil.getSelectFieldStr(((ExtListView)this.view).getExtCtx(), metadata, fieldKeyStr));
        if (((ExtListView)this.view).isCustomDataType()) {
            DynamicObject data = ((ListFormData)this.billData).createNewBillData();
            for (DynamicObject rowData : selectRowData) {
                data.getDynamicObjectCollection(((ExtListView)this.view).getMainDataGridId()).add((Object)rowData);
            }
            return new DynamicObject[]{data};
        }
        return selectRowData;
    }

    private String addKey(String allKey, String key) {
        if (StringUtil.isNotNull((String)key) && allKey.indexOf(key) < 0) {
            allKey = allKey + "," + key;
        }
        return allKey;
    }

    @Override
    public void onSearch(SearchEvent event) {
        this.loadData(event);
    }

    @Override
    protected final void tryOnClick(ClickEvent event) {
        Control control;
        super.tryOnClick(event);
        if (!event.isPreventDefault() && (control = (Control)((ExtListView)this.view).getPageView().getPageBody().getControl(event.getId())).getType().equals("Code")) {
            this.showBillView(event.getCurrentRow().getPkValue());
        }
    }
}

