/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.plugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.constant.PortalCardType;
import kd.occ.ocepfp.common.entity.LoadCardRequest;
import kd.occ.ocepfp.common.entity.LoginContext;
import kd.occ.ocepfp.common.entity.MainPortal;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.controls.Card;
import kd.occ.ocepfp.core.form.control.controls.Portal;
import kd.occ.ocepfp.core.form.event.ClickEvent;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.InitViewEvent;
import kd.occ.ocepfp.core.form.event.LoadCardDataEvent;
import kd.occ.ocepfp.core.form.plugin.ExtBillViewPlugin;
import kd.occ.ocepfp.core.form.view.base.BillFormData;
import kd.occ.ocepfp.core.form.view.base.ExtBillView;
import kd.occ.ocepfp.core.service.portal.ExtPortalServiceHelper;

public class ExtPortalViewPlugin
extends ExtBillViewPlugin {
    @Override
    public boolean initView(InitViewEvent initViewEvent) {
        this.initCard();
        return false;
    }

    private void initCard() {
        Portal portal = (Portal)((ExtBillView)this.view).getControl("portal");
        MainPortal mainPortal = ExtPortalServiceHelper.getMainPortal(((ExtBillView)this.getView()).getExtCtx());
        List<Card> cardList = ExtPortalServiceHelper.buildPortalCardList(((ExtBillView)this.getView()).getExtCtx(), mainPortal.getPortalId());
        if (cardList != null) {
            for (Card card : cardList) {
                portal.addChild(card);
            }
        }
    }

    @Override
    protected final void doEvent(ClientEvent clientEvent) {
        switch (clientEvent.getType().toLowerCase(Locale.ENGLISH)) {
            case "loadcarddata": {
                this.loadCardData((LoadCardDataEvent)clientEvent);
                if (((BillFormData)this.getBillData()).getDataObject() != null) break;
                ((BillFormData)this.getBillData()).initDynamicObject();
                ((BillFormData)this.getBillData()).getFormModifiedManager().setHeadModified();
            }
        }
        super.doEvent(clientEvent);
    }

    protected final void loadCardData(LoadCardDataEvent loadCardDataEvent) {
        this.beforeLoadCardData(loadCardDataEvent);
        if (!loadCardDataEvent.isPreventDefault()) {
            this.doLoadCardData(loadCardDataEvent);
        }
        this.afterLoadCardData(loadCardDataEvent);
    }

    private final void doLoadCardData(LoadCardDataEvent loadCardDataEvent) {
        MainPortal mainPortal = ExtPortalServiceHelper.getMainPortal(((ExtBillView)this.getView()).getExtCtx());
        List<Card> cardList = ExtPortalServiceHelper.buildPortalCardList(((ExtBillView)this.getView()).getExtCtx(), mainPortal.getPortalId());
        Card card = cardList.stream().filter(r -> r.getId().equals(loadCardDataEvent.getId())).findFirst().get();
        if (card != null) {
            LoadCardRequest loadCardParam = new LoadCardRequest();
            loadCardParam.setPortalId(mainPortal.getPortalId());
            PortalCardType portalCardType = PortalCardType.valueOf((String)card.getCardType());
            loadCardParam.setCardType(portalCardType.getValue());
            loadCardParam.setCardData(card.getCardData());
            Object data = ExtPortalServiceHelper.getCardData(((ExtBillView)this.getView()).getExtCtx(), loadCardParam);
            ((ExtBillView)this.getView()).updateFrontValue(loadCardDataEvent.getId(), data);
        }
    }

    @Override
    protected void onClick(ClickEvent event) {
        Map<String, String> data;
        String eventId;
        switch (eventId = event.getId()) {
            case "1330437133042723840": {
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocepfp_rebateaccountlist");
                openParam.addCustomParam("accounttype", "A");
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                ((ExtBillView)this.view).showView(openParam);
                return;
            }
            case "1330505011503014912": {
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocepfp_rebateaccountlist");
                openParam.addCustomParam("accounttype", "C");
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                ((ExtBillView)this.view).showView(openParam);
                return;
            }
            case "1330505011503014913": {
                OpenParam openParam = new OpenParam();
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                openParam.setTitle("\u9884\u7b97\u4f59\u989d\u8868");
                openParam.setViewId("ocepfp_marketbalancelist");
                ((ExtBillView)this.getView()).showView(openParam);
                return;
            }
            case "1330505011503014914": {
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocepfp_rebateaccountlist");
                openParam.addCustomParam("accounttype", "1");
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                ((ExtBillView)this.view).showView(openParam);
                return;
            }
            case "955577536442777604": {
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocepfp_chnlannouncelist");
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                ((ExtBillView)this.view).showView(openParam);
                return;
            }
        }
        String platformIdStr = LoginContext.get().getCommon("portalid");
        DynamicObject portalCfg = ExtPortalServiceHelper.getPortalCardCfg(((ExtBillView)this.view).getExtCtx(), Long.parseLong(platformIdStr));
        List<Object> accountIds = new ArrayList();
        if (portalCfg != null) {
            long requestId = Long.parseLong(event.getId());
            DynamicObjectCollection accountEntryList = portalCfg.getDynamicObjectCollection("accountentry");
            List accountEntry = accountEntryList.stream().filter(f -> f.getLong("id") == requestId).collect(Collectors.toList());
            if (accountEntry != null && accountEntry.size() > 0) {
                accountIds = ((DynamicObject)accountEntry.get(0)).getDynamicObjectCollection("relateaccounts").stream().map(r -> r.getLong("fbasedataid_id")).collect(Collectors.toList());
                OpenParam openParam = new OpenParam();
                openParam.setViewId("ocepfp_rebateaccountlist");
                openParam.addCustomParam("accounttypeid", StringUtil.join((Object[])accountIds.toArray(), (String)","));
                openParam.setTarget(OpenParam.OpenTarget.MainTab);
                ((ExtBillView)this.view).showView(openParam);
                return;
            }
        }
        if ((data = ExtPortalServiceHelper.getPortalUseCardCfgdl(((ExtBillView)this.view).getExtCtx(), Long.parseLong(event.getId()))) != null && data.size() > 0) {
            String targetViewId;
            String skipform = data.get("skipform");
            String string = targetViewId = StringUtil.isNotNull((String)skipform) ? skipform : null;
            if (targetViewId == null) {
                return;
            }
            OpenParam openParam = new OpenParam();
            openParam.setViewId(targetViewId);
            openParam.setTarget(OpenParam.OpenTarget.MainTab);
            ((ExtBillView)this.view).showView(openParam);
            return;
        }
        OpenParam openParam = new OpenParam();
        openParam.setViewId("ocepfp_chnlannounce");
        openParam.setTarget(OpenParam.OpenTarget.MainTab);
        openParam.addCustomParam("id", eventId);
        ((ExtBillView)this.view).showView(openParam);
    }

    protected final void beforeLoadCardData(LoadCardDataEvent loadCardDataEvent) {
    }

    protected final void afterLoadCardData(LoadCardDataEvent loadCardDataEvent) {
    }
}

