/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.plugin.formatter;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.UniqueRowUtil;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Price;
import kd.occ.ocepfp.core.form.control.controls.Qty;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.Metadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocepfp.core.service.auxpty.AuxptyHelper;

public class ExtBillFormDataFormatter {
    private ExtDynamicView<?> view;
    private DynamicObject dynamicObject;
    private Metadata metadata;
    private ExtDynamicObject head = new ExtDynamicObject();

    public static final ExtBillFormDataFormatter newInstance(ExtDynamicView<?> view, DynamicObject dynamicObject) {
        ExtBillFormDataFormatter formDataConverter = new ExtBillFormDataFormatter();
        formDataConverter.dynamicObject = dynamicObject;
        formDataConverter.view = view;
        formDataConverter.metadata = MetadataFactory.getMetadata(view.getExtCtx());
        return formDataConverter;
    }

    public final ExtDynamicObject convert() {
        this.convertHead();
        this.convertEntry();
        return this.head;
    }

    private final void convertHead() {
        this.head.putAll((Map)this.convertFields(this.metadata.getFieldList(), this.dynamicObject));
    }

    private final void convertEntry() {
        List<Entry> entries = this.metadata.getEntries();
        if (entries != null && entries.size() > 0) {
            for (Entry entry : entries) {
                this.head.put(entry.getId(), this.convertEntry(entry, this.dynamicObject.getDynamicObjectCollection(entry.getId())));
            }
        }
    }

    public final List<ExtDynamicObject> convertSubEntry(String subEntryId, int parentRow) {
        subEntryId = subEntryId.toLowerCase(Locale.ENGLISH);
        List<Entry> entries = this.metadata.getEntries();
        if (entries != null && entries.size() > 0) {
            for (Entry entry : entries) {
                DynamicObjectCollection collection;
                if (entry.getSubEntry() == null || !entry.getSubEntry().getId().equals(subEntryId) || (collection = this.dynamicObject.getDynamicObjectCollection(entry.getId())).size() <= parentRow) continue;
                return this.convertEntry(entry.getSubEntry(), ((DynamicObject)collection.get(parentRow)).getDynamicObjectCollection(subEntryId));
            }
        }
        return null;
    }

    public final List<ExtDynamicObject> convertEntry(String entryId, DynamicObjectCollection dynamicObjectCollection) {
        Entry entry = this.metadata.getEntry(entryId);
        return this.convertEntry(entry, dynamicObjectCollection);
    }

    public final List<ExtDynamicObject> convertEntry(Entry entry, DynamicObjectCollection dynamicObjectCollection) {
        ArrayList<ExtDynamicObject> dataList = new ArrayList<ExtDynamicObject>();
        if (dynamicObjectCollection != null && dynamicObjectCollection.size() > 0) {
            int dataSize = dynamicObjectCollection.size();
            for (int i = 0; i < dataSize; ++i) {
                dataList.add(this.convertEntryFields(entry, (DynamicObject)dynamicObjectCollection.get(i), i));
            }
        }
        return dataList;
    }

    public final ExtDynamicObject convertEntry(String entryId, DynamicObject dynamicObject, int index) {
        Entry entry = this.metadata.getEntry(entryId);
        return this.convertEntryFields(entry, dynamicObject, index);
    }

    private final ExtDynamicObject convertEntryFields(Entry entry, DynamicObject dynamicObject, int index) {
        ExtDynamicObject entryDynamicObject = this.convertFields(entry.getFieldList(), dynamicObject);
        entryDynamicObject.put("seq", (Object)dynamicObject.getInt("seq"));
        entryDynamicObject.put(UniqueRowUtil.getPropertyName((String)entry.getId()), (Object)Integer.toString(index));
        dynamicObject.set(UniqueRowUtil.getPropertyName((String)entry.getId()), (Object)Integer.toString(index));
        return entryDynamicObject;
    }

    private final ExtDynamicObject convertFields(List<Field> fields, DynamicObject dynamicObject) {
        ExtDynamicObject dataObject = null;
        PageBody pageBody = this.view.getPageView().getPageBody();
        if (fields != null && fields.size() > 0) {
            dataObject = new ExtDynamicObject();
            Control control = null;
            String displayField = "";
            String fieldId = null;
            if (dynamicObject == null) {
                return dataObject;
            }
            for (Field field : fields) {
                fieldId = field.getId();
                if (StringUtil.isNull((String)fieldId)) continue;
                control = (Control)pageBody.getControl(fieldId);
                if (control != null) {
                    if ("ImgGroup".equalsIgnoreCase(control.getType())) {
                        dataObject.put(fieldId, JsonUtil.readValue((String)dynamicObject.getString(fieldId), List.class));
                        continue;
                    }
                    if (control.isF7()) {
                        if (((SelectData)control).isEnableInput() && dynamicObject.get(fieldId) == null && control.getRelatedControls() != null) {
                            String relatedControl;
                            String[] relatedControls = control.getRelatedControls().split(",");
                            String string = relatedControl = relatedControls != null ? relatedControls[0] : "";
                            if (relatedControl != null) {
                                ExtDynamicObject enabelMapData = new ExtDynamicObject();
                                enabelMapData.put("_display", (Object)dynamicObject.getString(relatedControl));
                                dataObject.put(fieldId, (Object)enabelMapData);
                                continue;
                            }
                        }
                        displayField = StringUtil.isNotNull((String)(displayField = ((SelectData)control).getDisplayField())) ? displayField : "name";
                        dataObject.put(fieldId, (Object)this.buildF7Data((DynamicObject)dynamicObject.get(fieldId), (SelectData)control, displayField));
                        continue;
                    }
                    if (StringUtil.isNotNull((String)control.getLinkORM())) {
                        dataObject.put(fieldId, this.buildLinkOrm(dataObject, dynamicObject, control));
                        continue;
                    }
                    if ("AdminDivision".equalsIgnoreCase(control.getType())) {
                        long divisionId = Convert.toLong((Object)dynamicObject.get(fieldId));
                        dataObject.put(fieldId, AdminDivisionHelper.getDivisionNameMap(divisionId));
                        continue;
                    }
                    if ("Qty".equalsIgnoreCase(control.getType())) {
                        int precision = 2;
                        String precisionaccount = "1";
                        if (StringUtil.isNotNull((String)((Qty)control).getUnit())) {
                            DynamicObject unitDataObject = dynamicObject.getDynamicObject(((Qty)control).getUnit());
                            if (unitDataObject != null) {
                                precision = unitDataObject.getInt("precision");
                                precisionaccount = unitDataObject.getString("precisionaccount");
                            }
                        } else if (StringUtil.isNotNull((String)((Qty)control).getPrecision())) {
                            precision = Integer.parseInt(((Qty)control).getPrecision());
                        }
                        dataObject.put(fieldId, (Object)BigDecimalUtil.setScale((BigDecimal)dynamicObject.getBigDecimal(fieldId), (int)precision, (String)precisionaccount).toString());
                        continue;
                    }
                    if ("Amount".equals(control.getType()) || "Price".equals(control.getType())) {
                        DynamicObject currencyDataObject;
                        String currency = ((Price)control).getCurrency();
                        int precision = 2;
                        if (StringUtil.isNotNull((String)currency) && (currencyDataObject = this.dynamicObject.getDynamicObject(currency)) != null) {
                            precision = "Amount".equalsIgnoreCase(field.getFieldType()) ? currencyDataObject.getInt("amtprecision") : currencyDataObject.getInt("priceprecision");
                            dataObject.put("_cs", (Object)currencyDataObject.getString("sign"));
                        }
                        dataObject.put(fieldId, (Object)BigDecimalUtil.setScale((BigDecimal)dynamicObject.getBigDecimal(fieldId), (int)precision, (RoundingMode)RoundingMode.HALF_DOWN).toString());
                        continue;
                    }
                    if ("Sku".equals(control.getType()) && dynamicObject.get(fieldId) != null) {
                        long auxptyId = dynamicObject.getDynamicObject(fieldId).getLong("id");
                        dataObject.put(fieldId, (Object)AuxptyHelper.getAuxptyName(auxptyId));
                        continue;
                    }
                }
                dataObject.put(fieldId, fieldId.equalsIgnoreCase("id") ? Convert.toString((Object)dynamicObject.get(fieldId)) : dynamicObject.get(fieldId));
            }
        }
        return dataObject;
    }

    private final ExtDynamicObject buildF7Data(DynamicObject f7DynamicObject, SelectData selectData, String displayField) {
        ExtDynamicObject f7data = null;
        if (f7DynamicObject != null && selectData != null) {
            String[] relatedOrms = StringUtil.isNotNull((String)selectData.getRelatedOrm()) ? selectData.getRelatedOrm().split(",") : null;
            f7data = new ExtDynamicObject();
            String billnoField = selectData.getBillnoField(this.view.getExtCtx());
            if (StringUtil.isNotNull((String)billnoField)) {
                f7data.put(billnoField, f7DynamicObject.get(billnoField));
            }
            f7data.put("_display", this.toData(f7DynamicObject.get(displayField)));
            f7data.put("id", (Object)Convert.toString((Object)f7DynamicObject.get("id")));
            if (relatedOrms != null && relatedOrms.length > 0) {
                for (String orm : relatedOrms) {
                    f7data.put(orm, this.toData(f7DynamicObject.get(orm)));
                }
            }
            if (selectData.getType().equals("Currency")) {
                f7data.put("pp", (Object)f7DynamicObject.getInt("priceprecision"));
                f7data.put("ap", (Object)f7DynamicObject.getInt("amtprecision"));
                f7data.put("sl", (Object)f7DynamicObject.getString("sign"));
            } else if (selectData.getType().equals("Unit")) {
                f7data.put("pp", (Object)f7DynamicObject.getInt("precision"));
                f7data.put("pa", (Object)f7DynamicObject.getInt("precisionaccount"));
            }
        }
        return f7data;
    }

    private final Object buildLinkOrm(ExtDynamicObject destDataObject, DynamicObject sourceDataObject, Control control) {
        if (sourceDataObject != null) {
            String[] orms = control.getLinkORM().split("\\.");
            Object data = sourceDataObject;
            for (String orm : orms) {
                if (data == null) break;
                data = data.get(orm);
            }
            return this.toData(data);
        }
        return null;
    }

    private final Object toData(Object object) {
        Object value = object;
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value == null ? "" : value;
    }
}

