/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.plugin.formatter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.controls.Qty;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.control.controls.Unit;
import kd.occ.ocepfp.core.form.event.ListDataSet;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.PageViewBuilder;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import org.dom4j.DocumentException;

public class ExtListFormDataFormatter {
    public static Object formatListData(ExtListView view, ListDataSet<?> listDataSet) {
        return ExtListFormDataFormatter.formatListData(view.getExtCtx(), view.getPageView(), listDataSet);
    }

    public static Object formatListData(ExtWebContext webCtx, PageView view, ListDataSet<?> listDataSet) {
        return ExtListFormDataFormatter.formatListData(webCtx, view, listDataSet, true);
    }

    public static Object formatListData(ExtWebContext webCtx, PageView view, ListDataSet<?> listDataSet, boolean userMultiLanguage) {
        Object dataList = listDataSet.getRows();
        List datas = (List)dataList;
        if (datas == null || datas.size() == 0) {
            return new ListDataSet();
        }
        int i = 0;
        String mainDataGridId = view.getPageBody().getFirstDataGridId();
        if (dataList instanceof DynamicObjectCollection) {
            DynamicObjectCollection dataCollection = (DynamicObjectCollection)dataList;
            ArrayList<ExtDynamicObject> newDataList = new ArrayList<ExtDynamicObject>(dataCollection.size());
            Entry metadata = MetadataFactory.getMetadata(webCtx, view.getViewId()).getEntry(mainDataGridId);
            MainMetadata baseMetadata = MetadataFactory.getMetadata(webCtx, view.getBaseViewId());
            PageView basePageView = null;
            try {
                basePageView = PageViewBuilder.getPageView(webCtx, view.getBaseViewId());
            }
            catch (IllegalAccessException | InstantiationException | DocumentException e1) {
                e1.printStackTrace();
            }
            basePageView = basePageView == null ? view : basePageView;
            List<Field> fields = metadata.getFieldList();
            String langKey = RequestContext.get().getLang().getLocale().toString();
            boolean isLoadByControlId = false;
            i = 0;
            for (DynamicObject data : dataCollection) {
                ExtDynamicObject newData = new ExtDynamicObject();
                for (Field field : fields) {
                    Object cellValue;
                    isLoadByControlId = StringUtil.isNull((String)field.getOrm());
                    String queryKey = isLoadByControlId ? field.getId() : field.getOrm();
                    try {
                        String[] fieldKey = queryKey.split("\\.");
                        if (!isLoadByControlId && fieldKey.length == 3) {
                            queryKey = fieldKey[0] + "." + fieldKey[1];
                            String prop = fieldKey[2];
                            cellValue = data.getDynamicObject(queryKey).get(prop);
                        } else {
                            cellValue = data.get(queryKey);
                        }
                    }
                    catch (Exception e) {
                        LogUtil.info(ExtListFormDataFormatter.class, (Throwable)e);
                        cellValue = null;
                    }
                    if (field != null) {
                        if (field.isF7()) {
                            DynamicObject baseData = data.getDynamicObject(queryKey);
                            if (baseData != null) {
                                SelectData selectData = (SelectData)view.getPageBody().getControl(field.getId());
                                ExtDynamicObject basedata = new ExtDynamicObject();
                                basedata.put("name", (Object)data.getDynamicObject(queryKey).getString("name"));
                                basedata.put("_display", ExtListFormDataFormatter.toData(data.getDynamicObject(queryKey).get(StringUtil.isNotNull((String)selectData.getDisplayField()) ? selectData.getDisplayField() : "name")));
                                basedata.put("id", (Object)Convert.toString((Object)data.get("id")));
                                cellValue = basedata;
                            }
                        } else if ("MultiLanguageText".equalsIgnoreCase(field.getFieldType())) {
                            if (cellValue instanceof ILocaleString) {
                                cellValue = ((ILocaleString)cellValue).getLocaleValue();
                            }
                            if (userMultiLanguage) {
                                ExtDynamicObject mulData = new ExtDynamicObject(2);
                                mulData.put(langKey, cellValue);
                                cellValue = mulData;
                            }
                        } else if (cellValue != null && ("Price".equalsIgnoreCase(field.getFieldType()) || "Amount".equalsIgnoreCase(field.getFieldType()))) {
                            Field baseField = baseMetadata != null ? baseMetadata.getField(field.getId()) : null;
                            int precision = 2;
                            if (baseField != null && baseField.getCurrency() != null && StringUtil.isNotNull((String)baseField.getCurrency())) {
                                DynamicObject currency = data.getDynamicObject(baseField.getCurrency());
                                precision = currency == null ? 2 : ("Amount".equalsIgnoreCase(field.getFieldType()) ? currency.getInt("amtprecision") : currency.getInt("priceprecision"));
                                newData.put("_cs", (Object)(currency != null ? currency.getString("sign") : ""));
                            }
                            cellValue = ((BigDecimal)cellValue).setScale(precision, 4).toString();
                        } else if (cellValue != null && "Qty".equalsIgnoreCase(field.getFieldType())) {
                            Qty qty = (Qty)basePageView.getPageBody().getControl(field.getId());
                            int precision = 2;
                            String precisionaccount = "1";
                            if (qty != null && StringUtil.isNotNull((String)qty.getUnit())) {
                                Unit unitControl = (Unit)basePageView.getPageBody().getControl(qty.getUnit());
                                DynamicObject unitDynamicObject = data.getDynamicObject(data.getDynamicObjectType().getProperties().containsKey((Object)(unitControl.getSrcDataGrid() + "." + unitControl.getId())) ? unitControl.getSrcDataGrid() + "." + unitControl.getId() : unitControl.getId());
                                if (unitDynamicObject != null) {
                                    precision = unitDynamicObject.getInt("precision");
                                    precisionaccount = unitDynamicObject.getString("precisionaccount");
                                }
                            } else if (qty != null && StringUtil.isNotNull((String)qty.getPrecision())) {
                                precision = Integer.parseInt(qty.getPrecision());
                            }
                            cellValue = BigDecimalUtil.setScale((BigDecimal)((BigDecimal)cellValue), (int)precision, (String)precisionaccount).toString();
                        } else if ("Input".equalsIgnoreCase(field.getFieldType()) && cellValue instanceof OrmLocaleValue) {
                            cellValue = ((OrmLocaleValue)cellValue).getLocaleValue();
                        }
                    }
                    newData.put(field.getId(), cellValue == null ? "" : cellValue);
                }
                newData.put("id", (Object)Convert.toString((Object)data.get("id")));
                newDataList.add(newData);
            }
            ListDataSet<ArrayList<ExtDynamicObject>> newDataSet = new ListDataSet<ArrayList<ExtDynamicObject>>();
            newDataSet.setRecords(listDataSet.getRecordCount(), listDataSet.getPageSize());
            newDataSet.setPage(listDataSet.getPage());
            newDataSet.setRows(newDataList);
            return newDataSet;
        }
        for (Object data : datas) {
            ((Map)data).put(mainDataGridId + "_uqrow", i++);
        }
        return listDataSet;
    }

    private static final Object toData(Object object) {
        Object value = object;
        if (value instanceof OrmLocaleValue) {
            value = ((OrmLocaleValue)value).getLocaleValue();
        }
        return value == null ? "" : value;
    }
}

