/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowUtil;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.ListSelectPkField;
import kd.occ.ocepfp.common.entity.RowData;
import kd.occ.ocepfp.common.util.PageSizeUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.Metadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;

public class QueryUtil {
    public static String getSelectFieldStr(ExtWebContext extCtx, MainMetadata metadata) {
        return QueryUtil.getSelectFieldStr(extCtx, metadata, null);
    }

    public static String getSelectFieldStr(ExtWebContext extCtx, MainMetadata metadata, String appendSelectFields) {
        Map<String, Metadata.OrmMapKv> allOrms = metadata.getOrmMapIdKeys();
        StringBuffer selectIds = new StringBuffer();
        QueryUtil.getSelectPkFields(extCtx, metadata, selectIds);
        for (Map.Entry<String, Metadata.OrmMapKv> ormKeys : allOrms.entrySet()) {
            selectIds.append(",").append(ormKeys.getKey());
            if (!StringUtil.isNotNull((String)ormKeys.getValue().getDisplayOrm())) continue;
            selectIds.append(",").append(ormKeys.getValue().getDisplayOrm());
        }
        if (StringUtil.isNotNull((String)appendSelectFields)) {
            selectIds.append(",").append(appendSelectFields);
        }
        return selectIds.toString();
    }

    public static String getSelectPkFieldStr(ExtWebContext extCtx, MainMetadata metadata) {
        StringBuffer ids = new StringBuffer();
        QueryUtil.getSelectPkFields(extCtx, metadata, ids);
        return ids.toString();
    }

    private static void getSelectPkFields(ExtWebContext extCtx, MainMetadata metadata, StringBuffer ids) {
        List<ListSelectPkField> listSelectPkIds = QueryUtil.getSelectPkFieldList(extCtx, metadata);
        for (ListSelectPkField listSelectPkId : listSelectPkIds) {
            ids.append(listSelectPkId.getPkField()).append(",");
        }
        int idsLength = ids.length();
        if (idsLength > 0) {
            ids.deleteCharAt(ids.length() - 1);
        }
    }

    public static List<ListSelectPkField> getSelectPkFieldList(ExtWebContext extCtx, MainMetadata metadata) {
        Map<String, Metadata.OrmMapKv> allOrms = metadata.getOrmMapIdKeys();
        MainMetadata baseMetadata = MetadataFactory.getMetadata(extCtx, metadata.getBaseMetadataId());
        ArrayList<ListSelectPkField> selectSelectPkIds = new ArrayList<ListSelectPkField>(2);
        if (baseMetadata == null) {
            ListSelectPkField listSelectPkId = new ListSelectPkField();
            listSelectPkId.setMainQueryFilter(true);
            listSelectPkId.setPkField("id");
            listSelectPkId.setSortField(true);
            selectSelectPkIds.add(listSelectPkId);
            return selectSelectPkIds;
        }
        HashSet<String> existId = new HashSet<String>(4);
        String pkField = null;
        boolean isMainQueryFilter = true;
        ListSelectPkField listSelectPkId = null;
        int i = 0;
        int sort = -1;
        for (Map.Entry<String, Metadata.OrmMapKv> ormKeys : allOrms.entrySet()) {
            isMainQueryFilter = false;
            if (baseMetadata.isField(ormKeys.getKey())) {
                pkField = "id";
                isMainQueryFilter = true;
            } else {
                String[] fieldKeys = ormKeys.getKey().split("\\.");
                if (fieldKeys.length > 1) {
                    if (baseMetadata.isField(fieldKeys[0])) {
                        pkField = "id";
                        isMainQueryFilter = true;
                    } else if (baseMetadata.isEntry(fieldKeys[0])) {
                        pkField = fieldKeys[0];
                    }
                }
            }
            if (StringUtil.isNotNull((String)pkField) && !existId.contains(pkField)) {
                listSelectPkId = new ListSelectPkField();
                listSelectPkId.setMainQueryFilter(isMainQueryFilter);
                listSelectPkId.setPkField(pkField);
                selectSelectPkIds.add(listSelectPkId);
                String selectPkField = null;
                if (selectSelectPkIds != null && sort > 0 && selectSelectPkIds.size() > sort) {
                    selectPkField = ((ListSelectPkField)selectSelectPkIds.get(sort)).getPkField();
                }
                if (sort == -1 || selectPkField != null && pkField != null && selectPkField.split("\\.").length < pkField.split("\\.").length) {
                    sort = i;
                }
                ++i;
            }
            existId.add(pkField);
        }
        if (selectSelectPkIds != null && selectSelectPkIds.size() > sort && sort != -1) {
            ((ListSelectPkField)selectSelectPkIds.get(sort)).setSortField(true);
        }
        return selectSelectPkIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final RowData persistRowData(DataSet dataSet, int page, int pageSize) {
        RowData rowData = new RowData();
        int count = 0;
        int start = PageSizeUtil.getStart((int)page, (int)pageSize);
        ArrayList<Row> limitRows = new ArrayList<Row>(pageSize);
        ArrayList<Row> allRows = new ArrayList<Row>();
        try {
            for (Row row : dataSet) {
                Row trow = RowUtil.persist((Row)row);
                if (count >= start && count < start + pageSize) {
                    limitRows.add(trow);
                }
                allRows.add(trow);
                ++count;
            }
        }
        finally {
            dataSet.close();
        }
        rowData.setRowCount(count);
        rowData.setAllRows(allRows);
        rowData.setLimitRows(limitRows);
        return rowData;
    }
}

