/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.util;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class XMLTemplateUtil {
    private static ConcurrentMap<String, Document> _tempCache = new ConcurrentHashMap<String, Document>(100);

    public static String parse(String tempalte, Map<String, Object> data) throws DocumentException {
        StringBuffer properties = XMLTemplateUtil.parseProperties(tempalte, data);
        return properties.insert(0, "{").append("}").toString();
    }

    public static StringBuffer parseProperties(String tempalte, Map<String, Object> data) throws DocumentException {
        Document document = XMLTemplateUtil.loadTemplate(tempalte);
        Iterator iterator = document.selectNodes("/properties/property").iterator();
        Element element = null;
        StringBuffer str = new StringBuffer(100);
        boolean isNext = false;
        if (data.get("_commonproperties") != null) {
            str.append(data.get("_commonproperties"));
            isNext = true;
        }
        while (iterator.hasNext()) {
            element = (Element)iterator.next();
            String valueKey = element.attributeValue("value");
            String jsonKey = element.attributeValue("id");
            String valueType = element.attributeValue("valueType");
            Object value = XMLTemplateUtil.getValue(valueKey, data);
            String defaultValue = element.attributeValue("default");
            if (defaultValue != null && (value == null || "".equals(value.toString()))) {
                value = defaultValue;
            }
            if (value == null) continue;
            if (isNext) {
                str.append(",");
            }
            if (jsonKey.equalsIgnoreCase("subcontrol")) {
                value = value == null ? "" : value;
                str.append("\"children\":[").append(value).append("]");
            } else {
                str.append("\"").append(jsonKey).append("\":");
                if (StringUtil.isNull((String)valueType)) {
                    str.append("\"").append(value).append("\"");
                } else if ("boolean".equalsIgnoreCase(valueType) || "int".equalsIgnoreCase(valueType)) {
                    str.append(value);
                }
            }
            isNext = true;
        }
        return str;
    }

    private static Object getValue(String valueKey, Map<String, Object> data) {
        SimpleMap dataCopy = data;
        if (valueKey.indexOf("control.properties") >= 0) {
            dataCopy = ((Control)data.get("control")).getProperties();
            valueKey = valueKey.replaceAll("control.properties.", "");
        }
        return dataCopy.get(valueKey);
    }

    private static Document loadTemplate(String template) throws DocumentException {
        SAXReader sr = new SAXReader();
        Document document = null;
        String key = Integer.toString(template.hashCode());
        document = (Document)_tempCache.get(key);
        if (document == null) {
            document = sr.read(XMLTemplateUtil.class.getResource("/" + template));
            _tempCache.put(key, document);
        }
        return document;
    }
}

