/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.base;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.occ.ocepfp.common.constant.BillViewType;
import kd.occ.ocepfp.common.entity.Auxpty;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.FlexMeta;
import kd.occ.ocepfp.common.entity.IValueFormatter;
import kd.occ.ocepfp.common.entity.ImgObject;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.common.entity.UniqueRowUtil;
import kd.occ.ocepfp.common.util.BigDecimalUtil;
import kd.occ.ocepfp.common.util.Convert;
import kd.occ.ocepfp.common.util.DateUtil;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.LogUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.AdminDivision;
import kd.occ.ocepfp.core.form.control.controls.DataGrid;
import kd.occ.ocepfp.core.form.control.controls.Price;
import kd.occ.ocepfp.core.form.control.controls.Qty;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.event.ClientEvent;
import kd.occ.ocepfp.core.form.event.DataChangeEvent;
import kd.occ.ocepfp.core.form.formula.Formula;
import kd.occ.ocepfp.core.form.formula.exector.FormulaData;
import kd.occ.ocepfp.core.form.formula.exector.FormulaExector;
import kd.occ.ocepfp.core.form.formula.exector.FormulaFactory;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.plugin.formatter.ExtBillFormDataFormatter;
import kd.occ.ocepfp.core.form.view.base.AbstractCacheFormData;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.metadata.Entry;
import kd.occ.ocepfp.core.metadata.Field;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.orm.nextcloud.NextCloudEntityMetadataCache;
import kd.occ.ocepfp.core.service.admindivision.AdminDivisionHelper;
import kd.occ.ocepfp.core.service.auxpty.AuxptyHelper;
import kd.occ.ocepfp.core.servicehelper.ExtFormServiceHelper;

public abstract class AbstractFormData
extends AbstractCacheFormData {
    protected static Log logger = LogFactory.getLog(AbstractFormData.class);
    protected ExtDynamicView<?> view;
    private MainEntityType mainEntity;
    private boolean init = false;
    private boolean entryInit = false;
    private Map<String, SelectedRow> currentSelection;
    private AbstractExtFormPlugin plugin;

    public MainEntityType getMainEntity() {
        if (this.mainEntity == null) {
            this.mainEntity = NextCloudEntityMetadataCache.getDataEntityType(this.view.getExtCtx(), this.view.getViewId());
        }
        return this.mainEntity;
    }

    public AbstractFormData() {
    }

    public AbstractFormData(String ormViewId, ExtDynamicView<?> view, AbstractExtFormPlugin plugin) {
        this.view = view;
        this.plugin = plugin;
    }

    public DynamicObject getDataObject() {
        return this.dataObject;
    }

    public IDataEntityProperty getProperty(String name) {
        MainEntityType et = this.getMainEntity();
        return et.findProperty(name.toLowerCase());
    }

    public DynamicObject createNewEntryDynamicObject(String entryId) {
        entryId = entryId.toLowerCase();
        EntryProp p = (EntryProp)this.getProperty(entryId);
        DynamicObject newRowData = new DynamicObject(p.getDynamicCollectionItemPropertyType());
        MainMetadata metadata = this.view.getPageView().getMetadata();
        Entry entry = metadata.getEntry(entryId);
        this.setDefault(newRowData, entry.getDefaultValueFieldList());
        this.setNextSeq(entryId, newRowData);
        this.setUniqueRow(entryId, newRowData);
        return newRowData;
    }

    public DynamicObjectCollection createDynamicObjectCollection(String entryId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)this.getDataObject().getDataEntityType().getName());
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entityType.getProperty(entryId);
        return new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entityType);
    }

    private void setDefault(DynamicObject dynamicObject, List<Field> fields) {
        if (fields != null && fields.size() > 0) {
            this.beginEntryInit();
            for (Field field : fields) {
                if (field.getDefaultValue() == null) continue;
                this.updateValuePrivate(dynamicObject, field.getId(), field.getDefaultValue());
            }
            this.endEntryInit();
        }
    }

    private void setNextSeq(String entryId, DynamicObject newRowData) {
        DynamicObjectCollection entryCollection = this.getEntryRowData(entryId);
        newRowData.set("seq", (Object)(entryCollection.size() + 1));
    }

    private void reSetSeq(String entryId) {
        DynamicObjectCollection entryCollection = this.getEntryRowData(entryId);
        int seq = 1;
        for (DynamicObject data : entryCollection) {
            data.set("seq", (Object)seq++);
        }
    }

    public DynamicObject addEntryRow(String entryId) {
        this.setModifyEntry(entryId);
        DynamicObject newRowData = this.createNewEntryDynamicObject(entryId);
        return this.addEntryRow(entryId, newRowData);
    }

    public DynamicObject insertEntryRow(String entryId, DynamicObject entryRowData, int row) {
        entryId = entryId.toLowerCase();
        this.setModifyEntry(entryId);
        this.setUniqueRow(entryId, entryRowData);
        DynamicObjectCollection entryDataCollection = this.getEntryRowData(entryId);
        entryDataCollection.add(row, entryRowData);
        if (!this.isInit() && !this.isEntryInit()) {
            ExtDynamicObject extObject = ExtBillFormDataFormatter.newInstance(this.view, this.getDataObject()).convertEntry(entryId, entryRowData, row);
            this.view.insertEntryRow(entryId, extObject, row);
        }
        return entryRowData;
    }

    public DynamicObject addEntryRow(String entryId, DynamicObject entryRowData) {
        entryId = entryId.toLowerCase();
        this.setModifyEntry(entryId);
        this.setUniqueRow(entryId, entryRowData);
        DynamicObjectCollection entryDataCollection = this.getEntryRowData(entryId);
        entryDataCollection.add((Object)entryRowData);
        if (!this.isInit() && !this.isEntryInit()) {
            ExtDynamicObject extObject = ExtBillFormDataFormatter.newInstance(this.view, this.getDataObject()).convertEntry(entryId, entryRowData, entryDataCollection.size());
            this.view.addEntryRow(entryId, extObject);
        }
        return entryRowData;
    }

    public void delEntryRow(String entryId, final int row) {
        entryId = entryId.toLowerCase();
        this.delEntryRow(entryId, (List<Integer>)new ArrayList<Integer>(){
            {
                this.add(row);
            }
        });
    }

    public void delEntryRow(String entryId, List<Integer> rows) {
        if (rows == null || rows.size() == 0) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = this.getEntryRowData(entryId = entryId.toLowerCase());
        if (dynamicObjectCollection == null) {
            return;
        }
        ArrayList rowList = new ArrayList(rows.size());
        rows.sort(Comparator.reverseOrder());
        HashMap<String, Integer> data = null;
        String uqrow = UniqueRowUtil.getPropertyName((String)entryId);
        for (int row : rows) {
            data = new HashMap<String, Integer>(2);
            data.put("row", row);
            data.put(entryId + "_uqrow", ((DynamicObject)dynamicObjectCollection.get(row)).getInt(uqrow));
            rowList.add(data);
            dynamicObjectCollection.remove(row);
        }
        this.setModifyEntry(entryId);
        this.reSetSeq(entryId);
        if (!this.isInit() && !this.isEntryInit()) {
            this.view.delEntryRow(entryId, rowList);
            String subDataGridId = ((DataGrid)this.view.getPageView().getPageBody().getControl(entryId)).getSubDataGridId();
            if (StringUtil.isNotNull((String)subDataGridId)) {
                this.view.updateFrontValue(subDataGridId, null);
            }
        }
        this.doFormula();
    }

    public void delEntryAllRow(String entryId) {
        entryId = entryId.toLowerCase();
        MainMetadata metadata = this.view.getPageView().getMetadata();
        Entry entry = metadata.getEntry(entryId);
        DynamicObjectCollection dynamicObjectCollection = this.getEntryRowData(entryId);
        dynamicObjectCollection.clear();
        this.view.updateFrontValue(entryId, dynamicObjectCollection);
        Entry subEntry = entry.getSubEntry();
        if (subEntry != null) {
            this.view.updateFrontValue(subEntry.getId(), null);
        }
        this.doFormula();
    }

    private void setUniqueRow(String entryId, DynamicObject rowData) {
        int maxRow;
        DynamicObjectCollection entryList = this.getEntryRowData(entryId = entryId.toLowerCase());
        int n = maxRow = entryList != null ? entryList.size() : 0;
        if (maxRow > 0) {
            maxRow = ((DynamicObject)entryList.get(maxRow - 1)).getInt(UniqueRowUtil.getPropertyName((String)entryId)) + 1;
        }
        rowData.set(UniqueRowUtil.getPropertyName((String)entryId), (Object)maxRow);
    }

    public DynamicObject initDynamicObject() {
        this.dataObject = this.createNewBillData();
        return this.dataObject;
    }

    public DynamicObject createNewBillData() {
        MainEntityType met = NextCloudEntityMetadataCache.getDataEntityType(this.view.getExtCtx(), this.view.getViewId());
        DynamicObject dynamicObject = (DynamicObject)met.createInstance();
        this.initDefaultValue(dynamicObject);
        this.setNumber(dynamicObject);
        return dynamicObject;
    }

    private final void initDefaultValue(DynamicObject dynamicObject) {
        List<Field> fields = this.view.getPageView().getMetadata().getFieldList();
        if (fields == null || fields.size() == 0) {
            return;
        }
        block12: for (Field field : fields) {
            switch (field.getFieldType()) {
                case "Checkbox": {
                    this.updateValuePrivate(dynamicObject, field.getId(), StringUtil.isNotNull((Object)field.getDefaultValue()) && field.getDefaultValue().toString().equalsIgnoreCase("1"));
                    continue block12;
                }
                case "CreateDate": {
                    this.updateValuePrivate(dynamicObject, field.getId(), DateUtil.getCurrentDate());
                    continue block12;
                }
                case "Creator": {
                    this.updateValuePrivate(dynamicObject, field.getId(), RequestContext.get().getUserId());
                    continue block12;
                }
                case "SelectData": {
                    Control control = (Control)this.view.getPageView().getPageBody().getControl(field.getId());
                    if (!StringUtil.isNull((String)((SelectData)control).getBaseViewId())) break;
                    continue block12;
                }
            }
            this.updateValuePrivate(dynamicObject, field.getId(), field.getDefaultValue());
        }
    }

    public void setDataObject(DynamicObject dataObject) {
        this.dataObject = dataObject;
    }

    public void updateValue(String dataGridId, String groupValue, String controlId, Object value) {
        this.view.updateValue(dataGridId, groupValue, controlId, value);
    }

    public final void updateValue(String propertyName, Object value) {
        this.updateValue(propertyName, value, false);
    }

    public final void updateValue(String propertyName, Object value, boolean doDataChange) {
        propertyName = propertyName.toLowerCase();
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        if (control != null && control.isFilterField()) {
            if (control.isF7()) {
                SelectData selectData = (SelectData)control;
                String displayName = selectData.getDisplayField();
                displayName = StringUtil.isNotNull((String)displayName) ? displayName : "name";
                DynamicObject f7DataObject = (DynamicObject)value;
                boolean isDataObjectNull = f7DataObject != null;
                String id = isDataObjectNull ? f7DataObject.getString("id") : "0";
                String number = isDataObjectNull ? f7DataObject.getString("number") : "";
                String name = isDataObjectNull ? f7DataObject.getString(displayName) : "";
                String display = isDataObjectNull ? f7DataObject.getString(selectData.getDisplayField()) : "";
                this.view.updateFrontF7(propertyName, -1, id, number, name, display);
            } else {
                this.view.updateFrontValue(propertyName, -1, value);
            }
            return;
        }
        if (control != null && control.getType().equalsIgnoreCase("AdminDivision")) {
            value = this.updateAdminDivisionByValueType(this.dataObject, control, propertyName, value);
        } else if (control != null && value instanceof Long && control.getType().equalsIgnoreCase("Sku")) {
            value = AuxptyHelper.getAuxptyDynamicObject(Convert.toLong((Object)value));
        }
        if (doDataChange) {
            DataChangeEvent event = new DataChangeEvent(this.view.getExtCtx(), this.view.getPageView(), propertyName, value, -1);
            this.plugin.tryOnDataChange(event);
        } else {
            this.updateValuePrivate(this.dataObject, propertyName, -1, value);
        }
        if (control != null && "DataGrid".equalsIgnoreCase(control.getType())) {
            this.getFormModifiedManager().addModifiedEntries(propertyName);
        } else {
            this.getFormModifiedManager().setHeadModified();
        }
    }

    public final void updateImgGroup(String propertyName, List<ImgObject> imgGroups) {
        propertyName = propertyName.toLowerCase();
        this.updateValuePrivate(this.dataObject, propertyName, -1, JsonUtil.toString(imgGroups));
        if (!this.isInit() && !this.isEntryInit()) {
            this.view.updateFrontValue(propertyName, imgGroups);
        }
    }

    public final void updateValue(String propertyName, int row, Object value) {
        this.updateValue(propertyName, row, value, false);
    }

    public final void updateValue(String propertyName, int row, Object value, boolean doDataChange) {
        propertyName = propertyName.toLowerCase();
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        boolean isDataGrid = control != null && control.fromDataGrid();
        value = this.updateValueWithByPrecision(propertyName, row, value);
        if (isDataGrid) {
            this.updateEntryValue(propertyName, row, value, doDataChange);
            this.updateScaleByUnit(propertyName, row);
        } else {
            this.updateValue(propertyName, value);
        }
    }

    public final void updateEntryValue(String propertyName, int row, Object value) {
        this.updateEntryValue(propertyName, row, value, false);
    }

    public final void updateEntryValue(String propertyName, int row, Object value, boolean doDataChange) {
        if (doDataChange) {
            DataChangeEvent event = new DataChangeEvent(this.view.getExtCtx(), this.view.getPageView(), propertyName, value, row);
            this.plugin.tryOnDataChange(event);
            return;
        }
        propertyName = propertyName.toLowerCase();
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        if (control != null && StringUtil.isNotNull((String)control.getSrcDataGrid())) {
            DynamicObjectCollection dynamicObjectCollection = this.getEntryRowData(control.getSrcDataGrid());
            DynamicObject rowDataObject = null;
            if (dynamicObjectCollection != null && dynamicObjectCollection.size() > row) {
                rowDataObject = (DynamicObject)dynamicObjectCollection.get(row);
                this.updateValuePrivate(rowDataObject, propertyName, row, value);
                this.setModifyEntry(control.getSrcDataGrid());
            }
        }
    }

    private final void updateValuePrivate(DynamicObject dynamicObject, String propertyName, Object value) {
        propertyName = propertyName.toLowerCase();
        this.updateValuePrivate(dynamicObject, propertyName, -1, value);
    }

    private final void updateValuePrivate(DynamicObject dynamicObject, String propertyName, int row, Object value) {
        propertyName = propertyName.toLowerCase();
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        if (control != null && control.isF7()) {
            this.updateF7ValuePrivate(dynamicObject, propertyName, row, value);
        } else if (control != null && "Sku".equalsIgnoreCase(control.getType())) {
            this.updataSkuValuePrivate(dynamicObject, propertyName, row, value);
        } else if (control != null && "AdminDivision".equalsIgnoreCase(control.getType())) {
            this.updateAdminDivisionPrivate(dynamicObject, propertyName, row, value);
        } else {
            this.updateNormanValuePrivate(dynamicObject, propertyName, row, value);
        }
    }

    private void updataSkuValuePrivate(DynamicObject dynamicObject, String propertyName, int row, Object value) {
        Control flexField;
        String materialField;
        long materialId;
        IDataEntityProperty prop = this.getProperty(propertyName);
        boolean isUpdateModel = prop != null && dynamicObject != null;
        long auxptyId = 0L;
        if (value instanceof Auxpty) {
            auxptyId = Long.parseLong(((Auxpty)value).getAuxptyId());
        } else if (value instanceof Long) {
            auxptyId = Long.parseLong(value.toString());
        } else if (value instanceof DynamicObject) {
            auxptyId = ((DynamicObject)value).getLong("id");
        } else {
            this.view.updateFrontValue(propertyName, row, null, false);
            return;
        }
        if (isUpdateModel && (materialId = dynamicObject.getLong((materialField = (flexField = (Control)this.view.getControl(propertyName)).getBaseField()) + "_" + "id")) != 0L) {
            DynamicObject auxpty = AuxptyHelper.getAuxptyDynamicObject(auxptyId, materialId);
            prop.setValueFast((Object)dynamicObject, (Object)auxpty);
        }
        Auxpty data = AuxptyHelper.getAuxptyName(auxptyId);
        this.view.updateFrontValue(propertyName, row, data, false);
    }

    private void updateAdminDivisionPrivate(DynamicObject dynamicObject, String propertyName, int row, Object value) {
        boolean isUpdateModel;
        IDataEntityProperty prop = this.getProperty(propertyName = propertyName.toLowerCase());
        boolean bl = isUpdateModel = prop != null && dynamicObject != null;
        if (isUpdateModel) {
            prop.setValueFast((Object)dynamicObject, value);
        }
    }

    private final void updateNormanValuePrivate(DynamicObject dynamicObject, String propertyName, int row, Object value) {
        boolean isUpdateModel;
        boolean isImageObj;
        propertyName = propertyName.toLowerCase();
        Object newValue = value;
        Object frontValue = value;
        boolean forceUpdateFront = false;
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        IDataEntityProperty prop = this.getProperty(propertyName);
        if (control instanceof IValueFormatter) {
            newValue = frontValue = ((IValueFormatter)control).formate(value);
        }
        if (control == null) {
            LogUtil.info(AbstractFormData.class, (String)("updateNormanValuePrivate Error:controlid:" + propertyName));
        }
        boolean bl = isImageObj = control != null && value != null && "Img".equals(control.getType()) && value instanceof ImgObject;
        if (isImageObj) {
            newValue = ((ImgObject)value).getSrc();
            forceUpdateFront = true;
            frontValue = value;
        }
        if (value instanceof Auxpty && control != null && "auxpty".equals(control.getType())) {
            frontValue = ((Auxpty)value).getAuxptyName();
            newValue = ((Auxpty)value).getAuxptyId();
        }
        boolean bl2 = isUpdateModel = prop != null && dynamicObject != null;
        if (isUpdateModel) {
            prop.setValueFast((Object)dynamicObject, newValue);
        }
        if (!this.isInit() && !this.isEntryInit() || !isUpdateModel || forceUpdateFront) {
            Object v = frontValue;
            if (control != null && newValue != null && !control.getType().equals("MultiLanguageText") && newValue instanceof OrmLocaleValue) {
                v = ((OrmLocaleValue)frontValue).getLocaleValue();
            }
            if (control != null && control.getType().equalsIgnoreCase("DataGrid")) {
                this.view.updateFrontValue(propertyName, row, ExtBillFormDataFormatter.newInstance(this.view, this.getDataObject()).convertEntry(propertyName, (DynamicObjectCollection)value));
            } else {
                this.view.updateFrontValue(propertyName, row, v);
            }
        }
    }

    private final DynamicObject updateF7ValuePrivate(DynamicObject dynamicObject, String propertyName, int row, Object value) {
        boolean isUpdateModel;
        String[] relatedControls;
        propertyName = propertyName.toLowerCase();
        PageBody pageBody = this.view.getPageView().getPageBody();
        SelectData selectData = (SelectData)pageBody.getControl(propertyName);
        String displayName = selectData.getDisplayField();
        displayName = StringUtil.isNotNull((String)displayName) ? displayName : "name";
        IDataEntityProperty prop = this.getProperty(propertyName);
        DynamicObject f7DataObject = this.loadF7Data(dynamicObject, propertyName, value);
        if (StringUtil.isNotNull((String)selectData.getRelatedControls()) && (relatedControls = selectData.getRelatedControls().split(",")).length > 0) {
            for (int j = 0; j < relatedControls.length; ++j) {
                Control descControl = (Control)pageBody.getControl(relatedControls[j]);
                this.updateValuePrivate(dynamicObject, descControl.getId(), row, f7DataObject != null ? f7DataObject.get(descControl.getSpecificLinkOrm()) : "");
            }
        }
        if (StringUtil.isNotNull((String)selectData.getRelatedBaseField())) {
            long baseFieldPkValue = f7DataObject != null ? Convert.toLong((Object)f7DataObject.getPkValue()) : 0L;
            Control flexField = (Control)pageBody.getControl(selectData.getRelatedBaseField());
            FlexMeta flexMata = null;
            if (flexField.isSpu()) {
                flexMata = AuxptyHelper.getSpuItemListByItemId(baseFieldPkValue);
                String relatedSku = flexField.getRelatedSku();
                if (StringUtil.isNotNull((String)relatedSku)) {
                    Control sku = (Control)pageBody.getControl(relatedSku);
                    if (flexMata != null) {
                        sku.setHidden(true);
                        this.view.setAuxptyListValue(relatedSku, null);
                    } else {
                        sku.setHidden(false);
                    }
                }
            } else if (!"true".equalsIgnoreCase(flexField.getHidden())) {
                flexMata = AuxptyHelper.getFlexMetaByMaterialId(baseFieldPkValue);
            }
            if (flexMata != null) {
                this.view.setAuxptyListValue(flexField.getId(), flexMata);
            }
        }
        if (StringUtil.isNotNull((String)selectData.getSkuField()) && f7DataObject != null) {
            DynamicObject material;
            String skuField = selectData.getSkuField();
            if (f7DataObject.getLong("id") != 0L && (material = BusinessDataServiceHelper.loadSingle((Object)f7DataObject.getLong("id"), (String)"bd_material")) != null) {
                this.view.disable(skuField, !material.getBoolean("isuseauxpty"), row);
            }
            this.updateValuePrivate(dynamicObject, skuField, row, null);
        }
        boolean bl = isUpdateModel = prop != null && dynamicObject != null;
        if (isUpdateModel) {
            prop.setValueFast((Object)dynamicObject, (Object)f7DataObject);
        }
        if (!this.isInit() && !this.isEntryInit() || !isUpdateModel) {
            boolean isDataObjectNull = f7DataObject != null;
            String id = isDataObjectNull ? f7DataObject.getString("id") : "0";
            String number = isDataObjectNull && f7DataObject.getDynamicObjectType().getProperties().containsKey((Object)"number") ? f7DataObject.getString("number") : "";
            String name = isDataObjectNull ? f7DataObject.getString(displayName) : "";
            String display = isDataObjectNull ? f7DataObject.getString(selectData.getDisplayField()) : "";
            List<String> formatOrms = selectData.getFormatOrms();
            HashMap<String, Object> linkedMap = null;
            if (formatOrms != null) {
                linkedMap = new HashMap<String, Object>(6);
                for (String orm : formatOrms) {
                    linkedMap.put(orm, f7DataObject != null ? f7DataObject.getString(orm) : "");
                }
            }
            if (f7DataObject != null && selectData.getType().equals("Unit")) {
                linkedMap = linkedMap == null ? new HashMap<String, Object>(6) : linkedMap;
                linkedMap.put("pp", f7DataObject.get("precision") == null ? 2 : f7DataObject.getInt("precision"));
                linkedMap.put("pa", f7DataObject.get("precisionaccount") == null ? 1 : f7DataObject.getInt("precisionaccount"));
            }
            this.view.updateFrontF7(propertyName, row, id, number, name, display, (Map<String, Object>)linkedMap);
        }
        return f7DataObject;
    }

    public DynamicObject loadF7Data(String propertyName, Object value) {
        propertyName = propertyName.toLowerCase();
        return this.loadF7Data(null, propertyName, value);
    }

    public DynamicObject createF7Data(String propertyName, Object pkValue, String name) {
        PageBody pageBody = this.view.getPageView().getPageBody();
        SelectData selectData = (SelectData)pageBody.getControl(propertyName);
        MainEntityType met = NextCloudEntityMetadataCache.getDataEntityType(this.view.getExtCtx(), selectData.getSelectDataEntity(this.view.getExtCtx()).getBaseViewId());
        DynamicObject f7DataObject = (DynamicObject)met.createInstance();
        f7DataObject.set("id", pkValue);
        f7DataObject.set(selectData.getDisplayField(), (Object)name);
        return f7DataObject;
    }

    public DynamicObject loadF7Data(DynamicObject dynamicObject, String propertyName, Object value) {
        propertyName = propertyName.toLowerCase();
        if (value instanceof DynamicObject) {
            return (DynamicObject)value;
        }
        PageBody pageBody = this.view.getPageView().getPageBody();
        DynamicObject f7DataObject = null;
        Control control = (Control)pageBody.getControl(propertyName);
        if (!control.isF7()) {
            String baseviewid = control.getString("baseviewid");
            String displayName = control.getString("displayname");
            if (StringUtil.isNull((String)displayName)) {
                displayName = "name";
            }
            BillEntityType billEntityType = (BillEntityType)NextCloudEntityMetadataCache.getDataEntityType(this.view.getExtCtx(), baseviewid);
            String relatedorm = "id," + billEntityType.getBillNo() + "," + displayName;
            Object newPkValue = value;
            if (billEntityType.getPrimaryKey() instanceof LongProp) {
                newPkValue = Long.parseLong(value.toString());
            }
            f7DataObject = ExtFormServiceHelper.loadSingle(this.view.getExtCtx(), baseviewid, newPkValue, relatedorm);
        } else {
            SelectData selectData = (SelectData)control;
            String displayName = selectData.getDisplayField();
            String string = displayName = StringUtil.isNotNull((String)displayName) ? displayName : "name";
            if ((value == null || StringUtil.isNull((String)Convert.toString((Object)value))) && StringUtil.isNotNull((String)selectData.getBaseViewId())) {
                MainEntityType met = NextCloudEntityMetadataCache.getDataEntityType(this.view.getExtCtx(), selectData.getSelectDataEntity(this.view.getExtCtx()).getBaseViewId());
                f7DataObject = (DynamicObject)met.createInstance();
            } else if (value instanceof Map) {
                DynamicObject f7Data;
                DynamicObject dynamicObject2 = f7Data = dynamicObject != null ? (DynamicObject)dynamicObject.get(propertyName) : null;
                if (f7Data == null) {
                    MainEntityType met = EntityMetadataCache.getDataEntityType((String)selectData.getSelectDataEntity(this.view.getExtCtx()).getBaseViewId().toLowerCase());
                    f7Data = (DynamicObject)met.createInstance();
                }
                ISimpleProperty pkProp = f7Data.getDataEntityType().getPrimaryKey();
                f7Data.set((IDataEntityProperty)pkProp, ((Map)value).get("id"));
                f7Data.getPkValue();
                f7Data.set("number", ((Map)value).get("number"));
                f7Data.set(displayName, ((Map)value).get(displayName));
                f7DataObject = f7Data;
            } else {
                ExtWebContext extCtx = this.view.getExtCtx();
                BillEntityType billEntityType = (BillEntityType)NextCloudEntityMetadataCache.getDataEntityType(extCtx, selectData.getSelectDataEntity(extCtx).getBaseViewId());
                String relatedorm = "id," + selectData.getBillnoField(extCtx) + (StringUtil.isNotNull((String)selectData.getRelatedOrm()) ? "," + selectData.getRelatedOrm() : "");
                if (("," + relatedorm + ",").indexOf("," + displayName + ",") < 0) {
                    relatedorm = relatedorm + "," + displayName;
                }
                if (StringUtil.isNotNull((String)selectData.getRefProp())) {
                    relatedorm = relatedorm + "," + selectData.getRefProp();
                }
                if (StringUtil.isNotNull((String)selectData.getSkuField())) {
                    relatedorm = relatedorm + ",isuseauxpty";
                }
                Object newPkValue = value;
                if (billEntityType.getPrimaryKey().getDbType() == 1 && value != null) {
                    newPkValue = Long.parseLong(value.toString());
                }
                try {
                    f7DataObject = ExtFormServiceHelper.loadSingle(extCtx, selectData.getSelectDataEntity(extCtx).getBaseViewId(), newPkValue, relatedorm);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return f7DataObject;
    }

    public final Object get(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.get(propertyName);
        }
        return null;
    }

    public String getString(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getString(propertyName);
        }
        return null;
    }

    public int getInt(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getInt(propertyName);
        }
        return 0;
    }

    public long getLong(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getLong(propertyName);
        }
        return 0L;
    }

    public boolean getBoolean(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getBoolean(propertyName);
        }
        return false;
    }

    public BigDecimal getBigDecimal(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getBigDecimal(propertyName);
        }
        return Convert.ZERO_BIGDECIMAL;
    }

    public Date getDate(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getDate(propertyName);
        }
        return null;
    }

    public DynamicObject getDynamicObject(String propertyName) {
        if (this.dataObject != null) {
            return this.dataObject.getDynamicObject(propertyName);
        }
        return null;
    }

    public DynamicObjectCollection getEntryRowData(String entryId) {
        if (this.dataObject != null) {
            entryId = entryId.toLowerCase();
            MainMetadata metadata = this.view.getPageView().getMetadata();
            Entry entry = metadata.getEntry(entryId);
            DynamicObjectCollection entryDataCollection = null;
            if (StringUtil.isNotNull((String)entry.getParentDataGrid())) {
                SelectedRow currentSelectedRow = this.getParentEntryRow(entryId);
                if (currentSelectedRow != null) {
                    entryDataCollection = ((DynamicObject)this.dataObject.getDynamicObjectCollection(entry.getParentDataGrid()).get(currentSelectedRow.getRow())).getDynamicObjectCollection(entryId);
                }
            } else {
                entryDataCollection = this.dataObject.getDynamicObjectCollection(entryId);
            }
            return entryDataCollection;
        }
        return new DynamicObjectCollection();
    }

    public DynamicObject getEntryRowData(String entryId, int row) {
        DynamicObjectCollection entryRowDataList = this.getEntryRowData(entryId);
        if (entryRowDataList != null && entryRowDataList.size() > row && row > -1) {
            return (DynamicObject)entryRowDataList.get(row);
        }
        return null;
    }

    public Object getEntryRowData(String entryId, int row, String propertyName) {
        DynamicObject rowData = this.getEntryRowData(entryId, row);
        if (rowData != null) {
            return rowData.get(propertyName);
        }
        return null;
    }

    public DynamicObjectCollection getEntryRowData(String entryId, List<SelectedRow> selectedRows) {
        DynamicObjectCollection dataList = new DynamicObjectCollection();
        if (selectedRows != null && selectedRows.size() > 0) {
            for (SelectedRow selectRow : selectedRows) {
                dataList.add((Object)this.getEntryRowData(entryId, selectRow));
            }
        }
        return dataList;
    }

    public DynamicObject getEntryRowData(String entryId, SelectedRow selectedRow) {
        return this.getEntryRowData(entryId, selectedRow.getRow());
    }

    public void setModifyEntry(String entryId) {
        MainMetadata metadata = this.view.getPageView().getMetadata();
        Entry entry = metadata.getEntry(entryId = entryId.toLowerCase());
        String modifyEntryId = StringUtil.isNotNull((String)entry.getParentDataGrid()) ? entry.getParentDataGrid() : entryId;
        this.getFormModifiedManager().addModifiedEntries(modifyEntryId);
    }

    private SelectedRow getParentEntryRow(String dataGridId) {
        dataGridId = dataGridId.toLowerCase();
        DataGrid dataGrid = (DataGrid)this.view.getPageView().getPageBody().getControl(dataGridId);
        SelectedRow selectedRow = null;
        if (StringUtil.isNotNull((String)dataGrid.getParentDataGrid())) {
            selectedRow = this.getCurrentSelection().get(dataGrid.getParentDataGrid());
        }
        return selectedRow;
    }

    private Map<String, SelectedRow> getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(Map<String, SelectedRow> currentSelection) {
        this.currentSelection = currentSelection != null ? currentSelection : new HashMap<String, SelectedRow>(2);
    }

    public void preSetCurrentSelection(String dataGridId, int row) {
        SelectedRow _preSelectionRow;
        dataGridId = StringUtil.toLowerCase((String)dataGridId);
        SelectedRow selectedRow = _preSelectionRow = this.currentSelection == null ? null : this.currentSelection.get(dataGridId);
        if (_preSelectionRow == null || _preSelectionRow.getRow() != row) {
            _preSelectionRow = new SelectedRow();
            _preSelectionRow.setRow(row);
            HashMap<String, SelectedRow> _map = new HashMap<String, SelectedRow>();
            _map.put(dataGridId, _preSelectionRow);
            this.setCurrentSelection(_map);
        }
    }

    private void setNumber(DynamicObject dynamicObject) {
        MainMetadata metadata = MetadataFactory.getMetadata(this.view.getExtCtx());
        if (dynamicObject == null || metadata.getBillNoField() == null || StringUtil.isNull((String)metadata.getBillNoField().getBaseViewId()) || metadata.getBillType().equalsIgnoreCase(BillViewType.ListView.getValue())) {
            return;
        }
        CodeRuleInfo codeRule = CodeRuleServiceHelper.getCodeRule((String)metadata.getBillNoField().getBaseViewId(), (DynamicObject)dynamicObject, null);
        if (codeRule != null && !codeRule.getAppMode().equals("1")) {
            String number = CodeRuleServiceHelper.readNumber((CodeRuleInfo)codeRule, (DynamicObject)dynamicObject);
            dynamicObject.set(metadata.getBillNoField().getId(), (Object)number);
        }
    }

    public void beginInit() {
        this.init = true;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean isEntryInit() {
        return this.entryInit;
    }

    public void beginEntryInit() {
        this.entryInit = true;
    }

    public void endEntryInit() {
        this.entryInit = false;
    }

    public void endInit() {
        this.init = false;
        if (this.isNeedCache()) {
            this.getFormModifiedManager().setAllModified();
        }
    }

    public Auxpty getAuxpty(long auxptyId, boolean isspu) {
        if (isspu) {
            return AuxptyHelper.getSpuDetail(auxptyId);
        }
        return AuxptyHelper.getAuxptyName(auxptyId);
    }

    public Auxpty getAuxpty(String auxptyControl, long auxptyId) {
        Control flexField = (Control)this.view.getControl(auxptyControl);
        Auxpty updateValue = null;
        updateValue = flexField.isSpu() ? AuxptyHelper.getSpuDetail(auxptyId) : AuxptyHelper.getAuxptyName(auxptyId);
        return updateValue;
    }

    public void updateAuxpty(String parentAuxptyControl, String auxptyControl, long auxptyId) {
        AbstractExtFormPlugin<?, ?> parentForm = this.view.getParentForm();
        AbstractFormData abstractFormData = (AbstractFormData)parentForm.getBillData();
        Control flexField = (Control)this.view.getControl(auxptyControl);
        if (abstractFormData != null && StringUtil.isNotNull((String)parentAuxptyControl)) {
            Auxpty updateValue = null;
            updateValue = flexField.isSpu() ? AuxptyHelper.getSpuDetail(auxptyId) : AuxptyHelper.getAuxptyName(auxptyId);
            abstractFormData.updateValue(parentAuxptyControl, updateValue);
        }
        this.view.closeView(this.view.getPageId());
    }

    public final void doFormula(ClientEvent clientEvent) {
        String event;
        String string = event = clientEvent != null ? clientEvent.getEvent() : "update";
        if ("loaddata".equalsIgnoreCase(event) || "refresh".equalsIgnoreCase(event) || "dosearch".equalsIgnoreCase(event) || "toolbarclick".equalsIgnoreCase(event) || "popselectdata".equalsIgnoreCase(event) || "dropselectdata".equalsIgnoreCase(event) || "loadfilterdata".equalsIgnoreCase(event) || "ontime".equalsIgnoreCase(event)) {
            return;
        }
        this.doFormula();
    }

    public final void doFormula() {
        List<Formula> formulaList = this.view.getPageView().getPageBody().getFormulaList();
        if (formulaList.size() == 0) {
            return;
        }
        for (Formula formula : formulaList) {
            FormulaData formulData = new FormulaData(formula, this.view.getPageView());
            formulData.setDataObject(this.getDataObject());
            FormulaExector formulaExector = FormulaFactory.getFormulaExector(formula.getFunName());
            if (formulaExector == null) continue;
            this.updateValue(formula.getControlId(), formulaExector.execute(this.view.getExtCtx(), formulData));
        }
    }

    private long updateAdminDivisionByValueType(DynamicObject dataObject, Control control, String propertyName, Object value) {
        long divisionId = 0L;
        if (value instanceof HashMap) {
            AdminDivision adminDivision;
            String linkedAdd;
            String district;
            String city;
            String province;
            HashMap valueMap = (HashMap)value;
            String nation = (String)valueMap.get("nation");
            DynamicObject adminDivisionInfo = AdminDivisionHelper.getDivisionIdByAddress(nation, province = (String)valueMap.get("province"), city = (String)valueMap.get("city"), district = (String)valueMap.get("district"));
            if (adminDivisionInfo != null) {
                divisionId = Convert.toLong((Object)adminDivisionInfo.getPkValue());
            }
            if (StringUtil.isNotNull((String)(linkedAdd = (adminDivision = (AdminDivision)control).getLinkedAddress()))) {
                this.updateValuePrivate(dataObject, linkedAdd, -1, valueMap.get("street_number"));
            }
        } else {
            divisionId = Convert.toLong((Object)value);
        }
        this.view.updateAdminDivision(propertyName, AdminDivisionHelper.getDivisionNameMap(divisionId));
        return divisionId;
    }

    private final void updateScaleByUnit(String propertyName, int row) {
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        switch (control.getType()) {
            case "Unit": {
                List<String> linkedFields = this.view.getPageView().getPageBody().getLinkedUnitFormatField(propertyName);
                if (linkedFields == null || linkedFields.size() == 0) {
                    return;
                }
                DynamicObject rowData = this.getEntryRowData(control.getSrcDataGrid(), row);
                if (rowData == null) {
                    return;
                }
                DynamicObject unitDataObject = rowData.getDynamicObject(propertyName);
                if (unitDataObject == null) {
                    return;
                }
                for (String field : linkedFields) {
                    this.updateValue(field, row, rowData.getBigDecimal(field));
                }
                break;
            }
            case "Currency": {
                Control linkField;
                List<String> linkedFields = this.view.getPageView().getPageBody().getLinkedCurrencyFormatField(propertyName);
                if (linkedFields == null || linkedFields.size() == 0) {
                    return;
                }
                PageBody pageBody = this.view.getPageView().getPageBody();
                for (String field : linkedFields) {
                    linkField = (Control)pageBody.getControl(field);
                    if (StringUtil.isNotNull((String)linkField.getSrcDataGrid())) continue;
                    this.updateValue(field, this.dataObject.get(field));
                }
                for (String field : linkedFields) {
                    linkField = (Control)pageBody.getControl(field);
                    if (StringUtil.isNotNull((String)linkField.getSrcDataGrid())) continue;
                    int i = 0;
                    DynamicObjectCollection entryCollection = this.getEntryRowData(linkField.getSrcDataGrid());
                    for (DynamicObject data : entryCollection) {
                        this.updateValue(field, i, data.get(field));
                        ++i;
                    }
                }
                break;
            }
        }
    }

    private final Object updateValueWithByPrecision(String propertyName, int row, Object value) {
        Control control = (Control)this.view.getPageView().getPageBody().getControl(propertyName);
        Object rvalue = value;
        switch (control.getType()) {
            case "Qty": {
                if (StringUtil.isNull((String)((Qty)control).getUnit())) break;
                rvalue = value == null ? BigDecimal.ZERO : Convert.toBigDecimal((Object)value);
                DynamicObject rowData = this.getEntryRowData(control.getSrcDataGrid(), row);
                DynamicObject unitDataObject = rowData.getDynamicObject(((Qty)control).getUnit());
                return this.formatScale(unitDataObject, value == null ? BigDecimal.ZERO : (BigDecimal)rvalue);
            }
            case "Amount": 
            case "Price": {
                if (StringUtil.isNull((String)((Price)control).getCurrency())) break;
                DynamicObject currencyObject = this.dataObject.getDynamicObject(((Price)control).getCurrency());
                int amtprecision = 2;
                int priceprecision = 2;
                if (currencyObject != null) {
                    amtprecision = currencyObject.getInt("amtprecision");
                    priceprecision = currencyObject.getInt("priceprecision");
                }
                rvalue = value == null ? BigDecimal.ZERO : Convert.toBigDecimal((Object)value);
                rvalue = "Amount".equals(control.getType()) ? BigDecimalUtil.setScale((BigDecimal)((BigDecimal)rvalue), (int)amtprecision, (RoundingMode)RoundingMode.HALF_DOWN) : BigDecimalUtil.setScale((BigDecimal)((BigDecimal)rvalue), (int)priceprecision, (RoundingMode)RoundingMode.HALF_DOWN);
                return rvalue;
            }
        }
        return rvalue;
    }

    private final BigDecimal formatScale(DynamicObject unitObject, BigDecimal value) {
        int precision = unitObject == null || unitObject.get("precision") == null ? 2 : unitObject.getInt("precision");
        String precisionaccount = unitObject == null || unitObject.get("precisionaccount") == null ? "1" : unitObject.getString("precisionaccount");
        value = value == null ? BigDecimal.ZERO : value;
        return BigDecimalUtil.setScale((BigDecimal)value, (int)precision, (String)precisionaccount);
    }

    @Override
    public final void updateFormData() {
        this.doFormula();
        super.updateFormData();
    }
}

