/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.mvc.cache.PageCache;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.FormModifiedManager;
import kd.occ.ocepfp.common.entity.ParentViewInfo;
import kd.occ.ocepfp.common.util.JsonUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.entity.CustomControlStack;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.MixControl;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.event.LoadDataEvent;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.util.ParentViewCacheUtil;
import kd.occ.ocepfp.core.form.view.base.Command;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicViewBuilder;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.base.ViewProxy;
import kd.occ.ocepfp.core.form.view.parser.PageBody;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.orm.nextcloud.NextCloudEntityMetadataCache;
import kd.occ.ocepfp.core.servicehelper.ExtFormServiceHelper;

public abstract class ExtDynamicView<T>
extends ViewProxy {
    private CustomControlStack customControlStack = new CustomControlStack();
    private PageView pageView;
    private String parentPageId;
    private String pageId;
    private String viewId;
    private boolean isInitView = false;
    private ExtWebContext extCtx;
    protected FormModifiedManager modifiedManager;
    private PageCache pageCache;
    private AbstractExtFormPlugin parentForm;

    public <T> T getControl(String id) {
        Control t = (Control)this.pageView.getPageBody().getControl(id, this.customControlStack.getControls());
        if (this.isInitView && !t.getBoolean("_isDynamic", false).booleanValue()) {
            t = (Control)t.clone();
            t.put("_isDynamic", true);
            this.customControlStack.getControls().put(id.toLowerCase(), t);
        }
        return (T)t;
    }

    public void serializeCustomControl() {
        if (this.customControlStack.getControls().size() > 0) {
            String customStackStr = JsonUtil.toString((Object)this.customControlStack);
            this.getPageCache().put("_customControl", customStackStr);
        }
    }

    public void deserializeCustomControl() {
        String customControl = this.getPageCache().get("_customControl");
        if (StringUtil.isNotNull((String)customControl)) {
            this.customControlStack = (CustomControlStack)JsonUtil.readValue((String)customControl, CustomControlStack.class);
        }
    }

    @Override
    public PageView getPageView() {
        return this.pageView;
    }

    public PageCache getPageCache() {
        if (this.pageCache == null) {
            this.pageCache = new PageCache(this.getPageId());
        }
        return this.pageCache;
    }

    public final String getParentBillViewType() {
        ParentViewInfo parentViewInfo = ParentViewCacheUtil.getParentViewInfo(this.getPageId());
        if (parentViewInfo == null) {
            return "";
        }
        return parentViewInfo.getBillType();
    }

    public final AbstractExtFormPlugin<?, ?> getParentForm() {
        if (this.parentForm != null) {
            return this.parentForm;
        }
        ParentViewInfo parentViewInfo = ParentViewCacheUtil.getParentViewInfo(this.getPageId());
        if (parentViewInfo == null) {
            return null;
        }
        ExtWebContext parentCtx = ExtWebContext.newInstance();
        parentCtx.getForm().setViewId(parentViewInfo.getViewId());
        parentCtx.getForm().put((Object)"pageId", (Object)parentViewInfo.getPageId());
        parentCtx.getForm().put((Object)"event", (Object)"getparentview");
        PageView parentPageView = ViewFactory.get(parentCtx, parentViewInfo.getViewId());
        ExtDynamicView<?> parentView = ExtDynamicViewBuilder.buildDynamicView(parentCtx, parentPageView);
        if (parentView != null) {
            AbstractExtFormPlugin a = parentView.pageView.getPlugin();
            LoadDataEvent loadDataEvent = new LoadDataEvent(parentCtx, parentPageView);
            a.setView(parentView);
            a.initialize(loadDataEvent);
            this.parentForm = a;
            return a;
        }
        return null;
    }

    public final List<Command> getViewCommandOperations() {
        List<Command> operation = this.getOperationProxy().getOperation();
        if (this.parentForm != null) {
            operation.addAll(this.parentForm.getDynamicView().getOperationProxy().getOperation());
        }
        return operation;
    }

    public boolean isCustomDataType() {
        return this.pageView.isCustomDataType();
    }

    public void setPageView(PageView pageView) {
        this.pageView = pageView;
    }

    @Override
    public String getPageId() {
        return this.pageId;
    }

    public void setPageId(String pageId) {
        this.pageId = pageId;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getViewOrmId() {
        if (StringUtil.isNotNull((String)this.pageView.getBaseViewId())) {
            return this.pageView.getBaseViewId();
        }
        return this.viewId;
    }

    public void setViewId(String viewId) {
        this.viewId = viewId;
    }

    @Override
    public ExtWebContext getExtCtx() {
        return this.extCtx;
    }

    public void setExtCtx(ExtWebContext extCtx) {
        this.extCtx = extCtx;
    }

    public FormModifiedManager getModifiedManager() {
        return this.modifiedManager;
    }

    public void setModifiedManager(FormModifiedManager modifiedManager) {
        this.modifiedManager = modifiedManager;
    }

    private void updateF7(String controlId, int row, String pkValue, String billNo, String name, String display) {
    }

    private DynamicObject updateF7(String controlId, int row, Object pkValue) {
        controlId = controlId.toLowerCase();
        PageBody pageBody = this.getPageView().getPageBody();
        Control control = (Control)pageBody.getControl(controlId);
        if (control.isF7()) {
            return this.updateF74SelectData(controlId, row, pkValue);
        }
        return this.updateF74Other(controlId, row, pkValue);
    }

    private DynamicObject updateF74Other(String controlId, int row, Object pkValue) {
        DynamicObject dynamicObject;
        controlId = controlId.toLowerCase();
        PageBody pageBody = this.getPageView().getPageBody();
        Control control = (Control)pageBody.getControl(controlId);
        String baseviewid = control.getString("baseviewid");
        String displayName = control.getString("displayname");
        if (StringUtil.isNull((String)displayName)) {
            displayName = "name";
        }
        BillEntityType billEntityType = (BillEntityType)NextCloudEntityMetadataCache.getDataEntityType(this.getExtCtx(), baseviewid);
        String relatedorm = "id," + billEntityType.getBillNo() + "," + displayName;
        Object newPkValue = pkValue;
        if (billEntityType.getPrimaryKey() instanceof LongProp) {
            newPkValue = Long.parseLong(pkValue.toString());
        }
        if ((dynamicObject = ExtFormServiceHelper.loadSingle(this.getExtCtx(), baseviewid, newPkValue, relatedorm)) == null) {
            return null;
        }
        Object data = dynamicObject.get(displayName);
        if (data instanceof ILocaleString) {
            data = ((ILocaleString)data).getLocaleValue();
        }
        this.updateValue(controlId, row, data);
        return dynamicObject;
    }

    private DynamicObject updateF74SelectData(String controlId, int row, Object pkValue) {
        String[] relatedControls;
        controlId = controlId.toLowerCase();
        PageBody pageBody = this.getPageView().getPageBody();
        SelectData selectData = (SelectData)pageBody.getControl(controlId);
        BillEntityType billEntityType = (BillEntityType)NextCloudEntityMetadataCache.getDataEntityType(this.getExtCtx(), selectData.getSelectDataEntity(this.extCtx).getBaseViewId());
        String displayName = StringUtil.isNotNull((String)selectData.getDisplayField()) ? selectData.getDisplayField() : "name";
        String relatedorm = "id," + billEntityType.getBillNo() + (StringUtil.isNotNull((String)selectData.getRelatedOrm()) ? "," + selectData.getRelatedOrm() : "");
        if (("," + relatedorm + ",").indexOf("," + displayName + ",") < 0) {
            relatedorm = relatedorm + "," + displayName;
        }
        Object newPkValue = pkValue;
        if (billEntityType.getPrimaryKey().getDbType() == 1) {
            newPkValue = Long.parseLong(pkValue.toString());
        }
        DynamicObject dynamicObject = null;
        try {
            dynamicObject = ExtFormServiceHelper.loadSingle(this.getExtCtx(), selectData.getSelectDataEntity(this.extCtx).getBaseViewId(), newPkValue, relatedorm);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String id = dynamicObject != null ? dynamicObject.getString("id") : "0";
        String number = dynamicObject != null ? dynamicObject.getString("number") : "";
        String name = dynamicObject != null ? dynamicObject.getString(displayName) : "";
        String display = dynamicObject != null ? dynamicObject.getString(selectData.getDisplayField()) : "";
        this.doUpdateValue(controlId, row, dynamicObject);
        super.updateFrontF7(controlId, row, id, number, name, display);
        if (StringUtil.isNotNull((String)selectData.getRelatedControls()) && (relatedControls = selectData.getRelatedControls().split(",")).length > 0) {
            for (int j = 0; j < relatedControls.length; ++j) {
                Control descControl = (Control)pageBody.getControl(relatedControls[j]);
                this.updateValue(descControl.getId(), row, dynamicObject != null ? dynamicObject.get(descControl.getSpecificLinkOrm()) : "");
            }
        }
        return dynamicObject;
    }

    private DynamicObject updateF7(String controlId, Object pkValue) {
        controlId = controlId.toLowerCase();
        return this.updateF7(controlId, -1, pkValue);
    }

    private final void doUpdateValue(String id, int row, Object value) {
    }

    private void updateValue(String id, int row, Object value) {
        id = id.toLowerCase();
        Control control = (Control)this.getPageView().getPageBody().getControl(id);
        if (control != null && control.isFilterField()) {
            super.updateFrontValue(id, row, value);
            return;
        }
        if (control == null || !control.isF7() || value instanceof ArrayList) {
            this.doUpdateValue(id, row, value);
        } else {
            this.updateF7(id, row, value);
        }
    }

    private void updateValue(String id, Object value) {
        this.updateValue(id, -1, value);
    }

    public void updateControls() {
        if (this.customControlStack.getControls().size() > 0) {
            HashMap<String, Control> _temp = new HashMap<String, Control>();
            for (Map.Entry<String, Control> entry : this.customControlStack.getControls().entrySet()) {
                if (!(entry.getValue() instanceof MixControl)) continue;
                List<Control> updateList = ((MixControl)entry.getValue()).getChilds();
                for (Control control : updateList) {
                    if (this.getPageView().getPageBody().getControl(control.getId()) != null) continue;
                    _temp.put(control.getId(), control);
                }
            }
            if (_temp.size() > 0) {
                this.customControlStack.getControls().putAll(_temp);
                _temp.clear();
                Object var1_1 = null;
            }
        }
    }

    public void setInitView(boolean isInitView) {
        this.isInitView = isInitView;
    }

    @Override
    protected Map<String, Control> getCustomControlStack() {
        return this.customControlStack.getControls();
    }

    public String getParentPageId() {
        return this.parentPageId;
    }

    protected void setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
    }
}

