/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.base;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.occ.ocepfp.common.constant.BillDataType;
import kd.occ.ocepfp.common.entity.SelectedRow;
import kd.occ.ocepfp.core.form.plugin.AbstractExtFormPlugin;
import kd.occ.ocepfp.core.form.util.QueryUtil;
import kd.occ.ocepfp.core.form.view.base.AbstractFormData;
import kd.occ.ocepfp.core.form.view.base.ExtDynamicView;
import kd.occ.ocepfp.core.form.view.base.ExtListView;
import kd.occ.ocepfp.core.metadata.MainMetadata;
import kd.occ.ocepfp.core.metadata.MetadataFactory;
import kd.occ.ocepfp.core.servicehelper.ExtFormServiceHelper;

public class ListFormData
extends AbstractFormData {
    private SelectedRow currentSelectedRow;
    private List<SelectedRow> selectedRows;
    private int recordCount;
    private int totalPage;
    private int page;

    public ListFormData() {
    }

    public ListFormData(String viewId, ExtDynamicView<?> view, AbstractExtFormPlugin plugin) {
        super(viewId, view, plugin);
        this.setNeedCache(false);
        if (BillDataType.Custom.getValue().equalsIgnoreCase(view.getPageView().getBillDataType())) {
            this.initCacheManager(view.getExtCtx(), viewId, view.getPageId());
            this.setNeedCache(true);
        }
    }

    public DynamicObject addEntryRow() {
        return super.addEntryRow(((ExtListView)this.view).getMainDataGridId());
    }

    public DynamicObjectCollection getDynamicObjectCollection() {
        return this.getDataObject().getDynamicObjectCollection(((ExtListView)this.view).getMainDataGridId());
    }

    public final void initSelectionRowInfo(SelectedRow currentSelectedRow, List<SelectedRow> selectedRows) {
        this.currentSelectedRow = currentSelectedRow;
        this.selectedRows = selectedRows;
    }

    public DynamicObject getCurrentSelectedRowData() {
        return this.getCurrentSelectedRowData("");
    }

    public DynamicObject getCurrentSelectedRowData(String selectFields) {
        if (this.currentSelectedRow == null) {
            return null;
        }
        if (this.view.isCustomDataType()) {
            return (DynamicObject)this.getDataObject().getDynamicObjectCollection(((ExtListView)this.view).getMainDataGridId()).get(this.currentSelectedRow.getRow());
        }
        Object pkValue = this.currentSelectedRow.getPkValue();
        return ExtFormServiceHelper.queryOne(((ExtListView)this.view).getPageView().getBaseViewId(), selectFields, pkValue);
    }

    public DynamicObject getCurrentSelectedRowData4ListField() {
        Object pkValue = this.currentSelectedRow.getPkValue();
        MainMetadata metadata = MetadataFactory.getMetadata(this.view.getExtCtx(), this.view.getViewId());
        return ExtFormServiceHelper.queryOne(((ExtListView)this.view).getPageView().getBaseViewId(), QueryUtil.getSelectFieldStr(this.view.getExtCtx(), metadata), pkValue);
    }

    public DynamicObject getCurrentSelectedRowData4BillField() {
        Object pkValue = this.currentSelectedRow.getPkValue();
        return ExtFormServiceHelper.loadSingle(this.view.getExtCtx(), ((ExtListView)this.view).getPageView().getBaseViewId(), pkValue);
    }

    public DynamicObject[] getSelectedRowDatas(String selectFields) {
        if (this.view.isCustomDataType()) {
            return this.getSelectedRowDataByRowId();
        }
        Object[] pkValues = this.getSelectedPKValues();
        return ExtFormServiceHelper.queryList(((ExtListView)this.view).getPageView().getBaseViewId(), selectFields, pkValues);
    }

    public DynamicObject[] getSelectedRowDatas(Object pkValue) {
        return this.getSelectedRowDatas(new Object[]{pkValue});
    }

    public DynamicObject[] getSelectedRowDataByRowId() {
        ArrayList<Object> dataList = new ArrayList<Object>(this.selectedRows.size());
        if (this.isNeedCache()) {
            DynamicObjectCollection dynamicObjectCollection = this.getDynamicObjectCollection();
            for (SelectedRow selectRow : this.selectedRows) {
                dataList.add(dynamicObjectCollection.get(selectRow.getRow()));
            }
        }
        return dataList.toArray(new DynamicObject[dataList.size()]);
    }

    public DynamicObject[] getSelectedRowDatas() {
        Object[] pkValues = this.getSelectedPKValues();
        return this.getSelectedRowDatas(pkValues);
    }

    public DynamicObject[] getSelectedRowDatas(Object[] pkValues) {
        if (this.isNeedCache()) {
            HashSet<String> allPK = new HashSet<String>(pkValues.length);
            for (Object pk : pkValues) {
                allPK.add(pk.toString());
            }
            int max = allPK.size();
            ArrayList<DynamicObject> dataList = new ArrayList<DynamicObject>(max);
            DynamicObjectCollection dynamicObjectCollection = this.getDynamicObjectCollection();
            for (DynamicObject data : dynamicObjectCollection) {
                if (!allPK.contains(data.getPkValue().toString())) continue;
                dataList.add(data);
                if (--max != 0) continue;
                break;
            }
            return dataList.toArray(new DynamicObject[dataList.size()]);
        }
        MainMetadata metadata = MetadataFactory.getMetadata(this.view.getExtCtx(), this.view.getViewId());
        return this.getSelectedRowDatas(QueryUtil.getSelectFieldStr(this.view.getExtCtx(), metadata));
    }

    private Object[] getSelectedPKValues() {
        int length = this.selectedRows != null ? this.selectedRows.size() : 0;
        Object[] pkValues = new Object[length];
        int i = 0;
        if (this.selectedRows != null) {
            for (SelectedRow selectRow : this.selectedRows) {
                pkValues[i++] = selectRow.getPkValue();
            }
        }
        return pkValues;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int recordCount) {
        this.recordCount = recordCount;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setPageInfo(int page, int recordCount, int totalPage) {
        this.setPage(page);
        this.setRecordCount(recordCount);
        this.setTotalPage(totalPage);
    }
}

