/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.Message;
import kd.occ.ocepfp.common.entity.MessageBoxContext;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.plugin.formatter.UpdateValueFormat;
import kd.occ.ocepfp.core.form.view.base.Command;
import kd.occ.ocepfp.core.form.view.base.ShellCommand;
import kd.occ.ocepfp.core.form.view.base.ViewProxy;

public class OperationProxy {
    private ViewProxy viewProxy;
    ShellCommand shellCommand = new ShellCommand();

    public void setViewProxy(ViewProxy viewProxy) {
        this.viewProxy = viewProxy;
        this.shellCommand.setViewProxy(viewProxy);
    }

    public final void addControl(String pageId, Object obj) {
        Command command = new Command();
        command.action = "addControl";
        command.data = obj;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void disableAll(String pageId, boolean isDisable) {
        Command command = new Command();
        command.action = "disableAll";
        HashMap<String, Boolean> data = new HashMap<String, Boolean>(1);
        data.put("isDisable", isDisable);
        command.data = data;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void setControlRequired(String pageId, String controlId, boolean isRequired) {
        Command command = new Command();
        command.action = "setcontrolrequired";
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("controlid", controlId);
        data.put("isrequired", isRequired);
        command.data = data;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void setSelectDataFilter(String pageId, String controlId, String filter) {
        this.execCommand(pageId, "setSelectDataFilter", filter);
    }

    public void setSelectOptions(String pageId, String controlId, Map<String, String> options) {
        this.execCommand(pageId, "setSelectOptions", options);
    }

    public final void updateValue(String pageId, String controlId, Object value) {
        this.updateValue(pageId, controlId, -1, value);
    }

    public final void updateValue(String pageId, String controlId, int row, Object value) {
        Control control = (Control)this.viewProxy.getPageView().getPageBody().getControl(controlId);
        SimpleMap v = new SimpleMap(4);
        if (row >= 0) {
            v.put((Object)"row", (Object)row);
        }
        if ((value = UpdateValueFormat.format(value)) == null) {
            value = control != null && "DataGrid".equalsIgnoreCase(control.getType()) ? new ArrayList(0) : "";
        }
        v.put((Object)controlId, value);
        if (control != null && StringUtil.isNotNull((String)control.getSrcDataGrid())) {
            ArrayList<SimpleMap> dataList = new ArrayList<SimpleMap>();
            dataList.add(v);
            SimpleMap entryValue = new SimpleMap(2);
            entryValue.put((Object)control.getSrcDataGrid(), dataList);
            String key = new StringBuffer(30).append(pageId).append("updateValue").append("_").append(control.getSrcDataGrid()).append(".").append(row).toString();
            this.execGroupCommand(pageId, "updateValue", key, controlId, entryValue);
        } else {
            String key = new StringBuffer(30).append(pageId).append("updateValue").append("_").append(".").append(row).toString();
            this.execGroupCommand(pageId, "updateValue", key, controlId, v);
        }
    }

    public final void doDataChange(String pageId, String controlId, int row) {
        SimpleMap v = new SimpleMap(4);
        if (row >= 0) {
            v.put((Object)"row", (Object)row);
        }
        String key = new StringBuffer(30).append(pageId).append("dci").append("_").append(".").append(row).toString();
        this.execGroupCommand(pageId, "dci", key, controlId, v);
    }

    public final Command bindData(String pageId, Object value, boolean isAppend) {
        Command command = new Command();
        command.action = isAppend ? "bindAppendData" : "bindData";
        command.data = value;
        command.pageId = pageId;
        command.setTop(true);
        this.shellCommand.addFirstAfterTop(command);
        return command;
    }

    protected final Command execGroupCommand(String pageId, String action, String groupKey, String controlId, Object value) {
        Command command = new Command();
        command.action = action;
        command.data = value;
        command.pageId = pageId;
        command.groupKey = groupKey;
        this.shellCommand.addGroup(controlId, command);
        return command;
    }

    protected final Command execGroupCommandForFirst(String pageId, String action, String groupKey, String controlId, Object value) {
        Command command = new Command();
        command.action = action;
        command.data = value;
        command.pageId = pageId;
        command.groupKey = groupKey;
        command.setTop(true);
        this.shellCommand.addGroup4First(controlId, command);
        return command;
    }

    public final Command execCommandForFirstAfterTop(String pageId, String action, Object value) {
        Command command = new Command();
        command.action = action;
        command.data = value;
        command.pageId = pageId;
        command.setTop(true);
        this.shellCommand.addFirst(command);
        return command;
    }

    public final Command execCommandForFirst(String pageId, String action, Object value) {
        Command command = new Command();
        command.action = action;
        command.data = value;
        command.pageId = pageId;
        command.setTop(true);
        this.shellCommand.addFirst(command);
        return command;
    }

    public final Command execCommand(String pageId, String action, Object value) {
        Command command = new Command();
        command.action = action;
        command.data = value;
        command.pageId = pageId;
        this.shellCommand.add(command);
        return command;
    }

    public final void showMessage(List<Message> messages, MessageBoxContext messageBoxContext, String pageId, CallBackArgu callBackArgu) {
        Command command = new Command();
        command.action = "showMessage";
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("messageBoxType", messageBoxContext.getMessageBoxType().getValue());
        data.put("messageType", messageBoxContext.getMessageType().getValue());
        if (messageBoxContext.getDuration() >= 0) {
            data.put("duration", messageBoxContext.getDuration());
        }
        data.put("message", messages);
        data.put("pageId", pageId);
        if (callBackArgu != null) {
            data.put("callback", callBackArgu);
        }
        command.data = data;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void showView(String pageId, OpenParam showViewParam) {
        Command command = new Command();
        command.action = "showView";
        command.data = showViewParam;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void sendRedirect(String url) {
        Command command = new Command();
        command.action = "sendredirect";
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("url", url);
        command.data = data;
        this.shellCommand.add(command);
    }

    public final void sendRedirectPost(String url, Map<String, Object> jsonParam) {
        Command command = new Command();
        command.action = "sendredirectpost";
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("url", url);
        data.put("param", jsonParam);
        command.data = data;
        this.shellCommand.add(command);
    }

    public final void closeView(String pageId, String viewId) {
        Command command = new Command();
        command.action = "closeView";
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("viewId", viewId);
        command.data = data;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public final void showProgress(String pageId, String progressId, long totalRecords, Long pollTime) {
        Command command = new Command();
        command.action = "showProgress";
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        data.put("progressId", progressId);
        data.put("pageId", pageId);
        data.put("totalRecords", totalRecords);
        if (pollTime != null) {
            data.put("pollTime", pollTime);
        }
        command.data = data;
        command.pageId = pageId;
        this.shellCommand.add(command);
    }

    public String toString() {
        return this.shellCommand.toString();
    }

    public final void executePageJs(String pageId, String method) {
        Command command = new Command();
        command.pageId = pageId;
        command.action = "executePageJs";
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("pageId", pageId);
        data.put("method", method);
        command.data = data;
        this.shellCommand.add(command);
    }

    public List<Command> getOperation() {
        return this.shellCommand.getOperation();
    }
}

