/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.base;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.occ.ocepfp.common.entity.CallBackArgu;
import kd.occ.ocepfp.common.entity.ExtDynamicObject;
import kd.occ.ocepfp.common.entity.ExtResponse;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.entity.LoadViewResponse;
import kd.occ.ocepfp.common.entity.Message;
import kd.occ.ocepfp.common.entity.MessageBoxContext;
import kd.occ.ocepfp.common.entity.MessageBoxType;
import kd.occ.ocepfp.common.entity.MessageStatus;
import kd.occ.ocepfp.common.entity.MessageType;
import kd.occ.ocepfp.common.entity.OpenAuxptyParam;
import kd.occ.ocepfp.common.entity.OpenParam;
import kd.occ.ocepfp.common.entity.RowSelectionStatus;
import kd.occ.ocepfp.common.entity.SimpleMap;
import kd.occ.ocepfp.common.entity.UserSettingInfo;
import kd.occ.ocepfp.common.util.DynamicObjectUtil;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.core.form.control.Control;
import kd.occ.ocepfp.core.form.control.controls.Auxpty;
import kd.occ.ocepfp.core.form.control.controls.SelectData;
import kd.occ.ocepfp.core.form.dispatch.ViewActionDispatcher;
import kd.occ.ocepfp.core.form.event.CustomEvent;
import kd.occ.ocepfp.core.form.util.ParentViewCacheUtil;
import kd.occ.ocepfp.core.form.view.base.OperationProxy;
import kd.occ.ocepfp.core.form.view.base.ViewFactory;
import kd.occ.ocepfp.core.form.view.parser.PageView;
import kd.occ.ocepfp.core.form.view.parser.ViewObjectConverter;

public abstract class ViewProxy {
    private OperationProxy operationProxy;

    public ViewProxy() {
        this.init();
    }

    protected final void init() {
        this.init(new OperationProxy());
    }

    protected void init(OperationProxy operationProxy) {
        this.operationProxy = operationProxy;
        this.operationProxy.setViewProxy(this);
    }

    public void bindData(Object dataObject) {
        this.bindData(dataObject, false);
    }

    public void bindData(Object dataObject, boolean isAppend) {
        this.bindData(this.getPageId(), dataObject, isAppend);
    }

    public void bindData(String pageId, Object dataObject) {
        this.bindData(pageId, dataObject, false);
    }

    public void bindData(String pageId, Object dataObject, boolean isAppend) {
        this.operationProxy.bindData(pageId, dataObject, isAppend);
    }

    public void addControl(String pageId, Control control) {
        this.operationProxy.addControl(pageId, control);
    }

    public void disableAll(String pageId) {
        this.operationProxy.disableAll(pageId, true);
    }

    public void disableAll(String pageId, boolean isDisable) {
        this.operationProxy.disableAll(pageId, isDisable);
    }

    public void setRequired(String pageId, String controlId, boolean isRequired) {
        controlId = controlId.toLowerCase();
        Control control = (Control)this.getPageView().getPageBody().getControl(controlId);
        String srcDataGrid = StringUtil.getEmptyString();
        if (control != null) {
            srcDataGrid = control.getSrcDataGrid();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put(controlId, isRequired);
        data.put("datagrid", StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid.toLowerCase());
        this.getOperationProxy().execCommand(this.getPageId(), "setrequired", data);
    }

    public void setControlRequired(String pageId, String controlId, boolean isRequired) {
        this.operationProxy.setControlRequired(pageId, controlId, isRequired);
    }

    public void setSelectDataFilter(String pageId, String controlId, String filter) {
        this.operationProxy.setSelectDataFilter(pageId, controlId, filter);
    }

    public void setSelectOptions(String pageId, String controlId, Map<String, String> options) {
        this.operationProxy.setSelectOptions(pageId, controlId, options);
    }

    protected void updateFrontValue(String pageId, String id, Object value) {
        this.operationProxy.updateValue(pageId, id.toLowerCase(), value);
    }

    protected void updateValue(String pageId, String id, Object value) {
        this.operationProxy.updateValue(pageId, id.toLowerCase(), value);
    }

    public void updateValue(String dataGridId, String groupValue, String controlId, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put("d", dataGridId);
        data.put("g", groupValue);
        data.put("c", controlId);
        data.put("v", value);
        this.operationProxy.execCommand(this.getPageId(), "ufv", data);
    }

    public void updateFrontValue(String id, Object value) {
        this.updateFrontValue(id, value, false);
    }

    public void updateFrontValue(String id, Object value, boolean doDataChange) {
        Control control = (Control)this.getPageView().getPageBody().getControl(id);
        if (control != null && control.isF7() && value instanceof DynamicObject) {
            DynamicObject p = (DynamicObject)value;
            String numberProp = ((BasedataEntityType)p.getDataEntityType()).getNumberProperty();
            String nameProp = ((BasedataEntityType)p.getDataEntityType()).getNameProperty();
            this.updateFrontF7(id, p.getString("id"), p.getString(numberProp), p.getString(nameProp), p.getString(((SelectData)control).getDisplayField()));
            return;
        }
        this.updateFrontValue(this.getPageId(), id, value);
    }

    public void updateFilterValue(String id, Object value) {
        this.updateFrontValue(id.toLowerCase(), value);
    }

    public void updateFrontValue(String id, int row, Object value) {
        this.updateFrontValue(id, row, value, false);
    }

    public void updateFrontValue(String id, int row, Object value, boolean doDataChange) {
        this.updateFrontValuePrivate(id, row, value, doDataChange);
    }

    private void updateFrontValuePrivate(String id, int row, Object value, boolean doDataChange) {
        this.operationProxy.updateValue(this.getPageId(), id.toLowerCase(), row, value);
    }

    public void startCountDown(String id, long timer) {
        id = id.toLowerCase();
        HashMap<String, Long> data = new HashMap<String, Long>(4);
        data.put(id, timer);
        this.operationProxy.execCommand(this.getPageId(), "startCountDown", data);
    }

    public void startCountDown(String id) {
        id = id.toLowerCase();
        HashMap<String, Integer> data = new HashMap<String, Integer>(4);
        data.put(id, -1);
        this.operationProxy.execCommand(this.getPageId(), "startCountDown", data);
    }

    public void stopCountDown(String id) {
        this.startCountDown(id, 0L);
    }

    public void updateBubble(String id, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>(4);
        data.put(id.toLowerCase(), value);
        this.operationProxy.execCommand(this.getPageId(), "updateBubble", data);
    }

    public void updateFrontF7(String controlId, int row, String pkValue, String billNo, String name, Object display) {
        this.updateFrontF7(controlId.toLowerCase(), row, pkValue, billNo, name, display, null);
    }

    public void updateFrontF7(String controlId, int row, String pkValue, String billNo, String name, Object display, Map<String, Object> linkMapData) {
        SimpleMap v = new SimpleMap(4);
        v.put((Object)"id", (Object)pkValue);
        v.put((Object)"billNo", (Object)billNo);
        v.put((Object)"name", (Object)name);
        if (linkMapData != null) {
            v.putAll(linkMapData);
        }
        if (row > 0) {
            v.put((Object)"row", (Object)row);
        }
        v.put((Object)"_display", display);
        this.updateFrontValuePrivate(controlId.toLowerCase(), row, v, false);
    }

    public void updateFrontF7(String controlId, String pkValue, String billNo, String name, Object display, Map<String, Object> linkMapData) {
        this.updateFrontF7(controlId.toLowerCase(), -1, pkValue, billNo, name, display, linkMapData);
    }

    public void updateFrontF7(String controlId, String pkValue, String billNo, String name, Object display) {
        this.updateFrontF7(controlId, -1, pkValue, billNo, name, display, null);
    }

    public void showMessage(String message) {
        this.showMessage(message, MessageBoxType.Confirm);
    }

    public void showMessage(String message, CallBackArgu callBackArgu) {
        this.showMessage(message, MessageBoxType.Confirm, callBackArgu);
    }

    public void showToastMessage(final String message, int duration) {
        ArrayList<Message> messagetList = new ArrayList<Message>(){
            {
                this.add(new Message(message));
            }
        };
        MessageBoxContext messagetBoxContext = MessageBoxContext.newInstance();
        messagetBoxContext.setMessageBoxType(MessageBoxType.Toast);
        messagetBoxContext.setDuration(duration);
        this.operationProxy.showMessage((List<Message>)messagetList, messagetBoxContext, this.getPageId(), null);
    }

    public void showToastMessage(String message) {
        this.showToastMessage(message, 2000);
    }

    public void showMessage(final String message, MessageBoxType messageBoxType, CallBackArgu callBackArgu) {
        ArrayList<Message> messagetList = new ArrayList<Message>(){
            {
                this.add(new Message(message));
            }
        };
        MessageBoxContext messagetBoxContext = MessageBoxContext.newInstance();
        messagetBoxContext.setMessageBoxType(messageBoxType);
        this.operationProxy.showMessage((List<Message>)messagetList, messagetBoxContext, this.getPageId(), callBackArgu);
    }

    public void showMessage(String message, MessageBoxType messageBoxType) {
        this.showMessage(message, messageBoxType, null);
    }

    public void showMessage(String number, String message, MessageStatus status) {
        this.showMessage(number, message, status, null);
    }

    public void showMessage(final String number, final String message, final MessageStatus status, CallBackArgu callBackArgu) {
        ArrayList<Message> messagetList = new ArrayList<Message>(){
            {
                this.add(new Message(number, message, status.getValue()));
            }
        };
        MessageBoxContext messagetBoxContext = MessageBoxContext.newInstance();
        messagetBoxContext.setMessageBoxType(MessageBoxType.Confirm);
        messagetBoxContext.setMessageType(MessageType.Alert);
        this.operationProxy.showMessage((List<Message>)messagetList, messagetBoxContext, this.getPageId(), callBackArgu);
    }

    public void showF7(OpenParam openParam) {
        this.showF7(openParam, false);
    }

    public void showF7(OpenParam openParam, boolean isMultiple) {
        openParam.put((Object)"f7", (Object)true);
        openParam.put((Object)"multiple", (Object)isMultiple);
        openParam.setTarget(OpenParam.OpenTarget.Pop);
        this.showView(openParam);
    }

    public void showView(OpenParam openParam) {
        this.showView(this.getPageId(), openParam);
    }

    public void showAuxptyView(String updateControl, Map<String, Object> param) {
        Auxpty auxpty = (Auxpty)this.getPageView().getPageBody().getControl(updateControl);
        this.showAuxptyView(updateControl, auxpty.getLinkedView(), param);
    }

    public void showAuxptyView(String updateControl, String showViewId, Map<String, Object> param) {
        OpenAuxptyParam openParam = new OpenAuxptyParam();
        openParam.setViewId(showViewId);
        openParam.setParentControlId(updateControl);
        for (Map.Entry<String, Object> entry : param.entrySet()) {
            openParam.addCustomParam(entry.getKey(), entry.getValue());
        }
        this.showView(this.getPageId(), (OpenParam)openParam);
    }

    public void updateTheme(UserSettingInfo userSetting) {
        this.operationProxy.execCommand(this.getPageId(), "updateTheme", userSetting);
    }

    public void setDefaultFilterValue(String id, String value) {
        id = id.toLowerCase();
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put(id, value);
        this.operationProxy.execCommand(this.getPageId(), "setdfv", data);
    }

    public void showCloudView(OpenParam openParam, String billTypeId, String templateId) {
        openParam.put((Object)"ty", (Object)"c");
        if (billTypeId != null) {
            openParam.put((Object)"tp", (Object)templateId);
            openParam.put((Object)"bt", (Object)billTypeId);
        }
        this.showView(openParam);
    }

    public void showCloudBillView(OpenParam openParam) {
        this.showCloudView(openParam, null, null);
    }

    public void showCloudListView(OpenParam openParam) {
        this.showCloudView(openParam, "list", "bos_list");
    }

    public void showView(String pageId, OpenParam openParam) {
        openParam.put((Object)"p", this.getExtCtx().getForm().get((Object)"p"));
        openParam.put((Object)"store", this.getExtCtx().getForm().get((Object)"store"));
        openParam.put((Object)"device", (Object)this.getExtCtx().getForm().getDevice());
        if (StringUtil.isNotNull((String)openParam.getViewId()) && !openParam.isCloudBill()) {
            PageView pageView;
            if (openParam.isShowTitle() && StringUtil.isNull((String)openParam.getTitle()) && (pageView = ViewFactory.get(this.getExtCtx(), openParam.getViewId())) != null) {
                openParam.setTitle(pageView.getName());
            }
            if (!openParam.isAsync()) {
                ExtResponse response = ViewActionDispatcher.dispatchLoadView(openParam);
                openParam.put((Object)"controls", (Object)response);
            }
        }
        ParentViewCacheUtil.setParentViewInfo(openParam.getPageId(), this.getPageId(), this.getPageView().getViewId(), this.getPageView().getBillViewType());
        openParam.setParenPageId(this.getPageId());
        this.operationProxy.showView(pageId, openParam);
    }

    public void refresh(String pageId) {
        this.operationProxy.execCommand(pageId, "refresh", "");
    }

    public void refresh() {
        this.refresh(this.getPageId());
    }

    protected void addEntryRow(String entryId) {
        this.getOperationProxy().execCommand(this.getPageId(), "addEntryRow", this.createControlData(entryId, null));
    }

    protected void addEntryRow(String entryId, Object rowData) {
        this.getOperationProxy().execCommand(this.getPageId(), "addEntryRow", this.createControlData(entryId, rowData));
    }

    protected void insertEntryRow(String entryId, Object rowData, int row) {
        this.getOperationProxy().execCommand(this.getPageId(), "insertEntryRow", this.createControlData(entryId, rowData, row));
    }

    protected void delEntryRow(String entryId, Object row) {
        this.getOperationProxy().execCommand(this.getPageId(), "delEntryRow", this.createControlData(entryId, row));
    }

    public void dropSelectData(String controlId, Object dataList) {
        this.getOperationProxy().execCommand(this.getPageId(), "dropSelectData", dataList);
    }

    public void loadAddressControldata(String controlId, Object dataList) {
        this.getOperationProxy().execCommand(this.getPageId(), "addressControldata", dataList);
    }

    public void updateAddressCountry(String controlId, Object dataList) {
        this.getOperationProxy().execCommand(this.getPageId(), "updateAddressCountry", dataList);
    }

    public void loadAddressDataLevel(String controlId, Object dataList) {
        this.getOperationProxy().execCommand(this.getPageId(), "addressDataLevel", dataList);
    }

    public void showProgress(String pageId, String progressId, long totalRecords) {
        this.operationProxy.showProgress(pageId, progressId, totalRecords, null);
    }

    public void showProgress(String pageId, String progressId, long totalRecords, long pollTime) {
        this.operationProxy.showProgress(pageId, progressId, totalRecords, pollTime);
    }

    public void updateRecordCount(int recordCount) {
        this.operationProxy.execCommand(this.getPageId(), "updateRecordCount", recordCount);
    }

    public void sendRedirect(String url) {
        this.operationProxy.sendRedirect(url);
    }

    public void sendRedirectPost(String url, Map<String, Object> jsonParam) {
        this.operationProxy.sendRedirectPost(url, jsonParam);
    }

    public void closeView() {
        this.closeView(this.getPageId(), this.getPageView().getViewId());
    }

    public void closeView(String pageId, String viewId) {
        this.operationProxy.closeView(pageId, viewId);
    }

    public void closeView(String pageId) {
        this.operationProxy.closeView(pageId, this.getPageView().getViewId());
    }

    public void closePopPanel(String popPanelId) {
        SimpleMap data = new SimpleMap(2);
        data.put((Object)"id", (Object)popPanelId);
        this.getOperationProxy().execCommand(this.getPageId(), "closepp", data);
    }

    public OperationProxy getOperationProxy() {
        return this.operationProxy;
    }

    public OperationProxy setOperationProxy(OperationProxy operationProxy) {
        this.operationProxy = operationProxy;
        return this.operationProxy;
    }

    public void executePageJs(String pageId, String method) {
        this.operationProxy.executePageJs(pageId, method);
    }

    public void resetView() {
        this.operationProxy.getOperation().clear();
    }

    public void setRowSelection(String dataGridId, int row, boolean isSelected) {
        this.setRowSelection(dataGridId, row, isSelected, true);
    }

    public void setRowSelection(String dataGridId, int row, boolean isSelected, boolean isCallBack) {
        final RowSelectionStatus rowSelectionStatus = new RowSelectionStatus(row, isSelected);
        this.setRowSelection(dataGridId.toLowerCase(), (List<RowSelectionStatus>)new ArrayList<RowSelectionStatus>(){
            {
                this.add(rowSelectionStatus);
            }
        }, isCallBack);
    }

    public void setRowSelection(String dataGridId, List<RowSelectionStatus> rowSelectionStatusList, boolean isCallBack) {
        SimpleMap v = new SimpleMap(2);
        v.put((Object)dataGridId.toLowerCase(), rowSelectionStatusList);
        v.put((Object)"icb", (Object)isCallBack);
        this.operationProxy.execCommand(this.getPageId(), "setRowSelection", v);
    }

    public void setRowSelection(String dataGridId, List<RowSelectionStatus> rowSelectionStatusList) {
        this.setRowSelection(dataGridId, rowSelectionStatusList, true);
    }

    public void setSelectAll(String dataGridId, boolean isSelectedAll) {
        SimpleMap v = new SimpleMap(2);
        v.put((Object)dataGridId.toLowerCase(), (Object)(isSelectedAll ? 1 : 0));
        this.operationProxy.execCommand(this.getPageId(), "setSelectAll", v);
    }

    public void updateRadioGroupOptions(String controlId, List<ExtDynamicObject> datas) {
        SimpleMap v = new SimpleMap(2);
        ArrayList<SimpleMap> values = new ArrayList<SimpleMap>(datas.size());
        for (ExtDynamicObject data : datas) {
            SimpleMap value = new SimpleMap(2);
            value.put((Object)"name", data.get((Object)"name"));
            value.put((Object)"value", data.get((Object)"value"));
            values.add(value);
        }
        if (values != null && values.size() > 0) {
            ((SimpleMap)values.get(0)).put((Object)"checked", (Object)true);
        }
        v.put((Object)"controlId", (Object)controlId);
        v.put((Object)"options", values);
        this.operationProxy.execCommand(this.getPageId(), "updateoptions", v);
    }

    public void updateControlName(String controlId, String name) {
        this.updateControlName(controlId, name, -1);
    }

    public void updateControlName(String controlId, String name, int row) {
        Control control;
        SimpleMap data = new SimpleMap(2);
        data.put((Object)controlId.toLowerCase(), (Object)name);
        if (row > -1) {
            data.put((Object)"r", (Object)row);
        }
        if ((control = (Control)this.getPageView().getPageBody().getControl(controlId)) != null && StringUtil.isNotNull((String)control.getSrcDataGrid())) {
            data.put((Object)"g", (Object)control.getSrcDataGrid());
        }
        this.operationProxy.execCommand(this.getPageId(), "updateControlName", data);
    }

    public void setActiveById(String controlId, String activeId) {
        this.setActiveById(controlId, activeId, true);
    }

    public void setActiveByValue(String controlId, String activeValue) {
        this.setActiveByValue(controlId, activeValue, true);
    }

    public void setActiveById(String controlId, String activeId, boolean reloadData) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(2);
        customParam.put("rd", reloadData);
        this.setActive(controlId, activeId, "id", customParam);
    }

    public void setActiveById(String controlId, String activeId, Map<String, Object> customParam) {
        this.setActive(controlId.toLowerCase(), activeId.toLowerCase(), "id", customParam);
    }

    public void setActiveByValue(String controlId, String activeId, boolean reloadData) {
        HashMap<String, Object> customParam = new HashMap<String, Object>(2);
        customParam.put("rd", reloadData);
        this.setActive(controlId, activeId, "", customParam);
    }

    private void setActive(String controlId, String activeValue, String findMode, Map<String, Object> customParam) {
        SimpleMap value = new SimpleMap(2);
        value.put((Object)"v", (Object)activeValue);
        value.put((Object)"f", (Object)findMode);
        value.put((Object)"o", (Object)"a");
        if (customParam != null) {
            value.putAll(customParam);
        }
        SimpleMap data = new SimpleMap(2);
        data.put((Object)controlId.toLowerCase(), (Object)value);
        this.operationProxy.execCommand(this.getPageId(), "setActive", data);
    }

    public void invokeGlobalAction(String controlId, String action, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("action", action);
        data.put("value", value);
        data.put("id", controlId.toLowerCase());
        this.operationProxy.execCommand(this.getPageId(), "invokeGlobalAction", data);
    }

    public void invokeGlobalAction(String controlId, String action) {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("action", action);
        data.put("id", controlId.toLowerCase());
        data.put("value", "");
        this.operationProxy.execCommand(this.getPageId(), "invokeGlobalAction", data);
    }

    public void setPreventDefault(String controlId, boolean isPreventDefault) {
        if (isPreventDefault) {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("id", StringUtil.toLowerCase((String)controlId));
            data.put("value", isPreventDefault);
            this.operationProxy.execCommand(this.getPageId(), "setPreventDefault", data);
        }
    }

    private final Map<String, Object> createControlData(String controlId, Object data) {
        return this.createControlData(controlId, data, -1);
    }

    private final Map<String, Object> createControlData(String controlId, Object data, int row) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put(controlId, DynamicObjectUtil.convertToSimpleMap((Object)data));
        if (row >= 0) {
            param.put("row", row);
        }
        return param;
    }

    public final LoadViewResponse toViewObject(boolean isModifiedInInitView, String customPageTitle) {
        return ViewObjectConverter.getInitViewData(this.getExtCtx(), this.getPageView(), this.getCustomControlStack(), this.operationProxy.getOperation(), isModifiedInInitView, customPageTitle);
    }

    public abstract String getPageId();

    public abstract ExtWebContext getExtCtx();

    public abstract PageView getPageView();

    protected abstract Map<String, Control> getCustomControlStack();

    public void updateAdminDivision(String propertyName, Object divisionValues) {
        this.operationProxy.updateValue(this.getPageId(), propertyName.toLowerCase(), -1, divisionValues);
    }

    public void updateFlexMetaData(String controlId, Object value) {
        this.getOperationProxy().execCommand(this.getPageId(), "updateSkuValue", value);
    }

    public void putLocalStorage(String storageKey, Map<String, Object> value, boolean moveFirstIfExist, int maxSize) {
        this.putLocalStoragePrivate(storageKey, value, moveFirstIfExist, maxSize, false);
    }

    public void putLocalStorage(String storageKey, Map<String, Object> value, int maxSize) {
        this.putLocalStoragePrivate(storageKey, value, false, maxSize, false);
    }

    public void putLocalStorage(String storageKey, List<Object> value, int maxSize) {
        this.putLocalStoragePrivate(storageKey, value, false, maxSize, false);
    }

    public void putLocalStorage(String storageKey, List<Object> value, boolean moveFirstIfExist, int maxSize) {
        this.putLocalStoragePrivate(storageKey, value, moveFirstIfExist, maxSize, false);
    }

    public void putLocalStorage(String storageKey, String value) {
        this.putLocalStoragePrivate(storageKey, value, false, 1, true);
    }

    public void putLocalStoragePrivate(String storageKey, Object value, boolean moveFirstIfExist, int maxSize, boolean sendBackByRequest) {
        HashMap<String, Object> param = new HashMap<String, Object>(2);
        param.put("sk", storageKey);
        param.put("v", value);
        param.put("ms", maxSize);
        param.put("m", moveFirstIfExist ? "1" : "0");
        param.put("sd", sendBackByRequest);
        this.getOperationProxy().execCommand(this.getPageId(), "putLStorage", param);
    }

    public void setAuxptyListValue(String propertyName, Object value) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put(propertyName, value);
        this.getOperationProxy().execCommandForFirst(this.getPageId(), "setAuxptyListValue", data);
    }

    public void updatePriceFormat(String currencyId, int pricePrecision, int amountPrecision, String symbol, List<String> fieldList) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", currencyId);
        data.put("pp", pricePrecision);
        data.put("ap", amountPrecision);
        data.put("sl", symbol);
        data.put("f", fieldList);
        this.getOperationProxy().execCommandForFirst(this.getPageId(), "UpPFmt", data);
    }

    public void updateQtyFormat(String currencyId, int precision, int amountPrecision, String symbol, List<String> fieldList) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("id", currencyId);
        data.put("ap", amountPrecision);
        data.put("sl", symbol);
        data.put("f", fieldList);
        this.getOperationProxy().execCommandForFirst(this.getPageId(), "UpPFmt", data);
    }

    public void pay(String payType, Map<String, String> payData) {
        this.pay(payType, payData, false);
    }

    public void pay(String payType, Map<String, String> payData, boolean isdebug) {
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        if (isdebug) {
            data.put("debug", isdebug);
        }
        data.put("py", payType);
        data.put("pd", payData);
        this.getOperationProxy().execCommandForFirst(this.getPageId(), "pay", data);
    }

    public void wxPay(Map<String, String> payData) {
        this.wxPay(payData, false);
    }

    public void wxPay(Map<String, String> payData, boolean isdebug) {
        this.pay("wx", payData, false);
    }

    public void aliPay(Map<String, String> payData) {
        this.aliPay(payData, false);
    }

    public void aliPay(Map<String, String> payData, boolean isdebug) {
        this.pay("ali", payData, isdebug);
    }

    public void updateEnableSpecValue(String controlId, Object value) {
        this.getOperationProxy().execCommand(this.getPageId(), "updateEnableGroup", value);
    }

    public void initShareUrl(String controlId, String url) {
        this.initShareUrl(controlId, url, null, null);
    }

    public void initShareUrl(String controlId, String url, String title, String pic) {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("c", controlId);
        data.put("u", url);
        if (StringUtil.isNotNull((String)title)) {
            data.put("t", title);
        }
        if (StringUtil.isNotNull((String)pic)) {
            data.put("p", pic);
        }
        this.getOperationProxy().execCommand(this.getPageId(), "ishareurl", data);
    }

    public void initGlobalShareUrl(String url, String title, String pic) {
        HashMap<String, String> data = new HashMap<String, String>(2);
        data.put("m", "g");
        data.put("u", url);
        if (StringUtil.isNotNull((String)title)) {
            data.put("t", title);
        }
        if (StringUtil.isNotNull((String)pic)) {
            data.put("p", pic);
        }
        this.getOperationProxy().execCommand(this.getPageId(), "ishareurl", data);
    }

    public void disable(String controlId, boolean isDisable) {
        this.disable(controlId, isDisable, -1);
    }

    public void initDisabled(String controlId, boolean isDisable) {
        this.disable(controlId, isDisable, -1, true);
    }

    public void disable(String controlId, boolean isDisable, int row) {
        this.disable(controlId, isDisable, row, false);
    }

    private void disable(String controlId, boolean isDisable, int row, boolean isInit) {
        Control control = (Control)this.getPageView().getPageBody().getControl(controlId);
        String srcDataGrid = StringUtil.getEmptyString();
        if (control != null) {
            srcDataGrid = control.getSrcDataGrid();
        }
        this.disable(controlId, srcDataGrid, isDisable, row, isInit);
    }

    public void disableGridSelBox(String dataGridId, boolean isDisable, int row) {
        this.disable("listselection", dataGridId, isDisable, row, false);
    }

    private void disable(String controlId, String srcDataGrid, boolean isDisable, int row, boolean isInit) {
        SimpleMap data = new SimpleMap();
        data.put((Object)"row", (Object)row);
        data.put((Object)controlId, (Object)isDisable);
        data.put((Object)"datagrid", (Object)(StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid));
        String key = new StringBuffer(30).append(this.getPageId()).append("disable").append("_").append(StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid).append(".").append(row).toString();
        if (isInit) {
            this.getOperationProxy().execGroupCommandForFirst(this.getPageId(), "disable", key, controlId, data);
        } else {
            this.getOperationProxy().execGroupCommand(this.getPageId(), "disable", key, controlId, data);
        }
    }

    public void hide(String controlId, boolean isHidden) {
        this.hide(controlId, isHidden, -1);
    }

    public void visibility(String controlId, boolean isHidden) {
        this.hide(controlId, isHidden, true);
    }

    public void hide(String controlId, boolean isHidden, boolean visibility) {
        this.hide(controlId, isHidden, visibility, -1);
    }

    public void hide(String controlId, boolean isHidden, int row) {
        this.hide(controlId, isHidden, false, row);
    }

    public void hide(String controlId, boolean isHidden, boolean visibility, int row) {
        controlId = controlId.toLowerCase();
        Control control = (Control)this.getPageView().getPageBody().getControl(controlId);
        String srcDataGrid = StringUtil.getEmptyString();
        if (control != null) {
            srcDataGrid = control.getSrcDataGrid();
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("row", row);
        data.put("visibility", visibility);
        data.put(controlId, isHidden);
        data.put("datagrid", StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid.toLowerCase());
        this.getOperationProxy().execCommand(this.getPageId(), "hidden", data);
    }

    public void hideGroupFooter(String groupKey, String controlId, boolean isHidden) {
        controlId = controlId.toLowerCase();
        Control control = (Control)this.getPageView().getPageBody().getControl(controlId);
        String srcDataGrid = StringUtil.getEmptyString();
        if (control != null) {
            srcDataGrid = control.getSrcDataGrid();
        }
        SimpleMap data = new SimpleMap();
        data.put((Object)controlId, (Object)(isHidden ? 1 : 0));
        data.put((Object)"g", (Object)groupKey);
        if (StringUtil.isNotNull((String)srcDataGrid)) {
            data.put((Object)"d", (Object)srcDataGrid);
        }
        String key = new StringBuffer(30).append(this.getPageId()).append("hfv").append("_").append(StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid).append(".").append(groupKey).toString();
        this.getOperationProxy().execGroupCommand(this.getPageId(), "hfv", key, controlId, data);
    }

    public void setMultiple(String controlId, boolean isMultiple) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(controlId, isMultiple);
        this.getOperationProxy().execCommand(this.getPageId(), "setMultiple", data);
    }

    public void setEditable(String controlId, boolean isEditable) {
        this.setEditable(controlId, isEditable, -1);
    }

    public void setEditable(String controlId, boolean isEditable, int row) {
        this.setEditable(controlId, isEditable, row, false);
    }

    private void setEditable(String controlId, boolean isEditable, int row, boolean isInit) {
        Control control = (Control)this.getPageView().getPageBody().getControl(controlId);
        String srcDataGrid = StringUtil.getEmptyString();
        if (control != null) {
            srcDataGrid = control.getSrcDataGrid();
        }
        SimpleMap data = new SimpleMap();
        data.put((Object)"row", (Object)row);
        data.put((Object)controlId, (Object)isEditable);
        data.put((Object)"datagrid", (Object)(StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid));
        String key = new StringBuffer(30).append(this.getPageId()).append("editable").append("_").append(StringUtil.isNull((String)srcDataGrid) ? "" : srcDataGrid).append(".").append(row).toString();
        if (isInit) {
            this.getOperationProxy().execGroupCommandForFirst(this.getPageId(), "editable", key, controlId, data);
        } else {
            this.getOperationProxy().execGroupCommand(this.getPageId(), "editable", key, controlId, data);
        }
    }

    public void addCustomEvent(CustomEvent customEvent) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("eventType", customEvent.getCustomEventType());
        this.getOperationProxy().execCommand(this.getPageId(), "addCEvent", data);
    }

    public void mark(String controlId, List<Object> datas) {
        HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
        data.put(controlId, datas);
        this.getOperationProxy().execCommand(this.getPageId(), "mark", data);
    }
}

