/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocepfp.core.form.view.parser;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.occ.ocepfp.common.entity.ExtWebContext;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocepfp.common.util.XMLUtil;
import kd.occ.ocepfp.core.form.view.parser.JFSBase;
import org.apache.commons.collections.IteratorUtils;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;

public class JfsXMLDiffer
extends JFSBase {
    private ExtWebContext webCtx;

    public static final JfsXMLDiffer getJFSFileDiffer(ExtWebContext webCtx) {
        JfsXMLDiffer jfsFileDiffer = new JfsXMLDiffer();
        jfsFileDiffer.webCtx = webCtx;
        return jfsFileDiffer;
    }

    public final Document diffXML(Document newDocument, Document oldDocument) throws Exception {
        Map<String, Map<String, String>> oldDocMap = this.convertContent2Map(this.webCtx, oldDocument);
        this.diffAttribute(newDocument.getRootElement(), this.getId(newDocument.getRootElement(), ""), true, oldDocMap, "");
        this.diffXML("", newDocument.getRootElement(), oldDocMap, "");
        Document newDocumentWithId = XMLUtil.copy2New((Document)newDocument, (boolean)true);
        return newDocumentWithId;
    }

    private final boolean diffXML(String parentName, Element parentElement, Map<String, Map<String, String>> oldDocMap, String rootElementName) {
        if (StringUtil.isNull((String)rootElementName) && parentElement.getName().equalsIgnoreCase("operations")) {
            rootElementName = parentElement.getName();
        }
        List elementList = IteratorUtils.toList((Iterator)parentElement.elementIterator());
        boolean isChange = false;
        boolean childIsChange = false;
        parentName = this.getId(parentElement, parentName);
        for (Element element : elementList) {
            if (element.nodeCount() > 0) {
                childIsChange = this.diffXML(parentName, element, oldDocMap, rootElementName);
            }
            if (this.diffAttribute(element, parentName, childIsChange, oldDocMap, rootElementName)) {
                isChange = true;
                continue;
            }
            parentElement.remove(element);
        }
        return isChange;
    }

    private final boolean diffAttribute(Element element, String parentName, boolean childIsChange, Map<String, Map<String, String>> oldDocMap, String rootElementName) {
        String id = rootElementName + this.getId(element, parentName);
        Map<String, String> oldAttributes = oldDocMap.get(id);
        if (oldAttributes == null) {
            return true;
        }
        List attributes = IteratorUtils.toList((Iterator)element.attributeIterator());
        boolean isChange = false;
        for (Attribute attribute : attributes) {
            if (attribute.getName().equals("id")) continue;
            if (oldAttributes.get(attribute.getName().toLowerCase()) != null && oldAttributes.get(attribute.getName().toLowerCase()).equals(attribute.getValue())) {
                element.remove(attribute);
                continue;
            }
            isChange = true;
        }
        if (element.getName().equalsIgnoreCase("html")) {
            if (element.getTextTrim().equals(oldAttributes.get("___text___"))) {
                element.setText("");
            } else {
                isChange = true;
            }
        }
        return childIsChange || isChange;
    }

    private final Map<String, Map<String, String>> convertContent2Map(ExtWebContext webCtx, Document document) {
        HashMap<String, Map<String, String>> nodesMap = new HashMap<String, Map<String, String>>();
        if (document != null) {
            Element rootElement = document.getRootElement();
            this.readAttributes("", rootElement, nodesMap, "");
            this.readElement("", rootElement, nodesMap, "");
        }
        return nodesMap;
    }

    private final void readElement(String parentName, Element parentElement, Map<String, Map<String, String>> nodesMap, String rootElementName) {
        Iterator node = parentElement.elementIterator();
        if (StringUtil.isNull((String)parentName)) {
            parentName = this.getId(parentElement, "");
        }
        if (StringUtil.isNull((String)rootElementName) && parentName.equalsIgnoreCase("operations")) {
            rootElementName = parentName;
        }
        while (node.hasNext()) {
            Element element = (Element)node.next();
            this.readAttributes(parentName, element, nodesMap, rootElementName);
            if (element.nodeCount() <= 0) continue;
            this.readElement(rootElementName + this.getId(element, parentName), element, nodesMap, rootElementName);
        }
    }

    private final void readAttributes(String parentName, Element element, Map<String, Map<String, String>> nodesMap, String rootElementName) {
        Iterator attributes = element.attributeIterator();
        HashMap<String, String> attributeMap = new HashMap<String, String>(10);
        while (attributes.hasNext()) {
            Attribute attribute = (Attribute)attributes.next();
            attributeMap.put(attribute.getName().toLowerCase(), attribute.getData().toString());
        }
        if (element.getName().equalsIgnoreCase("html")) {
            attributeMap.put("___text___", element.getTextTrim());
        }
        String id = rootElementName + this.getId(element, parentName);
        nodesMap.put(id, attributeMap);
    }
}

